/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Bioseq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_BIOSEQ_BASE_HPP
#define OBJECTS_SEQ_BIOSEQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_annot;
class CSeq_descr;
class CSeq_id;
class CSeq_inst;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Sequence ********************************
///*
class NCBI_SEQ_EXPORT CBioseq_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBioseq_Base(void);
    // destructor
    virtual ~CBioseq_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CSeq_id > > TId;
    typedef CSeq_descr TDescr;
    typedef CSeq_inst TInst;
    typedef list< CRef< CSeq_annot > > TAnnot;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_descr,
        e_inst,
        e_annot
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// equivalent identifiers
    /// mandatory
    /// typedef list< CRef< CSeq_id > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// descriptors
    /// optional
    /// typedef CSeq_descr TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(TDescr& value);
    TDescr& SetDescr(void);

    /// the sequence data
    /// mandatory
    /// typedef CSeq_inst TInst
    ///  Check whether the Inst data member has been assigned a value.
    bool IsSetInst(void) const;
    /// Check whether it is safe or not to call GetInst method.
    bool CanGetInst(void) const;
    void ResetInst(void);
    const TInst& GetInst(void) const;
    void SetInst(TInst& value);
    TInst& SetInst(void);

    /// optional
    /// typedef list< CRef< CSeq_annot > > TAnnot
    ///  Check whether the Annot data member has been assigned a value.
    bool IsSetAnnot(void) const;
    /// Check whether it is safe or not to call GetAnnot method.
    bool CanGetAnnot(void) const;
    void ResetAnnot(void);
    const TAnnot& GetAnnot(void) const;
    TAnnot& SetAnnot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBioseq_Base(const CBioseq_Base&);
    CBioseq_Base& operator=(const CBioseq_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_id > > m_Id;
    CRef< TDescr > m_Descr;
    CRef< TInst > m_Inst;
    list< CRef< CSeq_annot > > m_Annot;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBioseq_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBioseq_Base::CanGetId(void) const
{
    return true;
}

inline
const CBioseq_Base::TId& CBioseq_Base::GetId(void) const
{
    return m_Id;
}

inline
CBioseq_Base::TId& CBioseq_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CBioseq_Base::IsSetDescr(void) const
{
    return m_Descr.NotEmpty();
}

inline
bool CBioseq_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CBioseq_Base::TDescr& CBioseq_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(1);
    }
    return (*m_Descr);
}

inline
bool CBioseq_Base::IsSetInst(void) const
{
    return m_Inst.NotEmpty();
}

inline
bool CBioseq_Base::CanGetInst(void) const
{
    return true;
}

inline
const CBioseq_Base::TInst& CBioseq_Base::GetInst(void) const
{
    if ( !m_Inst ) {
        const_cast<CBioseq_Base*>(this)->ResetInst();
    }
    return (*m_Inst);
}

inline
CBioseq_Base::TInst& CBioseq_Base::SetInst(void)
{
    if ( !m_Inst ) {
        ResetInst();
    }
    return (*m_Inst);
}

inline
bool CBioseq_Base::IsSetAnnot(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBioseq_Base::CanGetAnnot(void) const
{
    return true;
}

inline
const CBioseq_Base::TAnnot& CBioseq_Base::GetAnnot(void) const
{
    return m_Annot;
}

inline
CBioseq_Base::TAnnot& CBioseq_Base::SetAnnot(void)
{
    m_set_State[0] |= 0x40;
    return m_Annot;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_BIOSEQ_BASE_HPP
