/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Num_enum_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_NUM_ENUM_BASE_HPP
#define OBJECTS_SEQ_NUM_ENUM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// any tags to residues
class NCBI_SEQ_EXPORT CNum_enum_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNum_enum_Base(void);
    // destructor
    virtual ~CNum_enum_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSeqPos TNum;
    typedef list< string > TNames;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_num,
        e_names
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// number of tags to follow
    /// mandatory
    /// typedef TSeqPos TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// the tags
    /// mandatory
    /// typedef list< string > TNames
    ///  Check whether the Names data member has been assigned a value.
    bool IsSetNames(void) const;
    /// Check whether it is safe or not to call GetNames method.
    bool CanGetNames(void) const;
    void ResetNames(void);
    const TNames& GetNames(void) const;
    TNames& SetNames(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNum_enum_Base(const CNum_enum_Base&);
    CNum_enum_Base& operator=(const CNum_enum_Base&);

    // data
    Uint4 m_set_State[1];
    TSeqPos m_Num;
    list< string > m_Names;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNum_enum_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNum_enum_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CNum_enum_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0x3;
}

inline
CNum_enum_Base::TNum CNum_enum_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(0);
    }
    return m_Num;
}

inline
void CNum_enum_Base::SetNum(CNum_enum_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0x3;
}

inline
CNum_enum_Base::TNum& CNum_enum_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Num;
}

inline
bool CNum_enum_Base::IsSetNames(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNum_enum_Base::CanGetNames(void) const
{
    return true;
}

inline
const CNum_enum_Base::TNames& CNum_enum_Base::GetNames(void) const
{
    return m_Names;
}

inline
CNum_enum_Base::TNames& CNum_enum_Base::SetNames(void)
{
    m_set_State[0] |= 0x4;
    return m_Names;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_NUM_ENUM_BASE_HPP
