/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Sparse_seg_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SPARSE_SEG_BASE_HPP
#define OBJECTS_SEQALIGN_SPARSE_SEG_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CScore;
class CSeq_id;
class CSparse_align;
class CSparse_seg_ext;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ==========================================================================
///
/// Sparse-seg follows the semantics of dense-seg and is more optimal for
/// representing sparse multiple alignments
///
/// ==========================================================================
class NCBI_SEQALIGN_EXPORT CSparse_seg_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSparse_seg_Base(void);
    // destructor
    virtual ~CSparse_seg_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TMaster_id;
    typedef vector< CRef< CSparse_align > > TRows;
    typedef vector< CRef< CScore > > TRow_scores;
    typedef vector< CRef< CSparse_seg_ext > > TExt;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_master_id,
        e_rows,
        e_row_scores,
        e_ext
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CSeq_id TMaster_id
    ///  Check whether the Master_id data member has been assigned a value.
    bool IsSetMaster_id(void) const;
    /// Check whether it is safe or not to call GetMaster_id method.
    bool CanGetMaster_id(void) const;
    void ResetMaster_id(void);
    const TMaster_id& GetMaster_id(void) const;
    void SetMaster_id(TMaster_id& value);
    TMaster_id& SetMaster_id(void);

    /// pairwise alignments constituting this multiple alignment
    /// mandatory
    /// typedef vector< CRef< CSparse_align > > TRows
    ///  Check whether the Rows data member has been assigned a value.
    bool IsSetRows(void) const;
    /// Check whether it is safe or not to call GetRows method.
    bool CanGetRows(void) const;
    void ResetRows(void);
    const TRows& GetRows(void) const;
    TRows& SetRows(void);

    /// per-row scores
    /// optional
    /// typedef vector< CRef< CScore > > TRow_scores
    ///  Check whether the Row_scores data member has been assigned a value.
    bool IsSetRow_scores(void) const;
    /// Check whether it is safe or not to call GetRow_scores method.
    bool CanGetRow_scores(void) const;
    void ResetRow_scores(void);
    const TRow_scores& GetRow_scores(void) const;
    TRow_scores& SetRow_scores(void);

    /// index of extra items
    /// optional
    /// typedef vector< CRef< CSparse_seg_ext > > TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    TExt& SetExt(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSparse_seg_Base(const CSparse_seg_Base&);
    CSparse_seg_Base& operator=(const CSparse_seg_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TMaster_id > m_Master_id;
    vector< CRef< CSparse_align > > m_Rows;
    vector< CRef< CScore > > m_Row_scores;
    vector< CRef< CSparse_seg_ext > > m_Ext;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSparse_seg_Base::IsSetMaster_id(void) const
{
    return m_Master_id.NotEmpty();
}

inline
bool CSparse_seg_Base::CanGetMaster_id(void) const
{
    return IsSetMaster_id();
}

inline
const CSparse_seg_Base::TMaster_id& CSparse_seg_Base::GetMaster_id(void) const
{
    if (!CanGetMaster_id()) {
        ThrowUnassigned(0);
    }
    return (*m_Master_id);
}

inline
bool CSparse_seg_Base::IsSetRows(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSparse_seg_Base::CanGetRows(void) const
{
    return true;
}

inline
const CSparse_seg_Base::TRows& CSparse_seg_Base::GetRows(void) const
{
    return m_Rows;
}

inline
CSparse_seg_Base::TRows& CSparse_seg_Base::SetRows(void)
{
    m_set_State[0] |= 0x4;
    return m_Rows;
}

inline
bool CSparse_seg_Base::IsSetRow_scores(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSparse_seg_Base::CanGetRow_scores(void) const
{
    return true;
}

inline
const CSparse_seg_Base::TRow_scores& CSparse_seg_Base::GetRow_scores(void) const
{
    return m_Row_scores;
}

inline
CSparse_seg_Base::TRow_scores& CSparse_seg_Base::SetRow_scores(void)
{
    m_set_State[0] |= 0x10;
    return m_Row_scores;
}

inline
bool CSparse_seg_Base::IsSetExt(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSparse_seg_Base::CanGetExt(void) const
{
    return true;
}

inline
const CSparse_seg_Base::TExt& CSparse_seg_Base::GetExt(void) const
{
    return m_Ext;
}

inline
CSparse_seg_Base::TExt& CSparse_seg_Base::SetExt(void)
{
    m_set_State[0] |= 0x40;
    return m_Ext;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPARSE_SEG_BASE_HPP
