/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Sparse_seg_ext_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SPARSE_SEG_EXT_BASE_HPP
#define OBJECTS_SEQALIGN_SPARSE_SEG_EXT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CSparse_seg_ext_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSparse_seg_ext_Base(void);
    // destructor
    virtual ~CSparse_seg_ext_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TIndex;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_index
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    ///seg-ext SET OF {
    ///    index INTEGER,
    ///    data User-field
    /// }
    /// mandatory
    /// typedef int TIndex
    ///  Check whether the Index data member has been assigned a value.
    bool IsSetIndex(void) const;
    /// Check whether it is safe or not to call GetIndex method.
    bool CanGetIndex(void) const;
    void ResetIndex(void);
    TIndex GetIndex(void) const;
    void SetIndex(TIndex value);
    TIndex& SetIndex(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSparse_seg_ext_Base(const CSparse_seg_ext_Base&);
    CSparse_seg_ext_Base& operator=(const CSparse_seg_ext_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Index;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSparse_seg_ext_Base::IsSetIndex(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSparse_seg_ext_Base::CanGetIndex(void) const
{
    return IsSetIndex();
}

inline
void CSparse_seg_ext_Base::ResetIndex(void)
{
    m_Index = 0;
    m_set_State[0] &= ~0x3;
}

inline
CSparse_seg_ext_Base::TIndex CSparse_seg_ext_Base::GetIndex(void) const
{
    if (!CanGetIndex()) {
        ThrowUnassigned(0);
    }
    return m_Index;
}

inline
void CSparse_seg_ext_Base::SetIndex(CSparse_seg_ext_Base::TIndex value)
{
    m_Index = value;
    m_set_State[0] |= 0x3;
}

inline
CSparse_seg_ext_Base::TIndex& CSparse_seg_ext_Base::SetIndex(void)
{
#ifdef _DEBUG
    if (!IsSetIndex()) {
        memset(&m_Index,UnassignedByte(),sizeof(m_Index));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Index;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPARSE_SEG_EXT_BASE_HPP
