/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_code_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqcode.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQCODE_SEQ_CODE_TYPE_BASE_HPP
#define OBJECTS_SEQCODE_SEQ_CODE_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// sequence representations
enum ESeq_code_type {
    eSeq_code_type_iupacna   =  1,  ///< IUPAC 1 letter nuc acid code
    eSeq_code_type_iupacaa   =  2,  ///< IUPAC 1 letter amino acid code
    eSeq_code_type_ncbi2na   =  3,  ///< 2 bit nucleic acid code
    eSeq_code_type_ncbi4na   =  4,  ///< 4 bit nucleic acid code
    eSeq_code_type_ncbi8na   =  5,  ///< 8 bit extended nucleic acid code
    eSeq_code_type_ncbipna   =  6,  ///< nucleic acid probabilities
    eSeq_code_type_ncbi8aa   =  7,  ///< 8 bit extended amino acid codes
    eSeq_code_type_ncbieaa   =  8,  ///< extended ASCII 1 letter aa codes
    eSeq_code_type_ncbipaa   =  9,  ///< amino acid probabilities
    eSeq_code_type_iupacaa3  = 10,  ///< 3 letter code only for display
    eSeq_code_type_ncbistdaa = 11  ///< consecutive codes for std aas, 0-25
};

/// Access to ESeq_code_type's attributes (values, names) as defined in spec
NCBI_SEQCODE_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESeq_code_type)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQCODE_SEQ_CODE_TYPE_BASE_HPP
