/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqEdit_Cmd_RemoveDesc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqedit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQEDIT_SEQEDIT_CMD_REMOVEDESC_BASE_HPP
#define OBJECTS_SEQEDIT_SEQEDIT_CMD_REMOVEDESC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeqEdit_Id;
class CSeqdesc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Remove a descripor from an object
class NCBI_SEQEDIT_EXPORT CSeqEdit_Cmd_RemoveDesc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqEdit_Cmd_RemoveDesc_Base(void);
    // destructor
    virtual ~CSeqEdit_Cmd_RemoveDesc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeqEdit_Id TId;
    typedef CSeqdesc TRemove_desc;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_remove_desc
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Bioseq or Bioseq_set id
    /// mandatory
    /// typedef CSeqEdit_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// descriptor
    /// mandatory
    /// typedef CSeqdesc TRemove_desc
    ///  Check whether the Remove_desc data member has been assigned a value.
    bool IsSetRemove_desc(void) const;
    /// Check whether it is safe or not to call GetRemove_desc method.
    bool CanGetRemove_desc(void) const;
    void ResetRemove_desc(void);
    const TRemove_desc& GetRemove_desc(void) const;
    void SetRemove_desc(TRemove_desc& value);
    TRemove_desc& SetRemove_desc(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqEdit_Cmd_RemoveDesc_Base(const CSeqEdit_Cmd_RemoveDesc_Base&);
    CSeqEdit_Cmd_RemoveDesc_Base& operator=(const CSeqEdit_Cmd_RemoveDesc_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TRemove_desc > m_Remove_desc;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqEdit_Cmd_RemoveDesc_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeqEdit_Cmd_RemoveDesc_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_RemoveDesc_Base::TId& CSeqEdit_Cmd_RemoveDesc_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeqEdit_Cmd_RemoveDesc_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeqEdit_Cmd_RemoveDesc_Base::TId& CSeqEdit_Cmd_RemoveDesc_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeqEdit_Cmd_RemoveDesc_Base::IsSetRemove_desc(void) const
{
    return m_Remove_desc.NotEmpty();
}

inline
bool CSeqEdit_Cmd_RemoveDesc_Base::CanGetRemove_desc(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_RemoveDesc_Base::TRemove_desc& CSeqEdit_Cmd_RemoveDesc_Base::GetRemove_desc(void) const
{
    if ( !m_Remove_desc ) {
        const_cast<CSeqEdit_Cmd_RemoveDesc_Base*>(this)->ResetRemove_desc();
    }
    return (*m_Remove_desc);
}

inline
CSeqEdit_Cmd_RemoveDesc_Base::TRemove_desc& CSeqEdit_Cmd_RemoveDesc_Base::SetRemove_desc(void)
{
    if ( !m_Remove_desc ) {
        ResetRemove_desc();
    }
    return (*m_Remove_desc);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQEDIT_SEQEDIT_CMD_REMOVEDESC_BASE_HPP
