/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Gene_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_GENE_REF_BASE_HPP
#define OBJECTS_SEQFEAT_GENE_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CGene_nomenclature;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Gene ***********************************************
///*
///*  reference to a gene
///*
class NCBI_SEQFEAT_EXPORT CGene_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGene_ref_Base(void);
    // destructor
    virtual ~CGene_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLocus;
    typedef string TAllele;
    typedef string TDesc;
    typedef string TMaploc;
    typedef bool TPseudo;
    typedef vector< CRef< CDbtag > > TDb;
    typedef list< string > TSyn;
    typedef string TLocus_tag;
    typedef CGene_nomenclature TFormal_name;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_locus,
        e_allele,
        e_desc,
        e_maploc,
        e_pseudo,
        e_db,
        e_syn,
        e_locus_tag,
        e_formal_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// Official gene symbol
    /// optional
    /// typedef string TLocus
    ///  Check whether the Locus data member has been assigned a value.
    bool IsSetLocus(void) const;
    /// Check whether it is safe or not to call GetLocus method.
    bool CanGetLocus(void) const;
    void ResetLocus(void);
    const TLocus& GetLocus(void) const;
    void SetLocus(const TLocus& value);
    void SetLocus(TLocus&& value);
    TLocus& SetLocus(void);

    /// Official allele designation
    /// optional
    /// typedef string TAllele
    ///  Check whether the Allele data member has been assigned a value.
    bool IsSetAllele(void) const;
    /// Check whether it is safe or not to call GetAllele method.
    bool CanGetAllele(void) const;
    void ResetAllele(void);
    const TAllele& GetAllele(void) const;
    void SetAllele(const TAllele& value);
    void SetAllele(TAllele&& value);
    TAllele& SetAllele(void);

    /// descriptive name
    /// optional
    /// typedef string TDesc
    ///  Check whether the Desc data member has been assigned a value.
    bool IsSetDesc(void) const;
    /// Check whether it is safe or not to call GetDesc method.
    bool CanGetDesc(void) const;
    void ResetDesc(void);
    const TDesc& GetDesc(void) const;
    void SetDesc(const TDesc& value);
    void SetDesc(TDesc&& value);
    TDesc& SetDesc(void);

    /// descriptive map location
    /// optional
    /// typedef string TMaploc
    ///  Check whether the Maploc data member has been assigned a value.
    bool IsSetMaploc(void) const;
    /// Check whether it is safe or not to call GetMaploc method.
    bool CanGetMaploc(void) const;
    void ResetMaploc(void);
    const TMaploc& GetMaploc(void) const;
    void SetMaploc(const TMaploc& value);
    void SetMaploc(TMaploc&& value);
    TMaploc& SetMaploc(void);

    /// pseudogene
    /// optional with default false
    /// typedef bool TPseudo
    ///  Check whether the Pseudo data member has been assigned a value.
    bool IsSetPseudo(void) const;
    /// Check whether it is safe or not to call GetPseudo method.
    bool CanGetPseudo(void) const;
    void ResetPseudo(void);
    void SetDefaultPseudo(void);
    TPseudo GetPseudo(void) const;
    void SetPseudo(TPseudo value);
    TPseudo& SetPseudo(void);

    /// ids in other dbases
    /// optional
    /// typedef vector< CRef< CDbtag > > TDb
    ///  Check whether the Db data member has been assigned a value.
    bool IsSetDb(void) const;
    /// Check whether it is safe or not to call GetDb method.
    bool CanGetDb(void) const;
    void ResetDb(void);
    const TDb& GetDb(void) const;
    TDb& SetDb(void);

    /// synonyms for locus
    /// optional
    /// typedef list< string > TSyn
    ///  Check whether the Syn data member has been assigned a value.
    bool IsSetSyn(void) const;
    /// Check whether it is safe or not to call GetSyn method.
    bool CanGetSyn(void) const;
    void ResetSyn(void);
    const TSyn& GetSyn(void) const;
    TSyn& SetSyn(void);

    /// systematic gene name (e.g., MI0001, ORF0069)
    /// optional
    /// typedef string TLocus_tag
    ///  Check whether the Locus_tag data member has been assigned a value.
    bool IsSetLocus_tag(void) const;
    /// Check whether it is safe or not to call GetLocus_tag method.
    bool CanGetLocus_tag(void) const;
    void ResetLocus_tag(void);
    const TLocus_tag& GetLocus_tag(void) const;
    void SetLocus_tag(const TLocus_tag& value);
    void SetLocus_tag(TLocus_tag&& value);
    TLocus_tag& SetLocus_tag(void);

    /// optional
    /// typedef CGene_nomenclature TFormal_name
    ///  Check whether the Formal_name data member has been assigned a value.
    bool IsSetFormal_name(void) const;
    /// Check whether it is safe or not to call GetFormal_name method.
    bool CanGetFormal_name(void) const;
    void ResetFormal_name(void);
    const TFormal_name& GetFormal_name(void) const;
    void SetFormal_name(TFormal_name& value);
    TFormal_name& SetFormal_name(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGene_ref_Base(const CGene_ref_Base&);
    CGene_ref_Base& operator=(const CGene_ref_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Locus;
    string m_Allele;
    string m_Desc;
    string m_Maploc;
    bool m_Pseudo;
    vector< CRef< CDbtag > > m_Db;
    list< string > m_Syn;
    string m_Locus_tag;
    CRef< TFormal_name > m_Formal_name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGene_ref_Base::IsSetLocus(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGene_ref_Base::CanGetLocus(void) const
{
    return IsSetLocus();
}

inline
const CGene_ref_Base::TLocus& CGene_ref_Base::GetLocus(void) const
{
    if (!CanGetLocus()) {
        ThrowUnassigned(0);
    }
    return m_Locus;
}

inline
void CGene_ref_Base::SetLocus(const CGene_ref_Base::TLocus& value)
{
    m_Locus = value;
    m_set_State[0] |= 0x3;
}

inline
void CGene_ref_Base::SetLocus(CGene_ref_Base::TLocus&& value)
{
    m_Locus = std::forward<CGene_ref_Base::TLocus>(value);
    m_set_State[0] |= 0x3;
}

inline
CGene_ref_Base::TLocus& CGene_ref_Base::SetLocus(void)
{
#ifdef _DEBUG
    if (!IsSetLocus()) {
        m_Locus = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Locus;
}

inline
bool CGene_ref_Base::IsSetAllele(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGene_ref_Base::CanGetAllele(void) const
{
    return IsSetAllele();
}

inline
const CGene_ref_Base::TAllele& CGene_ref_Base::GetAllele(void) const
{
    if (!CanGetAllele()) {
        ThrowUnassigned(1);
    }
    return m_Allele;
}

inline
void CGene_ref_Base::SetAllele(const CGene_ref_Base::TAllele& value)
{
    m_Allele = value;
    m_set_State[0] |= 0xc;
}

inline
void CGene_ref_Base::SetAllele(CGene_ref_Base::TAllele&& value)
{
    m_Allele = std::forward<CGene_ref_Base::TAllele>(value);
    m_set_State[0] |= 0xc;
}

inline
CGene_ref_Base::TAllele& CGene_ref_Base::SetAllele(void)
{
#ifdef _DEBUG
    if (!IsSetAllele()) {
        m_Allele = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Allele;
}

inline
bool CGene_ref_Base::IsSetDesc(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGene_ref_Base::CanGetDesc(void) const
{
    return IsSetDesc();
}

inline
const CGene_ref_Base::TDesc& CGene_ref_Base::GetDesc(void) const
{
    if (!CanGetDesc()) {
        ThrowUnassigned(2);
    }
    return m_Desc;
}

inline
void CGene_ref_Base::SetDesc(const CGene_ref_Base::TDesc& value)
{
    m_Desc = value;
    m_set_State[0] |= 0x30;
}

inline
void CGene_ref_Base::SetDesc(CGene_ref_Base::TDesc&& value)
{
    m_Desc = std::forward<CGene_ref_Base::TDesc>(value);
    m_set_State[0] |= 0x30;
}

inline
CGene_ref_Base::TDesc& CGene_ref_Base::SetDesc(void)
{
#ifdef _DEBUG
    if (!IsSetDesc()) {
        m_Desc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Desc;
}

inline
bool CGene_ref_Base::IsSetMaploc(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGene_ref_Base::CanGetMaploc(void) const
{
    return IsSetMaploc();
}

inline
const CGene_ref_Base::TMaploc& CGene_ref_Base::GetMaploc(void) const
{
    if (!CanGetMaploc()) {
        ThrowUnassigned(3);
    }
    return m_Maploc;
}

inline
void CGene_ref_Base::SetMaploc(const CGene_ref_Base::TMaploc& value)
{
    m_Maploc = value;
    m_set_State[0] |= 0xc0;
}

inline
void CGene_ref_Base::SetMaploc(CGene_ref_Base::TMaploc&& value)
{
    m_Maploc = std::forward<CGene_ref_Base::TMaploc>(value);
    m_set_State[0] |= 0xc0;
}

inline
CGene_ref_Base::TMaploc& CGene_ref_Base::SetMaploc(void)
{
#ifdef _DEBUG
    if (!IsSetMaploc()) {
        m_Maploc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Maploc;
}

inline
bool CGene_ref_Base::IsSetPseudo(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGene_ref_Base::CanGetPseudo(void) const
{
    return true;
}

inline
void CGene_ref_Base::ResetPseudo(void)
{
    m_Pseudo = false;
    m_set_State[0] &= ~0x300;
}

inline
void CGene_ref_Base::SetDefaultPseudo(void)
{
    ResetPseudo();
}

inline
CGene_ref_Base::TPseudo CGene_ref_Base::GetPseudo(void) const
{
    return m_Pseudo;
}

inline
void CGene_ref_Base::SetPseudo(CGene_ref_Base::TPseudo value)
{
    m_Pseudo = value;
    m_set_State[0] |= 0x300;
}

inline
CGene_ref_Base::TPseudo& CGene_ref_Base::SetPseudo(void)
{
#ifdef _DEBUG
    if (!IsSetPseudo()) {
        memset(&m_Pseudo,UnassignedByte(),sizeof(m_Pseudo));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Pseudo;
}

inline
bool CGene_ref_Base::IsSetDb(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CGene_ref_Base::CanGetDb(void) const
{
    return true;
}

inline
const CGene_ref_Base::TDb& CGene_ref_Base::GetDb(void) const
{
    return m_Db;
}

inline
CGene_ref_Base::TDb& CGene_ref_Base::SetDb(void)
{
    m_set_State[0] |= 0x400;
    return m_Db;
}

inline
bool CGene_ref_Base::IsSetSyn(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CGene_ref_Base::CanGetSyn(void) const
{
    return true;
}

inline
const CGene_ref_Base::TSyn& CGene_ref_Base::GetSyn(void) const
{
    return m_Syn;
}

inline
CGene_ref_Base::TSyn& CGene_ref_Base::SetSyn(void)
{
    m_set_State[0] |= 0x1000;
    return m_Syn;
}

inline
bool CGene_ref_Base::IsSetLocus_tag(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CGene_ref_Base::CanGetLocus_tag(void) const
{
    return IsSetLocus_tag();
}

inline
const CGene_ref_Base::TLocus_tag& CGene_ref_Base::GetLocus_tag(void) const
{
    if (!CanGetLocus_tag()) {
        ThrowUnassigned(7);
    }
    return m_Locus_tag;
}

inline
void CGene_ref_Base::SetLocus_tag(const CGene_ref_Base::TLocus_tag& value)
{
    m_Locus_tag = value;
    m_set_State[0] |= 0xc000;
}

inline
void CGene_ref_Base::SetLocus_tag(CGene_ref_Base::TLocus_tag&& value)
{
    m_Locus_tag = std::forward<CGene_ref_Base::TLocus_tag>(value);
    m_set_State[0] |= 0xc000;
}

inline
CGene_ref_Base::TLocus_tag& CGene_ref_Base::SetLocus_tag(void)
{
#ifdef _DEBUG
    if (!IsSetLocus_tag()) {
        m_Locus_tag = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Locus_tag;
}

inline
bool CGene_ref_Base::IsSetFormal_name(void) const
{
    return m_Formal_name.NotEmpty();
}

inline
bool CGene_ref_Base::CanGetFormal_name(void) const
{
    return IsSetFormal_name();
}

inline
const CGene_ref_Base::TFormal_name& CGene_ref_Base::GetFormal_name(void) const
{
    if (!CanGetFormal_name()) {
        ThrowUnassigned(8);
    }
    return (*m_Formal_name);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_GENE_REF_BASE_HPP
