/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file RNA_gen_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_RNA_GEN_BASE_HPP
#define OBJECTS_SEQFEAT_RNA_GEN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CRNA_qual_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CRNA_gen_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRNA_gen_Base(void);
    // destructor
    virtual ~CRNA_gen_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TClass;
    typedef string TProduct;
    typedef CRNA_qual_set TQuals;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_class,
        e_product,
        e_quals
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// for ncRNAs, the class of non-coding RNA:
    /// examples: antisense_RNA, guide_RNA, snRNA
    /// optional
    /// typedef string TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    const TClass& GetClass(void) const;
    void SetClass(const TClass& value);
    void SetClass(TClass&& value);
    TClass& SetClass(void);

    /// optional
    /// typedef string TProduct
    ///  Check whether the Product data member has been assigned a value.
    bool IsSetProduct(void) const;
    /// Check whether it is safe or not to call GetProduct method.
    bool CanGetProduct(void) const;
    void ResetProduct(void);
    const TProduct& GetProduct(void) const;
    void SetProduct(const TProduct& value);
    void SetProduct(TProduct&& value);
    TProduct& SetProduct(void);

    /// e.g., tag_peptide qualifier for tmRNAs
    /// optional
    /// typedef CRNA_qual_set TQuals
    ///  Check whether the Quals data member has been assigned a value.
    bool IsSetQuals(void) const;
    /// Check whether it is safe or not to call GetQuals method.
    bool CanGetQuals(void) const;
    void ResetQuals(void);
    const TQuals& GetQuals(void) const;
    void SetQuals(TQuals& value);
    TQuals& SetQuals(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRNA_gen_Base(const CRNA_gen_Base&);
    CRNA_gen_Base& operator=(const CRNA_gen_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Class;
    string m_Product;
    CRef< TQuals > m_Quals;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRNA_gen_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRNA_gen_Base::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CRNA_gen_Base::TClass& CRNA_gen_Base::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(0);
    }
    return m_Class;
}

inline
void CRNA_gen_Base::SetClass(const CRNA_gen_Base::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x3;
}

inline
void CRNA_gen_Base::SetClass(CRNA_gen_Base::TClass&& value)
{
    m_Class = std::forward<CRNA_gen_Base::TClass>(value);
    m_set_State[0] |= 0x3;
}

inline
CRNA_gen_Base::TClass& CRNA_gen_Base::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Class;
}

inline
bool CRNA_gen_Base::IsSetProduct(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRNA_gen_Base::CanGetProduct(void) const
{
    return IsSetProduct();
}

inline
const CRNA_gen_Base::TProduct& CRNA_gen_Base::GetProduct(void) const
{
    if (!CanGetProduct()) {
        ThrowUnassigned(1);
    }
    return m_Product;
}

inline
void CRNA_gen_Base::SetProduct(const CRNA_gen_Base::TProduct& value)
{
    m_Product = value;
    m_set_State[0] |= 0xc;
}

inline
void CRNA_gen_Base::SetProduct(CRNA_gen_Base::TProduct&& value)
{
    m_Product = std::forward<CRNA_gen_Base::TProduct>(value);
    m_set_State[0] |= 0xc;
}

inline
CRNA_gen_Base::TProduct& CRNA_gen_Base::SetProduct(void)
{
#ifdef _DEBUG
    if (!IsSetProduct()) {
        m_Product = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Product;
}

inline
bool CRNA_gen_Base::IsSetQuals(void) const
{
    return m_Quals.NotEmpty();
}

inline
bool CRNA_gen_Base::CanGetQuals(void) const
{
    return IsSetQuals();
}

inline
const CRNA_gen_Base::TQuals& CRNA_gen_Base::GetQuals(void) const
{
    if (!CanGetQuals()) {
        ThrowUnassigned(2);
    }
    return (*m_Quals);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_RNA_GEN_BASE_HPP
