/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqFeatData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_SEQFEATDATA_BASE_HPP
#define OBJECTS_SEQFEAT_SEQFEATDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/seq/Heterogen.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBioSource;
class CCdregion;
class CClone_ref;
class CGene_ref;
class CImp_feat;
class CNumbering;
class COrg_ref;
class CProt_ref;
class CPubdesc;
class CRNA_ref;
class CRsite_ref;
class CSeq_loc;
class CTxinit;
class CUser_object;
class CVariation_ref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CSeqFeatData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqFeatData_Base(void);
    // destructor
    virtual ~CSeqFeatData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EBond {
        eBond_disulfide  =   1,
        eBond_thiolester =   2,
        eBond_xlink      =   3,
        eBond_thioether  =   4,
        eBond_other      = 255
    };
    
    /// Access to EBond's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EBond)(void);
    
    enum ESite {
        eSite_active                      =   1,
        eSite_binding                     =   2,
        eSite_cleavage                    =   3,
        eSite_inhibit                     =   4,
        eSite_modified                    =   5,
        eSite_glycosylation               =   6,
        eSite_myristoylation              =   7,
        eSite_mutagenized                 =   8,
        eSite_metal_binding               =   9,
        eSite_phosphorylation             =  10,
        eSite_acetylation                 =  11,
        eSite_amidation                   =  12,
        eSite_methylation                 =  13,
        eSite_hydroxylation               =  14,
        eSite_sulfatation                 =  15,
        eSite_oxidative_deamination       =  16,
        eSite_pyrrolidone_carboxylic_acid =  17,
        eSite_gamma_carboxyglutamic_acid  =  18,
        eSite_blocked                     =  19,
        eSite_lipid_binding               =  20,
        eSite_np_binding                  =  21,
        eSite_dna_binding                 =  22,
        eSite_signal_peptide              =  23,
        eSite_transit_peptide             =  24,
        eSite_transmembrane_region        =  25,
        eSite_nitrosylation               =  26,
        eSite_other                       = 255
    };
    
    /// Access to ESite's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESite)(void);
    
    /// protein secondary structure
    enum EPsec_str {
        ePsec_str_helix = 1,  ///< any helix
        ePsec_str_sheet = 2,  ///< beta sheet
        ePsec_str_turn  = 3  ///< beta or gamma turn
    };
    
    /// Access to EPsec_str's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPsec_str)(void);
    

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Gene,
        e_Org,
        e_Cdregion,
        e_Prot,
        e_Rna,
        e_Pub,              ///< publication applies to this seq
        e_Seq,              ///< to annotate origin from another seq
        e_Imp,
        e_Region,           ///< named region (globin locus)
        e_Comment,          ///< just a comment
        e_Bond,
        e_Site,
        e_Rsite,            ///< restriction site  (for maps really)
        e_User,             ///< user defined structure
        e_Txinit,           ///< transcription initiation
        e_Num,              ///< a numbering system
        e_Psec_str,
        e_Non_std_residue,  ///< non-standard residue here in seq
        e_Het,              ///< cofactor, prosthetic grp, etc, bound to seq
        e_Biosrc,
        e_Clone,
        e_Variation
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 23 ///< == e_Variation+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CGene_ref TGene;
    typedef COrg_ref TOrg;
    typedef CCdregion TCdregion;
    typedef CProt_ref TProt;
    typedef CRNA_ref TRna;
    typedef CPubdesc TPub;
    typedef CSeq_loc TSeq;
    typedef CImp_feat TImp;
    typedef string TRegion;
    typedef EBond TBond;
    typedef ESite TSite;
    typedef CRsite_ref TRsite;
    typedef CUser_object TUser;
    typedef CTxinit TTxinit;
    typedef CNumbering TNum;
    typedef EPsec_str TPsec_str;
    typedef string TNon_std_residue;
    typedef CHeterogen THet;
    typedef CBioSource TBiosrc;
    typedef CClone_ref TClone;
    typedef CVariation_ref TVariation;

    // getters
    // setters

    // typedef CGene_ref TGene
    bool IsGene(void) const;
    const TGene& GetGene(void) const;
    TGene& SetGene(void);
    void SetGene(TGene& value);

    // typedef COrg_ref TOrg
    bool IsOrg(void) const;
    const TOrg& GetOrg(void) const;
    TOrg& SetOrg(void);
    void SetOrg(TOrg& value);

    // typedef CCdregion TCdregion
    bool IsCdregion(void) const;
    const TCdregion& GetCdregion(void) const;
    TCdregion& SetCdregion(void);
    void SetCdregion(TCdregion& value);

    // typedef CProt_ref TProt
    bool IsProt(void) const;
    const TProt& GetProt(void) const;
    TProt& SetProt(void);
    void SetProt(TProt& value);

    // typedef CRNA_ref TRna
    bool IsRna(void) const;
    const TRna& GetRna(void) const;
    TRna& SetRna(void);
    void SetRna(TRna& value);

    // typedef CPubdesc TPub
    bool IsPub(void) const;
    const TPub& GetPub(void) const;
    TPub& SetPub(void);
    void SetPub(TPub& value);

    // typedef CSeq_loc TSeq
    bool IsSeq(void) const;
    const TSeq& GetSeq(void) const;
    TSeq& SetSeq(void);
    void SetSeq(TSeq& value);

    // typedef CImp_feat TImp
    bool IsImp(void) const;
    const TImp& GetImp(void) const;
    TImp& SetImp(void);
    void SetImp(TImp& value);

    // typedef string TRegion
    bool IsRegion(void) const;
    const TRegion& GetRegion(void) const;
    TRegion& SetRegion(void);
    void SetRegion(const TRegion& value);


    bool IsComment(void) const;
    void SetComment(void);

    // typedef EBond TBond
    bool IsBond(void) const;
    TBond GetBond(void) const;
    TBond& SetBond(void);
    void SetBond(TBond value);

    // typedef ESite TSite
    bool IsSite(void) const;
    TSite GetSite(void) const;
    TSite& SetSite(void);
    void SetSite(TSite value);

    // typedef CRsite_ref TRsite
    bool IsRsite(void) const;
    const TRsite& GetRsite(void) const;
    TRsite& SetRsite(void);
    void SetRsite(TRsite& value);

    // typedef CUser_object TUser
    bool IsUser(void) const;
    const TUser& GetUser(void) const;
    TUser& SetUser(void);
    void SetUser(TUser& value);

    // typedef CTxinit TTxinit
    bool IsTxinit(void) const;
    const TTxinit& GetTxinit(void) const;
    TTxinit& SetTxinit(void);
    void SetTxinit(TTxinit& value);

    // typedef CNumbering TNum
    bool IsNum(void) const;
    const TNum& GetNum(void) const;
    TNum& SetNum(void);
    void SetNum(TNum& value);

    // typedef EPsec_str TPsec_str
    bool IsPsec_str(void) const;
    TPsec_str GetPsec_str(void) const;
    TPsec_str& SetPsec_str(void);
    void SetPsec_str(TPsec_str value);

    // typedef string TNon_std_residue
    bool IsNon_std_residue(void) const;
    const TNon_std_residue& GetNon_std_residue(void) const;
    TNon_std_residue& SetNon_std_residue(void);
    void SetNon_std_residue(const TNon_std_residue& value);

    // typedef CHeterogen THet
    bool IsHet(void) const;
    const THet& GetHet(void) const;
    THet& SetHet(void);
    void SetHet(const THet& value);

    // typedef CBioSource TBiosrc
    bool IsBiosrc(void) const;
    const TBiosrc& GetBiosrc(void) const;
    TBiosrc& SetBiosrc(void);
    void SetBiosrc(TBiosrc& value);

    // typedef CClone_ref TClone
    bool IsClone(void) const;
    const TClone& GetClone(void) const;
    TClone& SetClone(void);
    void SetClone(TClone& value);

    // typedef CVariation_ref TVariation
    bool IsVariation(void) const;
    const TVariation& GetVariation(void) const;
    TVariation& SetVariation(void);
    void SetVariation(TVariation& value);


private:
    // copy constructor and assignment operator
    CSeqFeatData_Base(const CSeqFeatData_Base& );
    CSeqFeatData_Base& operator=(const CSeqFeatData_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TBond m_Bond;
        TSite m_Site;
        TPsec_str m_Psec_str;
        NCBI_NS_NCBI::CUnionBuffer<THet> m_Het;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqFeatData_Base::E_Choice CSeqFeatData_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeqFeatData_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqFeatData_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqFeatData_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqFeatData_Base::IsGene(void) const
{
    return m_choice == e_Gene;
}

inline
bool CSeqFeatData_Base::IsOrg(void) const
{
    return m_choice == e_Org;
}

inline
bool CSeqFeatData_Base::IsCdregion(void) const
{
    return m_choice == e_Cdregion;
}

inline
bool CSeqFeatData_Base::IsProt(void) const
{
    return m_choice == e_Prot;
}

inline
bool CSeqFeatData_Base::IsRna(void) const
{
    return m_choice == e_Rna;
}

inline
bool CSeqFeatData_Base::IsPub(void) const
{
    return m_choice == e_Pub;
}

inline
bool CSeqFeatData_Base::IsSeq(void) const
{
    return m_choice == e_Seq;
}

inline
bool CSeqFeatData_Base::IsImp(void) const
{
    return m_choice == e_Imp;
}

inline
bool CSeqFeatData_Base::IsRegion(void) const
{
    return m_choice == e_Region;
}

inline
const CSeqFeatData_Base::TRegion& CSeqFeatData_Base::GetRegion(void) const
{
    CheckSelected(e_Region);
    return *m_string;
}

inline
CSeqFeatData_Base::TRegion& CSeqFeatData_Base::SetRegion(void)
{
    Select(e_Region, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqFeatData_Base::IsComment(void) const
{
    return m_choice == e_Comment;
}

inline
void CSeqFeatData_Base::SetComment(void)
{
    Select(e_Comment, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSeqFeatData_Base::IsBond(void) const
{
    return m_choice == e_Bond;
}

inline
CSeqFeatData_Base::TBond CSeqFeatData_Base::GetBond(void) const
{
    CheckSelected(e_Bond);
    return m_Bond;
}

inline
CSeqFeatData_Base::TBond& CSeqFeatData_Base::SetBond(void)
{
    Select(e_Bond, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bond;
}

inline
void CSeqFeatData_Base::SetBond(CSeqFeatData_Base::TBond value)
{
    Select(e_Bond, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bond = value;
}

inline
bool CSeqFeatData_Base::IsSite(void) const
{
    return m_choice == e_Site;
}

inline
CSeqFeatData_Base::TSite CSeqFeatData_Base::GetSite(void) const
{
    CheckSelected(e_Site);
    return m_Site;
}

inline
CSeqFeatData_Base::TSite& CSeqFeatData_Base::SetSite(void)
{
    Select(e_Site, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Site;
}

inline
void CSeqFeatData_Base::SetSite(CSeqFeatData_Base::TSite value)
{
    Select(e_Site, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Site = value;
}

inline
bool CSeqFeatData_Base::IsRsite(void) const
{
    return m_choice == e_Rsite;
}

inline
bool CSeqFeatData_Base::IsUser(void) const
{
    return m_choice == e_User;
}

inline
bool CSeqFeatData_Base::IsTxinit(void) const
{
    return m_choice == e_Txinit;
}

inline
bool CSeqFeatData_Base::IsNum(void) const
{
    return m_choice == e_Num;
}

inline
bool CSeqFeatData_Base::IsPsec_str(void) const
{
    return m_choice == e_Psec_str;
}

inline
CSeqFeatData_Base::TPsec_str CSeqFeatData_Base::GetPsec_str(void) const
{
    CheckSelected(e_Psec_str);
    return m_Psec_str;
}

inline
CSeqFeatData_Base::TPsec_str& CSeqFeatData_Base::SetPsec_str(void)
{
    Select(e_Psec_str, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Psec_str;
}

inline
void CSeqFeatData_Base::SetPsec_str(CSeqFeatData_Base::TPsec_str value)
{
    Select(e_Psec_str, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Psec_str = value;
}

inline
bool CSeqFeatData_Base::IsNon_std_residue(void) const
{
    return m_choice == e_Non_std_residue;
}

inline
const CSeqFeatData_Base::TNon_std_residue& CSeqFeatData_Base::GetNon_std_residue(void) const
{
    CheckSelected(e_Non_std_residue);
    return *m_string;
}

inline
CSeqFeatData_Base::TNon_std_residue& CSeqFeatData_Base::SetNon_std_residue(void)
{
    Select(e_Non_std_residue, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqFeatData_Base::IsHet(void) const
{
    return m_choice == e_Het;
}

inline
const CSeqFeatData_Base::THet& CSeqFeatData_Base::GetHet(void) const
{
    CheckSelected(e_Het);
    return *m_Het;
}

inline
CSeqFeatData_Base::THet& CSeqFeatData_Base::SetHet(void)
{
    Select(e_Het, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Het;
}

inline
bool CSeqFeatData_Base::IsBiosrc(void) const
{
    return m_choice == e_Biosrc;
}

inline
bool CSeqFeatData_Base::IsClone(void) const
{
    return m_choice == e_Clone;
}

inline
bool CSeqFeatData_Base::IsVariation(void) const
{
    return m_choice == e_Variation;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_SEQFEATDATA_BASE_HPP
