/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Trna_ext_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_TRNA_EXT_BASE_HPP
#define OBJECTS_SEQFEAT_TRNA_EXT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// tRNA feature extensions
class NCBI_SEQFEAT_EXPORT CTrna_ext_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTrna_ext_Base(void);
    // destructor
    virtual ~CTrna_ext_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// aa this carries
    class NCBI_SEQFEAT_EXPORT C_Aa : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Aa(void);
        // destructor
        ~C_Aa(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Iupacaa,
            e_Ncbieaa,
            e_Ncbi8aa,
            e_Ncbistdaa
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_Ncbistdaa+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef int TIupacaa;
        typedef int TNcbieaa;
        typedef int TNcbi8aa;
        typedef int TNcbistdaa;
    
        // getters
        // setters
    
        // typedef int TIupacaa
        bool IsIupacaa(void) const;
        TIupacaa GetIupacaa(void) const;
        TIupacaa& SetIupacaa(void);
        void SetIupacaa(TIupacaa value);
    
        // typedef int TNcbieaa
        bool IsNcbieaa(void) const;
        TNcbieaa GetNcbieaa(void) const;
        TNcbieaa& SetNcbieaa(void);
        void SetNcbieaa(TNcbieaa value);
    
        // typedef int TNcbi8aa
        bool IsNcbi8aa(void) const;
        TNcbi8aa GetNcbi8aa(void) const;
        TNcbi8aa& SetNcbi8aa(void);
        void SetNcbi8aa(TNcbi8aa value);
    
        // typedef int TNcbistdaa
        bool IsNcbistdaa(void) const;
        TNcbistdaa GetNcbistdaa(void) const;
        TNcbistdaa& SetNcbistdaa(void);
        void SetNcbistdaa(TNcbistdaa value);
    
    
    private:
        // copy constructor and assignment operator
        C_Aa(const C_Aa& );
        C_Aa& operator=(const C_Aa& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TIupacaa m_Iupacaa;
            TNcbieaa m_Ncbieaa;
            TNcbi8aa m_Ncbi8aa;
            TNcbistdaa m_Ncbistdaa;
        };
    };
    // types
    typedef C_Aa TAa;
    typedef list< int > TCodon;
    typedef CSeq_loc TAnticodon;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_aa,
        e_codon,
        e_anticodon
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef C_Aa TAa
    ///  Check whether the Aa data member has been assigned a value.
    bool IsSetAa(void) const;
    /// Check whether it is safe or not to call GetAa method.
    bool CanGetAa(void) const;
    void ResetAa(void);
    const TAa& GetAa(void) const;
    void SetAa(TAa& value);
    TAa& SetAa(void);

    /// codon(s) as in Genetic-code
    /// optional
    /// typedef list< int > TCodon
    ///  Check whether the Codon data member has been assigned a value.
    bool IsSetCodon(void) const;
    /// Check whether it is safe or not to call GetCodon method.
    bool CanGetCodon(void) const;
    void ResetCodon(void);
    const TCodon& GetCodon(void) const;
    TCodon& SetCodon(void);

    /// location of anticodon
    /// optional
    /// typedef CSeq_loc TAnticodon
    ///  Check whether the Anticodon data member has been assigned a value.
    bool IsSetAnticodon(void) const;
    /// Check whether it is safe or not to call GetAnticodon method.
    bool CanGetAnticodon(void) const;
    void ResetAnticodon(void);
    const TAnticodon& GetAnticodon(void) const;
    void SetAnticodon(TAnticodon& value);
    TAnticodon& SetAnticodon(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTrna_ext_Base(const CTrna_ext_Base&);
    CTrna_ext_Base& operator=(const CTrna_ext_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAa > m_Aa;
    list< int > m_Codon;
    CRef< TAnticodon > m_Anticodon;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTrna_ext_Base::C_Aa::E_Choice CTrna_ext_Base::C_Aa::Which(void) const
{
    return m_choice;
}

inline
void CTrna_ext_Base::C_Aa::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTrna_ext_Base::C_Aa::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTrna_ext_Base::C_Aa::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTrna_ext_Base::C_Aa::IsIupacaa(void) const
{
    return m_choice == e_Iupacaa;
}

inline
CTrna_ext_Base::C_Aa::TIupacaa CTrna_ext_Base::C_Aa::GetIupacaa(void) const
{
    CheckSelected(e_Iupacaa);
    return m_Iupacaa;
}

inline
CTrna_ext_Base::C_Aa::TIupacaa& CTrna_ext_Base::C_Aa::SetIupacaa(void)
{
    Select(e_Iupacaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Iupacaa;
}

inline
void CTrna_ext_Base::C_Aa::SetIupacaa(CTrna_ext_Base::C_Aa::TIupacaa value)
{
    Select(e_Iupacaa, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Iupacaa = value;
}

inline
bool CTrna_ext_Base::C_Aa::IsNcbieaa(void) const
{
    return m_choice == e_Ncbieaa;
}

inline
CTrna_ext_Base::C_Aa::TNcbieaa CTrna_ext_Base::C_Aa::GetNcbieaa(void) const
{
    CheckSelected(e_Ncbieaa);
    return m_Ncbieaa;
}

inline
CTrna_ext_Base::C_Aa::TNcbieaa& CTrna_ext_Base::C_Aa::SetNcbieaa(void)
{
    Select(e_Ncbieaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Ncbieaa;
}

inline
void CTrna_ext_Base::C_Aa::SetNcbieaa(CTrna_ext_Base::C_Aa::TNcbieaa value)
{
    Select(e_Ncbieaa, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Ncbieaa = value;
}

inline
bool CTrna_ext_Base::C_Aa::IsNcbi8aa(void) const
{
    return m_choice == e_Ncbi8aa;
}

inline
CTrna_ext_Base::C_Aa::TNcbi8aa CTrna_ext_Base::C_Aa::GetNcbi8aa(void) const
{
    CheckSelected(e_Ncbi8aa);
    return m_Ncbi8aa;
}

inline
CTrna_ext_Base::C_Aa::TNcbi8aa& CTrna_ext_Base::C_Aa::SetNcbi8aa(void)
{
    Select(e_Ncbi8aa, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Ncbi8aa;
}

inline
void CTrna_ext_Base::C_Aa::SetNcbi8aa(CTrna_ext_Base::C_Aa::TNcbi8aa value)
{
    Select(e_Ncbi8aa, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Ncbi8aa = value;
}

inline
bool CTrna_ext_Base::C_Aa::IsNcbistdaa(void) const
{
    return m_choice == e_Ncbistdaa;
}

inline
CTrna_ext_Base::C_Aa::TNcbistdaa CTrna_ext_Base::C_Aa::GetNcbistdaa(void) const
{
    CheckSelected(e_Ncbistdaa);
    return m_Ncbistdaa;
}

inline
CTrna_ext_Base::C_Aa::TNcbistdaa& CTrna_ext_Base::C_Aa::SetNcbistdaa(void)
{
    Select(e_Ncbistdaa, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Ncbistdaa;
}

inline
void CTrna_ext_Base::C_Aa::SetNcbistdaa(CTrna_ext_Base::C_Aa::TNcbistdaa value)
{
    Select(e_Ncbistdaa, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Ncbistdaa = value;
}

inline
bool CTrna_ext_Base::IsSetAa(void) const
{
    return m_Aa.NotEmpty();
}

inline
bool CTrna_ext_Base::CanGetAa(void) const
{
    return IsSetAa();
}

inline
const CTrna_ext_Base::TAa& CTrna_ext_Base::GetAa(void) const
{
    if (!CanGetAa()) {
        ThrowUnassigned(0);
    }
    return (*m_Aa);
}

inline
bool CTrna_ext_Base::IsSetCodon(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTrna_ext_Base::CanGetCodon(void) const
{
    return true;
}

inline
const CTrna_ext_Base::TCodon& CTrna_ext_Base::GetCodon(void) const
{
    return m_Codon;
}

inline
CTrna_ext_Base::TCodon& CTrna_ext_Base::SetCodon(void)
{
    m_set_State[0] |= 0x4;
    return m_Codon;
}

inline
bool CTrna_ext_Base::IsSetAnticodon(void) const
{
    return m_Anticodon.NotEmpty();
}

inline
bool CTrna_ext_Base::CanGetAnticodon(void) const
{
    return IsSetAnticodon();
}

inline
const CTrna_ext_Base::TAnticodon& CTrna_ext_Base::GetAnticodon(void) const
{
    if (!CanGetAnticodon()) {
        ThrowUnassigned(2);
    }
    return (*m_Anticodon);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_TRNA_EXT_BASE_HPP
