/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_loc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_SEQ_LOC_BASE_HPP
#define OBJECTS_SEQLOC_SEQ_LOC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeat_id;
class CPacked_seqint;
class CPacked_seqpnt;
class CSeq_bond;
class CSeq_id;
class CSeq_interval;
class CSeq_loc_equiv;
class CSeq_loc_mix;
class CSeq_point;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Sequence locations **********************************
///*
class NCBI_SEQLOC_EXPORT CSeq_loc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_loc_Base(void);
    // destructor
    virtual ~CSeq_loc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Null,         ///< not placed
        e_Empty,        ///< to NULL one Seq-id in a collection
        e_Whole,        ///< whole sequence
        e_Int,          ///< from to
        e_Packed_int,
        e_Pnt,
        e_Packed_pnt,
        e_Mix,
        e_Equiv,        ///< equivalent sets of locations
        e_Bond,
        e_Feat          ///< indirect, through a Seq-feat
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 12 ///< == e_Feat+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CSeq_id TEmpty;
    typedef CSeq_id TWhole;
    typedef CSeq_interval TInt;
    typedef CPacked_seqint TPacked_int;
    typedef CSeq_point TPnt;
    typedef CPacked_seqpnt TPacked_pnt;
    typedef CSeq_loc_mix TMix;
    typedef CSeq_loc_equiv TEquiv;
    typedef CSeq_bond TBond;
    typedef CFeat_id TFeat;

    // getters
    // setters


    bool IsNull(void) const;
    void SetNull(void);

    // typedef CSeq_id TEmpty
    bool IsEmpty(void) const;
    const TEmpty& GetEmpty(void) const;
    TEmpty& SetEmpty(void);
    void SetEmpty(TEmpty& value);

    // typedef CSeq_id TWhole
    bool IsWhole(void) const;
    const TWhole& GetWhole(void) const;
    TWhole& SetWhole(void);
    void SetWhole(TWhole& value);

    // typedef CSeq_interval TInt
    bool IsInt(void) const;
    const TInt& GetInt(void) const;
    TInt& SetInt(void);
    void SetInt(TInt& value);

    // typedef CPacked_seqint TPacked_int
    bool IsPacked_int(void) const;
    const TPacked_int& GetPacked_int(void) const;
    TPacked_int& SetPacked_int(void);
    void SetPacked_int(TPacked_int& value);

    // typedef CSeq_point TPnt
    bool IsPnt(void) const;
    const TPnt& GetPnt(void) const;
    TPnt& SetPnt(void);
    void SetPnt(TPnt& value);

    // typedef CPacked_seqpnt TPacked_pnt
    bool IsPacked_pnt(void) const;
    const TPacked_pnt& GetPacked_pnt(void) const;
    TPacked_pnt& SetPacked_pnt(void);
    void SetPacked_pnt(TPacked_pnt& value);

    // typedef CSeq_loc_mix TMix
    bool IsMix(void) const;
    const TMix& GetMix(void) const;
    TMix& SetMix(void);
    void SetMix(TMix& value);

    // typedef CSeq_loc_equiv TEquiv
    bool IsEquiv(void) const;
    const TEquiv& GetEquiv(void) const;
    TEquiv& SetEquiv(void);
    void SetEquiv(TEquiv& value);

    // typedef CSeq_bond TBond
    bool IsBond(void) const;
    const TBond& GetBond(void) const;
    TBond& SetBond(void);
    void SetBond(TBond& value);

    // typedef CFeat_id TFeat
    bool IsFeat(void) const;
    const TFeat& GetFeat(void) const;
    TFeat& SetFeat(void);
    void SetFeat(TFeat& value);


private:
    // copy constructor and assignment operator
    CSeq_loc_Base(const CSeq_loc_Base& );
    CSeq_loc_Base& operator=(const CSeq_loc_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_loc_Base::E_Choice CSeq_loc_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeq_loc_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_loc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_loc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_loc_Base::IsNull(void) const
{
    return m_choice == e_Null;
}

inline
void CSeq_loc_Base::SetNull(void)
{
    Select(e_Null, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSeq_loc_Base::IsEmpty(void) const
{
    return m_choice == e_Empty;
}

inline
bool CSeq_loc_Base::IsWhole(void) const
{
    return m_choice == e_Whole;
}

inline
bool CSeq_loc_Base::IsInt(void) const
{
    return m_choice == e_Int;
}

inline
bool CSeq_loc_Base::IsPacked_int(void) const
{
    return m_choice == e_Packed_int;
}

inline
bool CSeq_loc_Base::IsPnt(void) const
{
    return m_choice == e_Pnt;
}

inline
bool CSeq_loc_Base::IsPacked_pnt(void) const
{
    return m_choice == e_Packed_pnt;
}

inline
bool CSeq_loc_Base::IsMix(void) const
{
    return m_choice == e_Mix;
}

inline
bool CSeq_loc_Base::IsEquiv(void) const
{
    return m_choice == e_Equiv;
}

inline
bool CSeq_loc_Base::IsBond(void) const
{
    return m_choice == e_Bond;
}

inline
bool CSeq_loc_Base::IsFeat(void) const
{
    return m_choice == e_Feat;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_LOC_BASE_HPP
