/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Bioseq_Ids_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_BIOSEQ_IDS_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_BIOSEQ_IDS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Gi_Range;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Bioseq_Ids_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Bioseq_Ids_Base(void);
    // destructor
    virtual ~CID2S_Bioseq_Ids_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_ID2_EXPORT C_E : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E(void);
        // destructor
        ~C_E(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Gi,
            e_Seq_id,
            e_Gi_range
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Gi_range+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_NCBI::TGi TGi;
        typedef CSeq_id TSeq_id;
        typedef CID2S_Gi_Range TGi_range;
    
        // getters
        // setters
    
        // typedef NCBI_NS_NCBI::TGi TGi
        bool IsGi(void) const;
        TGi GetGi(void) const;
        TGi& SetGi(void);
        void SetGi(TGi value);
    
        // typedef CSeq_id TSeq_id
        bool IsSeq_id(void) const;
        const TSeq_id& GetSeq_id(void) const;
        TSeq_id& SetSeq_id(void);
        void SetSeq_id(TSeq_id& value);
    
        // typedef CID2S_Gi_Range TGi_range
        bool IsGi_range(void) const;
        const TGi_range& GetGi_range(void) const;
        TGi_range& SetGi_range(void);
        void SetGi_range(TGi_range& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E(const C_E& );
        C_E& operator=(const C_E& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            ncbi::TIntId m_Gi;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef list< CRef< C_E > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< C_E > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CID2S_Bioseq_Ids_Base(const CID2S_Bioseq_Ids_Base&);
    CID2S_Bioseq_Ids_Base& operator=(const CID2S_Bioseq_Ids_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< C_E > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID2S_Bioseq_Ids_Base::C_E::E_Choice CID2S_Bioseq_Ids_Base::C_E::Which(void) const
{
    return m_choice;
}

inline
void CID2S_Bioseq_Ids_Base::C_E::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CID2S_Bioseq_Ids_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CID2S_Bioseq_Ids_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CID2S_Bioseq_Ids_Base::C_E::IsGi(void) const
{
    return m_choice == e_Gi;
}

inline
CID2S_Bioseq_Ids_Base::C_E::TGi CID2S_Bioseq_Ids_Base::C_E::GetGi(void) const
{
    CheckSelected(e_Gi);
    return reinterpret_cast<const TGi&>(m_Gi);
}

inline
CID2S_Bioseq_Ids_Base::C_E::TGi& CID2S_Bioseq_Ids_Base::C_E::SetGi(void)
{
    Select(e_Gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGi&>(m_Gi);
}

inline
void CID2S_Bioseq_Ids_Base::C_E::SetGi(CID2S_Bioseq_Ids_Base::C_E::TGi value)
{
    Select(e_Gi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGi&>(m_Gi) = value;
}

inline
bool CID2S_Bioseq_Ids_Base::C_E::IsSeq_id(void) const
{
    return m_choice == e_Seq_id;
}

inline
bool CID2S_Bioseq_Ids_Base::C_E::IsGi_range(void) const
{
    return m_choice == e_Gi_range;
}

inline
bool CID2S_Bioseq_Ids_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2S_Bioseq_Ids_Base::CanGet(void) const
{
    return true;
}

inline
const CID2S_Bioseq_Ids_Base::Tdata& CID2S_Bioseq_Ids_Base::Get(void) const
{
    return m_data;
}

inline
CID2S_Bioseq_Ids_Base::Tdata& CID2S_Bioseq_Ids_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CID2S_Bioseq_Ids_Base::operator const CID2S_Bioseq_Ids_Base::Tdata& (void) const
{
    return m_data;
}

inline
CID2S_Bioseq_Ids_Base::operator CID2S_Bioseq_Ids_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_BIOSEQ_IDS_BASE_HPP
