/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Seq_loc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_SEQ_LOC_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_SEQ_LOC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Gi_Interval;
class CID2S_Gi_Ints;
class CID2S_Gi_Range;
class CID2S_Seq_id_Interval;
class CID2S_Seq_id_Ints;
class CID2S_Seq_loc;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ID2S-Seq-loc is used to represent unordered and unstranded
/// set of intervals on set of sequences.
/// It's optimized for compact encoding of several common cases:
///    Seq-ids of type gi,
///    intervals covering whole sequences,
///    whole sequences with sequential gis,
///    set of intervals on the same sequence (Seq-id sharing).
class NCBI_ID2_EXPORT CID2S_Seq_loc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Seq_loc_Base(void);
    // destructor
    virtual ~CID2S_Seq_loc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Whole_gi,         ///< whole sequence by gi
        e_Whole_seq_id,     ///< whole sequence by Seq-id
        e_Whole_gi_range,   ///< set of whole sequences by gis
        e_Gi_interval,      ///< interval on sequence by gi
        e_Seq_id_interval,  ///< interval on sequence by Seq-id
        e_Gi_ints,          ///< set of intervals on the same gi
        e_Seq_id_ints,      ///< set of intervals on the same id
        e_Loc_set           ///< combination of locations
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 9 ///< == e_Loc_set+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef NCBI_NS_NCBI::TGi TWhole_gi;
    typedef CSeq_id TWhole_seq_id;
    typedef CID2S_Gi_Range TWhole_gi_range;
    typedef CID2S_Gi_Interval TGi_interval;
    typedef CID2S_Seq_id_Interval TSeq_id_interval;
    typedef CID2S_Gi_Ints TGi_ints;
    typedef CID2S_Seq_id_Ints TSeq_id_ints;
    typedef list< CRef< CID2S_Seq_loc > > TLoc_set;

    // getters
    // setters

    // typedef NCBI_NS_NCBI::TGi TWhole_gi
    bool IsWhole_gi(void) const;
    TWhole_gi GetWhole_gi(void) const;
    TWhole_gi& SetWhole_gi(void);
    void SetWhole_gi(TWhole_gi value);

    // typedef CSeq_id TWhole_seq_id
    bool IsWhole_seq_id(void) const;
    const TWhole_seq_id& GetWhole_seq_id(void) const;
    TWhole_seq_id& SetWhole_seq_id(void);
    void SetWhole_seq_id(TWhole_seq_id& value);

    // typedef CID2S_Gi_Range TWhole_gi_range
    bool IsWhole_gi_range(void) const;
    const TWhole_gi_range& GetWhole_gi_range(void) const;
    TWhole_gi_range& SetWhole_gi_range(void);
    void SetWhole_gi_range(TWhole_gi_range& value);

    // typedef CID2S_Gi_Interval TGi_interval
    bool IsGi_interval(void) const;
    const TGi_interval& GetGi_interval(void) const;
    TGi_interval& SetGi_interval(void);
    void SetGi_interval(TGi_interval& value);

    // typedef CID2S_Seq_id_Interval TSeq_id_interval
    bool IsSeq_id_interval(void) const;
    const TSeq_id_interval& GetSeq_id_interval(void) const;
    TSeq_id_interval& SetSeq_id_interval(void);
    void SetSeq_id_interval(TSeq_id_interval& value);

    // typedef CID2S_Gi_Ints TGi_ints
    bool IsGi_ints(void) const;
    const TGi_ints& GetGi_ints(void) const;
    TGi_ints& SetGi_ints(void);
    void SetGi_ints(TGi_ints& value);

    // typedef CID2S_Seq_id_Ints TSeq_id_ints
    bool IsSeq_id_ints(void) const;
    const TSeq_id_ints& GetSeq_id_ints(void) const;
    TSeq_id_ints& SetSeq_id_ints(void);
    void SetSeq_id_ints(TSeq_id_ints& value);

    // typedef list< CRef< CID2S_Seq_loc > > TLoc_set
    bool IsLoc_set(void) const;
    const TLoc_set& GetLoc_set(void) const;
    TLoc_set& SetLoc_set(void);


private:
    // copy constructor and assignment operator
    CID2S_Seq_loc_Base(const CID2S_Seq_loc_Base& );
    CID2S_Seq_loc_Base& operator=(const CID2S_Seq_loc_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        ncbi::TIntId m_Whole_gi;
        NCBI_NS_NCBI::CUnionBuffer<TLoc_set> m_Loc_set;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID2S_Seq_loc_Base::E_Choice CID2S_Seq_loc_Base::Which(void) const
{
    return m_choice;
}

inline
void CID2S_Seq_loc_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CID2S_Seq_loc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CID2S_Seq_loc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CID2S_Seq_loc_Base::IsWhole_gi(void) const
{
    return m_choice == e_Whole_gi;
}

inline
CID2S_Seq_loc_Base::TWhole_gi CID2S_Seq_loc_Base::GetWhole_gi(void) const
{
    CheckSelected(e_Whole_gi);
    return reinterpret_cast<const TWhole_gi&>(m_Whole_gi);
}

inline
CID2S_Seq_loc_Base::TWhole_gi& CID2S_Seq_loc_Base::SetWhole_gi(void)
{
    Select(e_Whole_gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TWhole_gi&>(m_Whole_gi);
}

inline
void CID2S_Seq_loc_Base::SetWhole_gi(CID2S_Seq_loc_Base::TWhole_gi value)
{
    Select(e_Whole_gi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TWhole_gi&>(m_Whole_gi) = value;
}

inline
bool CID2S_Seq_loc_Base::IsWhole_seq_id(void) const
{
    return m_choice == e_Whole_seq_id;
}

inline
bool CID2S_Seq_loc_Base::IsWhole_gi_range(void) const
{
    return m_choice == e_Whole_gi_range;
}

inline
bool CID2S_Seq_loc_Base::IsGi_interval(void) const
{
    return m_choice == e_Gi_interval;
}

inline
bool CID2S_Seq_loc_Base::IsSeq_id_interval(void) const
{
    return m_choice == e_Seq_id_interval;
}

inline
bool CID2S_Seq_loc_Base::IsGi_ints(void) const
{
    return m_choice == e_Gi_ints;
}

inline
bool CID2S_Seq_loc_Base::IsSeq_id_ints(void) const
{
    return m_choice == e_Seq_id_ints;
}

inline
bool CID2S_Seq_loc_Base::IsLoc_set(void) const
{
    return m_choice == e_Loc_set;
}

inline
const CID2S_Seq_loc_Base::TLoc_set& CID2S_Seq_loc_Base::GetLoc_set(void) const
{
    CheckSelected(e_Loc_set);
    return *m_Loc_set;
}

inline
CID2S_Seq_loc_Base::TLoc_set& CID2S_Seq_loc_Base::SetLoc_set(void)
{
    Select(e_Loc_set, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Loc_set;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_SEQ_LOC_BASE_HPP
