/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_sparse_index_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_SEQTABLE_SPARSE_INDEX_BASE_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_SPARSE_INDEX_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBVector_data;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_sparse_index_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTable_sparse_index_Base(void);
    // destructor
    virtual ~CSeqTable_sparse_index_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Indexes,          ///< Indexes of rows with values
        e_Bit_set,          ///< Bitset of rows with values, set bit means the row has value.  Most-significant bit in each octet comes first.
        e_Indexes_delta,    ///< Indexes of rows with values, delta-encoded
        e_Bit_set_bvector   ///< Bitset of rows with values, as serialized bvector<>,  see include/util/bitset/bm.h
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 5 ///< == e_Bit_set_bvector+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef vector< unsigned > TIndexes;
    typedef vector< char > TBit_set;
    typedef vector< unsigned > TIndexes_delta;
    typedef CBVector_data TBit_set_bvector;

    // getters
    // setters

    // typedef vector< unsigned > TIndexes
    bool IsIndexes(void) const;
    const TIndexes& GetIndexes(void) const;
    TIndexes& SetIndexes(void);

    // typedef vector< char > TBit_set
    bool IsBit_set(void) const;
    const TBit_set& GetBit_set(void) const;
    TBit_set& SetBit_set(void);

    // typedef vector< unsigned > TIndexes_delta
    bool IsIndexes_delta(void) const;
    const TIndexes_delta& GetIndexes_delta(void) const;
    TIndexes_delta& SetIndexes_delta(void);

    // typedef CBVector_data TBit_set_bvector
    bool IsBit_set_bvector(void) const;
    const TBit_set_bvector& GetBit_set_bvector(void) const;
    TBit_set_bvector& SetBit_set_bvector(void);
    void SetBit_set_bvector(TBit_set_bvector& value);


private:
    // copy constructor and assignment operator
    CSeqTable_sparse_index_Base(const CSeqTable_sparse_index_Base& );
    CSeqTable_sparse_index_Base& operator=(const CSeqTable_sparse_index_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TIndexes> m_Indexes;
        NCBI_NS_NCBI::CUnionBuffer<TBit_set> m_Bit_set;
        NCBI_NS_NCBI::CUnionBuffer<TIndexes_delta> m_Indexes_delta;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqTable_sparse_index_Base::E_Choice CSeqTable_sparse_index_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeqTable_sparse_index_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqTable_sparse_index_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqTable_sparse_index_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqTable_sparse_index_Base::IsIndexes(void) const
{
    return m_choice == e_Indexes;
}

inline
const CSeqTable_sparse_index_Base::TIndexes& CSeqTable_sparse_index_Base::GetIndexes(void) const
{
    CheckSelected(e_Indexes);
    return *m_Indexes;
}

inline
CSeqTable_sparse_index_Base::TIndexes& CSeqTable_sparse_index_Base::SetIndexes(void)
{
    Select(e_Indexes, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Indexes;
}

inline
bool CSeqTable_sparse_index_Base::IsBit_set(void) const
{
    return m_choice == e_Bit_set;
}

inline
const CSeqTable_sparse_index_Base::TBit_set& CSeqTable_sparse_index_Base::GetBit_set(void) const
{
    CheckSelected(e_Bit_set);
    return *m_Bit_set;
}

inline
CSeqTable_sparse_index_Base::TBit_set& CSeqTable_sparse_index_Base::SetBit_set(void)
{
    Select(e_Bit_set, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bit_set;
}

inline
bool CSeqTable_sparse_index_Base::IsIndexes_delta(void) const
{
    return m_choice == e_Indexes_delta;
}

inline
const CSeqTable_sparse_index_Base::TIndexes_delta& CSeqTable_sparse_index_Base::GetIndexes_delta(void) const
{
    CheckSelected(e_Indexes_delta);
    return *m_Indexes_delta;
}

inline
CSeqTable_sparse_index_Base::TIndexes_delta& CSeqTable_sparse_index_Base::SetIndexes_delta(void)
{
    Select(e_Indexes_delta, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Indexes_delta;
}

inline
bool CSeqTable_sparse_index_Base::IsBit_set_bvector(void) const
{
    return m_choice == e_Bit_set_bvector;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_SPARSE_INDEX_BASE_HPP
