/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Taxon1_req_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'taxon1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TAXON1_TAXON1_REQ_BASE_HPP
#define OBJECTS_TAXON1_TAXON1_REQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class COrg_ref;
class CTaxon1_info;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Requests to the Taxon server
class NCBI_TAXON1_EXPORT CTaxon1_req_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTaxon1_req_Base(void);
    // destructor
    virtual ~CTaxon1_req_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Init,             ///< initialize the server
        e_Findname,         ///< find orgnames match string
        e_Getdesignator,    ///< find designator
        e_Getunique,        ///< get taxid for unique name
        e_Getidbyorg,       ///< get taxid matches orgref
        e_Getorgnames,      ///< get all organism names
        e_Getcde,           ///< get name classes
        e_Getranks,         ///< get ranks
        e_Getdivs,          ///< get divisions
        e_Getgcs,           ///< get gencodes
        e_Getlineage,       ///< get lineage for org
        e_Getchildren,      ///< get children
        e_Getbyid,          ///< get Org-ref by TaxonID
        e_Lookup,           ///< lookup by data
        e_Getorgmod,        ///< lookup for OrgMod
        e_Fini,             ///< close the server
        e_Id4gi,            ///< get taxid by gi
        e_Taxachildren,     ///< get children
        e_Taxalineage,      ///< get extended lineage for org
        e_Maxtaxid,         ///< get max taxid
        e_Getproptypes,     ///< get property types
        e_Getorgprop,       ///< get properties for organism
        e_Searchname,       ///< fancy search (token set, wild card)
        e_Dumpnames4class,  ///< all names of certain name class
        e_Getdomain         ///< get domain description and values
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 26 ///< == e_Getdomain+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TFindname;
    typedef string TGetdesignator;
    typedef string TGetunique;
    typedef COrg_ref TGetidbyorg;
    typedef int TGetorgnames;
    typedef int TGetlineage;
    typedef int TGetchildren;
    typedef int TGetbyid;
    typedef COrg_ref TLookup;
    typedef CTaxon1_info TGetorgmod;
    typedef NCBI_NS_NCBI::TGi TId4gi;
    typedef int TTaxachildren;
    typedef int TTaxalineage;
    typedef CTaxon1_info TGetorgprop;
    typedef CTaxon1_info TSearchname;
    typedef int TDumpnames4class;
    typedef string TGetdomain;

    // getters
    // setters


    bool IsInit(void) const;
    void SetInit(void);

    // typedef string TFindname
    bool IsFindname(void) const;
    const TFindname& GetFindname(void) const;
    TFindname& SetFindname(void);
    void SetFindname(const TFindname& value);

    // typedef string TGetdesignator
    bool IsGetdesignator(void) const;
    const TGetdesignator& GetGetdesignator(void) const;
    TGetdesignator& SetGetdesignator(void);
    void SetGetdesignator(const TGetdesignator& value);

    // typedef string TGetunique
    bool IsGetunique(void) const;
    const TGetunique& GetGetunique(void) const;
    TGetunique& SetGetunique(void);
    void SetGetunique(const TGetunique& value);

    // typedef COrg_ref TGetidbyorg
    bool IsGetidbyorg(void) const;
    const TGetidbyorg& GetGetidbyorg(void) const;
    TGetidbyorg& SetGetidbyorg(void);
    void SetGetidbyorg(TGetidbyorg& value);

    // typedef int TGetorgnames
    bool IsGetorgnames(void) const;
    TGetorgnames GetGetorgnames(void) const;
    TGetorgnames& SetGetorgnames(void);
    void SetGetorgnames(TGetorgnames value);


    bool IsGetcde(void) const;
    void SetGetcde(void);


    bool IsGetranks(void) const;
    void SetGetranks(void);


    bool IsGetdivs(void) const;
    void SetGetdivs(void);


    bool IsGetgcs(void) const;
    void SetGetgcs(void);

    // typedef int TGetlineage
    bool IsGetlineage(void) const;
    TGetlineage GetGetlineage(void) const;
    TGetlineage& SetGetlineage(void);
    void SetGetlineage(TGetlineage value);

    // typedef int TGetchildren
    bool IsGetchildren(void) const;
    TGetchildren GetGetchildren(void) const;
    TGetchildren& SetGetchildren(void);
    void SetGetchildren(TGetchildren value);

    // typedef int TGetbyid
    bool IsGetbyid(void) const;
    TGetbyid GetGetbyid(void) const;
    TGetbyid& SetGetbyid(void);
    void SetGetbyid(TGetbyid value);

    // typedef COrg_ref TLookup
    bool IsLookup(void) const;
    const TLookup& GetLookup(void) const;
    TLookup& SetLookup(void);
    void SetLookup(TLookup& value);

    // typedef CTaxon1_info TGetorgmod
    bool IsGetorgmod(void) const;
    const TGetorgmod& GetGetorgmod(void) const;
    TGetorgmod& SetGetorgmod(void);
    void SetGetorgmod(TGetorgmod& value);


    bool IsFini(void) const;
    void SetFini(void);

    // typedef NCBI_NS_NCBI::TGi TId4gi
    bool IsId4gi(void) const;
    TId4gi GetId4gi(void) const;
    TId4gi& SetId4gi(void);
    void SetId4gi(TId4gi value);

    // typedef int TTaxachildren
    bool IsTaxachildren(void) const;
    TTaxachildren GetTaxachildren(void) const;
    TTaxachildren& SetTaxachildren(void);
    void SetTaxachildren(TTaxachildren value);

    // typedef int TTaxalineage
    bool IsTaxalineage(void) const;
    TTaxalineage GetTaxalineage(void) const;
    TTaxalineage& SetTaxalineage(void);
    void SetTaxalineage(TTaxalineage value);


    bool IsMaxtaxid(void) const;
    void SetMaxtaxid(void);


    bool IsGetproptypes(void) const;
    void SetGetproptypes(void);

    // typedef CTaxon1_info TGetorgprop
    bool IsGetorgprop(void) const;
    const TGetorgprop& GetGetorgprop(void) const;
    TGetorgprop& SetGetorgprop(void);
    void SetGetorgprop(TGetorgprop& value);

    // typedef CTaxon1_info TSearchname
    bool IsSearchname(void) const;
    const TSearchname& GetSearchname(void) const;
    TSearchname& SetSearchname(void);
    void SetSearchname(TSearchname& value);

    // typedef int TDumpnames4class
    bool IsDumpnames4class(void) const;
    TDumpnames4class GetDumpnames4class(void) const;
    TDumpnames4class& SetDumpnames4class(void);
    void SetDumpnames4class(TDumpnames4class value);

    // typedef string TGetdomain
    bool IsGetdomain(void) const;
    const TGetdomain& GetGetdomain(void) const;
    TGetdomain& SetGetdomain(void);
    void SetGetdomain(const TGetdomain& value);


private:
    // copy constructor and assignment operator
    CTaxon1_req_Base(const CTaxon1_req_Base& );
    CTaxon1_req_Base& operator=(const CTaxon1_req_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TGetorgnames m_Getorgnames;
        TGetlineage m_Getlineage;
        TGetchildren m_Getchildren;
        TGetbyid m_Getbyid;
        ncbi::TIntId m_Id4gi;
        TTaxachildren m_Taxachildren;
        TTaxalineage m_Taxalineage;
        TDumpnames4class m_Dumpnames4class;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTaxon1_req_Base::E_Choice CTaxon1_req_Base::Which(void) const
{
    return m_choice;
}

inline
void CTaxon1_req_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTaxon1_req_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTaxon1_req_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTaxon1_req_Base::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CTaxon1_req_Base::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsFindname(void) const
{
    return m_choice == e_Findname;
}

inline
const CTaxon1_req_Base::TFindname& CTaxon1_req_Base::GetFindname(void) const
{
    CheckSelected(e_Findname);
    return *m_string;
}

inline
CTaxon1_req_Base::TFindname& CTaxon1_req_Base::SetFindname(void)
{
    Select(e_Findname, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTaxon1_req_Base::IsGetdesignator(void) const
{
    return m_choice == e_Getdesignator;
}

inline
const CTaxon1_req_Base::TGetdesignator& CTaxon1_req_Base::GetGetdesignator(void) const
{
    CheckSelected(e_Getdesignator);
    return *m_string;
}

inline
CTaxon1_req_Base::TGetdesignator& CTaxon1_req_Base::SetGetdesignator(void)
{
    Select(e_Getdesignator, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTaxon1_req_Base::IsGetunique(void) const
{
    return m_choice == e_Getunique;
}

inline
const CTaxon1_req_Base::TGetunique& CTaxon1_req_Base::GetGetunique(void) const
{
    CheckSelected(e_Getunique);
    return *m_string;
}

inline
CTaxon1_req_Base::TGetunique& CTaxon1_req_Base::SetGetunique(void)
{
    Select(e_Getunique, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTaxon1_req_Base::IsGetidbyorg(void) const
{
    return m_choice == e_Getidbyorg;
}

inline
bool CTaxon1_req_Base::IsGetorgnames(void) const
{
    return m_choice == e_Getorgnames;
}

inline
CTaxon1_req_Base::TGetorgnames CTaxon1_req_Base::GetGetorgnames(void) const
{
    CheckSelected(e_Getorgnames);
    return m_Getorgnames;
}

inline
CTaxon1_req_Base::TGetorgnames& CTaxon1_req_Base::SetGetorgnames(void)
{
    Select(e_Getorgnames, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getorgnames;
}

inline
void CTaxon1_req_Base::SetGetorgnames(CTaxon1_req_Base::TGetorgnames value)
{
    Select(e_Getorgnames, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getorgnames = value;
}

inline
bool CTaxon1_req_Base::IsGetcde(void) const
{
    return m_choice == e_Getcde;
}

inline
void CTaxon1_req_Base::SetGetcde(void)
{
    Select(e_Getcde, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsGetranks(void) const
{
    return m_choice == e_Getranks;
}

inline
void CTaxon1_req_Base::SetGetranks(void)
{
    Select(e_Getranks, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsGetdivs(void) const
{
    return m_choice == e_Getdivs;
}

inline
void CTaxon1_req_Base::SetGetdivs(void)
{
    Select(e_Getdivs, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsGetgcs(void) const
{
    return m_choice == e_Getgcs;
}

inline
void CTaxon1_req_Base::SetGetgcs(void)
{
    Select(e_Getgcs, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsGetlineage(void) const
{
    return m_choice == e_Getlineage;
}

inline
CTaxon1_req_Base::TGetlineage CTaxon1_req_Base::GetGetlineage(void) const
{
    CheckSelected(e_Getlineage);
    return m_Getlineage;
}

inline
CTaxon1_req_Base::TGetlineage& CTaxon1_req_Base::SetGetlineage(void)
{
    Select(e_Getlineage, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getlineage;
}

inline
void CTaxon1_req_Base::SetGetlineage(CTaxon1_req_Base::TGetlineage value)
{
    Select(e_Getlineage, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getlineage = value;
}

inline
bool CTaxon1_req_Base::IsGetchildren(void) const
{
    return m_choice == e_Getchildren;
}

inline
CTaxon1_req_Base::TGetchildren CTaxon1_req_Base::GetGetchildren(void) const
{
    CheckSelected(e_Getchildren);
    return m_Getchildren;
}

inline
CTaxon1_req_Base::TGetchildren& CTaxon1_req_Base::SetGetchildren(void)
{
    Select(e_Getchildren, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getchildren;
}

inline
void CTaxon1_req_Base::SetGetchildren(CTaxon1_req_Base::TGetchildren value)
{
    Select(e_Getchildren, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getchildren = value;
}

inline
bool CTaxon1_req_Base::IsGetbyid(void) const
{
    return m_choice == e_Getbyid;
}

inline
CTaxon1_req_Base::TGetbyid CTaxon1_req_Base::GetGetbyid(void) const
{
    CheckSelected(e_Getbyid);
    return m_Getbyid;
}

inline
CTaxon1_req_Base::TGetbyid& CTaxon1_req_Base::SetGetbyid(void)
{
    Select(e_Getbyid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getbyid;
}

inline
void CTaxon1_req_Base::SetGetbyid(CTaxon1_req_Base::TGetbyid value)
{
    Select(e_Getbyid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getbyid = value;
}

inline
bool CTaxon1_req_Base::IsLookup(void) const
{
    return m_choice == e_Lookup;
}

inline
bool CTaxon1_req_Base::IsGetorgmod(void) const
{
    return m_choice == e_Getorgmod;
}

inline
bool CTaxon1_req_Base::IsFini(void) const
{
    return m_choice == e_Fini;
}

inline
void CTaxon1_req_Base::SetFini(void)
{
    Select(e_Fini, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsId4gi(void) const
{
    return m_choice == e_Id4gi;
}

inline
CTaxon1_req_Base::TId4gi CTaxon1_req_Base::GetId4gi(void) const
{
    CheckSelected(e_Id4gi);
    return reinterpret_cast<const TId4gi&>(m_Id4gi);
}

inline
CTaxon1_req_Base::TId4gi& CTaxon1_req_Base::SetId4gi(void)
{
    Select(e_Id4gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TId4gi&>(m_Id4gi);
}

inline
void CTaxon1_req_Base::SetId4gi(CTaxon1_req_Base::TId4gi value)
{
    Select(e_Id4gi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TId4gi&>(m_Id4gi) = value;
}

inline
bool CTaxon1_req_Base::IsTaxachildren(void) const
{
    return m_choice == e_Taxachildren;
}

inline
CTaxon1_req_Base::TTaxachildren CTaxon1_req_Base::GetTaxachildren(void) const
{
    CheckSelected(e_Taxachildren);
    return m_Taxachildren;
}

inline
CTaxon1_req_Base::TTaxachildren& CTaxon1_req_Base::SetTaxachildren(void)
{
    Select(e_Taxachildren, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Taxachildren;
}

inline
void CTaxon1_req_Base::SetTaxachildren(CTaxon1_req_Base::TTaxachildren value)
{
    Select(e_Taxachildren, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Taxachildren = value;
}

inline
bool CTaxon1_req_Base::IsTaxalineage(void) const
{
    return m_choice == e_Taxalineage;
}

inline
CTaxon1_req_Base::TTaxalineage CTaxon1_req_Base::GetTaxalineage(void) const
{
    CheckSelected(e_Taxalineage);
    return m_Taxalineage;
}

inline
CTaxon1_req_Base::TTaxalineage& CTaxon1_req_Base::SetTaxalineage(void)
{
    Select(e_Taxalineage, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Taxalineage;
}

inline
void CTaxon1_req_Base::SetTaxalineage(CTaxon1_req_Base::TTaxalineage value)
{
    Select(e_Taxalineage, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Taxalineage = value;
}

inline
bool CTaxon1_req_Base::IsMaxtaxid(void) const
{
    return m_choice == e_Maxtaxid;
}

inline
void CTaxon1_req_Base::SetMaxtaxid(void)
{
    Select(e_Maxtaxid, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsGetproptypes(void) const
{
    return m_choice == e_Getproptypes;
}

inline
void CTaxon1_req_Base::SetGetproptypes(void)
{
    Select(e_Getproptypes, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTaxon1_req_Base::IsGetorgprop(void) const
{
    return m_choice == e_Getorgprop;
}

inline
bool CTaxon1_req_Base::IsSearchname(void) const
{
    return m_choice == e_Searchname;
}

inline
bool CTaxon1_req_Base::IsDumpnames4class(void) const
{
    return m_choice == e_Dumpnames4class;
}

inline
CTaxon1_req_Base::TDumpnames4class CTaxon1_req_Base::GetDumpnames4class(void) const
{
    CheckSelected(e_Dumpnames4class);
    return m_Dumpnames4class;
}

inline
CTaxon1_req_Base::TDumpnames4class& CTaxon1_req_Base::SetDumpnames4class(void)
{
    Select(e_Dumpnames4class, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Dumpnames4class;
}

inline
void CTaxon1_req_Base::SetDumpnames4class(CTaxon1_req_Base::TDumpnames4class value)
{
    Select(e_Dumpnames4class, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Dumpnames4class = value;
}

inline
bool CTaxon1_req_Base::IsGetdomain(void) const
{
    return m_choice == e_Getdomain;
}

inline
const CTaxon1_req_Base::TGetdomain& CTaxon1_req_Base::GetGetdomain(void) const
{
    CheckSelected(e_Getdomain);
    return *m_string;
}

inline
CTaxon1_req_Base::TGetdomain& CTaxon1_req_Base::SetGetdomain(void)
{
    Select(e_Getdomain, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TAXON1_TAXON1_REQ_BASE_HPP
