/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_HubTrack_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_HUBTRACK_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_HUBTRACK_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_DHubId;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_HubTrack_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_HubTrack_Base(void);
    // destructor
    virtual ~CTMgr_HubTrack_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TShort_label;
    typedef string TLong_label;
    typedef CTMgr_DHubId THub_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_short_label,
        e_long_label,
        e_hub_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// shortLabel entry from trackDB.txt file
    /// mandatory
    /// typedef string TShort_label
    ///  Check whether the Short_label data member has been assigned a value.
    bool IsSetShort_label(void) const;
    /// Check whether it is safe or not to call GetShort_label method.
    bool CanGetShort_label(void) const;
    void ResetShort_label(void);
    const TShort_label& GetShort_label(void) const;
    void SetShort_label(const TShort_label& value);
    void SetShort_label(TShort_label&& value);
    TShort_label& SetShort_label(void);

    /// longLabel entry from trackDB.txt file
    /// mandatory
    /// typedef string TLong_label
    ///  Check whether the Long_label data member has been assigned a value.
    bool IsSetLong_label(void) const;
    /// Check whether it is safe or not to call GetLong_label method.
    bool CanGetLong_label(void) const;
    void ResetLong_label(void);
    const TLong_label& GetLong_label(void) const;
    void SetLong_label(const TLong_label& value);
    void SetLong_label(TLong_label&& value);
    TLong_label& SetLong_label(void);

    ///- used to associate a track with a hub   
    /// mandatory
    /// typedef CTMgr_DHubId THub_id
    ///  Check whether the Hub_id data member has been assigned a value.
    bool IsSetHub_id(void) const;
    /// Check whether it is safe or not to call GetHub_id method.
    bool CanGetHub_id(void) const;
    void ResetHub_id(void);
    const THub_id& GetHub_id(void) const;
    void SetHub_id(THub_id& value);
    THub_id& SetHub_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_HubTrack_Base(const CTMgr_HubTrack_Base&);
    CTMgr_HubTrack_Base& operator=(const CTMgr_HubTrack_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Short_label;
    string m_Long_label;
    CRef< THub_id > m_Hub_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_HubTrack_Base::IsSetShort_label(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_HubTrack_Base::CanGetShort_label(void) const
{
    return IsSetShort_label();
}

inline
const CTMgr_HubTrack_Base::TShort_label& CTMgr_HubTrack_Base::GetShort_label(void) const
{
    if (!CanGetShort_label()) {
        ThrowUnassigned(0);
    }
    return m_Short_label;
}

inline
void CTMgr_HubTrack_Base::SetShort_label(const CTMgr_HubTrack_Base::TShort_label& value)
{
    m_Short_label = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_HubTrack_Base::SetShort_label(CTMgr_HubTrack_Base::TShort_label&& value)
{
    m_Short_label = std::forward<CTMgr_HubTrack_Base::TShort_label>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_HubTrack_Base::TShort_label& CTMgr_HubTrack_Base::SetShort_label(void)
{
#ifdef _DEBUG
    if (!IsSetShort_label()) {
        m_Short_label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Short_label;
}

inline
bool CTMgr_HubTrack_Base::IsSetLong_label(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_HubTrack_Base::CanGetLong_label(void) const
{
    return IsSetLong_label();
}

inline
const CTMgr_HubTrack_Base::TLong_label& CTMgr_HubTrack_Base::GetLong_label(void) const
{
    if (!CanGetLong_label()) {
        ThrowUnassigned(1);
    }
    return m_Long_label;
}

inline
void CTMgr_HubTrack_Base::SetLong_label(const CTMgr_HubTrack_Base::TLong_label& value)
{
    m_Long_label = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_HubTrack_Base::SetLong_label(CTMgr_HubTrack_Base::TLong_label&& value)
{
    m_Long_label = std::forward<CTMgr_HubTrack_Base::TLong_label>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_HubTrack_Base::TLong_label& CTMgr_HubTrack_Base::SetLong_label(void)
{
#ifdef _DEBUG
    if (!IsSetLong_label()) {
        m_Long_label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Long_label;
}

inline
bool CTMgr_HubTrack_Base::IsSetHub_id(void) const
{
    return m_Hub_id.NotEmpty();
}

inline
bool CTMgr_HubTrack_Base::CanGetHub_id(void) const
{
    return true;
}

inline
const CTMgr_HubTrack_Base::THub_id& CTMgr_HubTrack_Base::GetHub_id(void) const
{
    if ( !m_Hub_id ) {
        const_cast<CTMgr_HubTrack_Base*>(this)->ResetHub_id();
    }
    return (*m_Hub_id);
}

inline
CTMgr_HubTrack_Base::THub_id& CTMgr_HubTrack_Base::SetHub_id(void)
{
    if ( !m_Hub_id ) {
        ResetHub_id();
    }
    return (*m_Hub_id);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_HUBTRACK_BASE_HPP
