/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_TrackACL_Authorizatio_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_TRACKACL_AUTHORIZATIO_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_TRACKACL_AUTHORIZATIO_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/trackmgr/TMgr_ACL_AccessLevel.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_TrackACL_Authorization_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_TrackACL_Authorization_Base(void);
    // destructor
    virtual ~CTMgr_TrackACL_Authorization_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TAccess_level;
    typedef string TAccess_key;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_access_level,
        e_access_key
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TAccess_level
    ///  Check whether the Access_level data member has been assigned a value.
    bool IsSetAccess_level(void) const;
    /// Check whether it is safe or not to call GetAccess_level method.
    bool CanGetAccess_level(void) const;
    void ResetAccess_level(void);
    TAccess_level GetAccess_level(void) const;
    void SetAccess_level(TAccess_level value);
    TAccess_level& SetAccess_level(void);

    /// optional
    /// typedef string TAccess_key
    ///  Check whether the Access_key data member has been assigned a value.
    bool IsSetAccess_key(void) const;
    /// Check whether it is safe or not to call GetAccess_key method.
    bool CanGetAccess_key(void) const;
    void ResetAccess_key(void);
    const TAccess_key& GetAccess_key(void) const;
    void SetAccess_key(const TAccess_key& value);
    void SetAccess_key(TAccess_key&& value);
    TAccess_key& SetAccess_key(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_TrackACL_Authorization_Base(const CTMgr_TrackACL_Authorization_Base&);
    CTMgr_TrackACL_Authorization_Base& operator=(const CTMgr_TrackACL_Authorization_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Access_level;
    string m_Access_key;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_TrackACL_Authorization_Base::IsSetAccess_level(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_TrackACL_Authorization_Base::CanGetAccess_level(void) const
{
    return IsSetAccess_level();
}

inline
void CTMgr_TrackACL_Authorization_Base::ResetAccess_level(void)
{
    m_Access_level = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CTMgr_TrackACL_Authorization_Base::TAccess_level CTMgr_TrackACL_Authorization_Base::GetAccess_level(void) const
{
    if (!CanGetAccess_level()) {
        ThrowUnassigned(0);
    }
    return m_Access_level;
}

inline
void CTMgr_TrackACL_Authorization_Base::SetAccess_level(CTMgr_TrackACL_Authorization_Base::TAccess_level value)
{
    m_Access_level = value;
    m_set_State[0] |= 0x3;
}

inline
CTMgr_TrackACL_Authorization_Base::TAccess_level& CTMgr_TrackACL_Authorization_Base::SetAccess_level(void)
{
#ifdef _DEBUG
    if (!IsSetAccess_level()) {
        memset(&m_Access_level,UnassignedByte(),sizeof(m_Access_level));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Access_level;
}

inline
bool CTMgr_TrackACL_Authorization_Base::IsSetAccess_key(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_TrackACL_Authorization_Base::CanGetAccess_key(void) const
{
    return IsSetAccess_key();
}

inline
const CTMgr_TrackACL_Authorization_Base::TAccess_key& CTMgr_TrackACL_Authorization_Base::GetAccess_key(void) const
{
    if (!CanGetAccess_key()) {
        ThrowUnassigned(1);
    }
    return m_Access_key;
}

inline
void CTMgr_TrackACL_Authorization_Base::SetAccess_key(const CTMgr_TrackACL_Authorization_Base::TAccess_key& value)
{
    m_Access_key = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_TrackACL_Authorization_Base::SetAccess_key(CTMgr_TrackACL_Authorization_Base::TAccess_key&& value)
{
    m_Access_key = std::forward<CTMgr_TrackACL_Authorization_Base::TAccess_key>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_TrackACL_Authorization_Base::TAccess_key& CTMgr_TrackACL_Authorization_Base::SetAccess_key(void)
{
#ifdef _DEBUG
    if (!IsSetAccess_key()) {
        m_Access_key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Access_key;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_TRACKACL_AUTHORIZATIO_BASE_HPP
