/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Field_rule_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'valid.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VALID_FIELD_RULE_BASE_HPP
#define OBJECTS_VALID_FIELD_RULE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/valid/Severity_level.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_VALID_EXPORT CField_rule_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CField_rule_Base(void);
    // destructor
    virtual ~CField_rule_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TField_name;
    typedef string TMatch_expression;
    typedef bool TRequired;
    typedef ESeverity_level TSeverity;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field_name,
        e_match_expression,
        e_required,
        e_severity
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TField_name
    ///  Check whether the Field_name data member has been assigned a value.
    bool IsSetField_name(void) const;
    /// Check whether it is safe or not to call GetField_name method.
    bool CanGetField_name(void) const;
    void ResetField_name(void);
    const TField_name& GetField_name(void) const;
    void SetField_name(const TField_name& value);
    void SetField_name(TField_name&& value);
    TField_name& SetField_name(void);

    /// optional
    /// typedef string TMatch_expression
    ///  Check whether the Match_expression data member has been assigned a value.
    bool IsSetMatch_expression(void) const;
    /// Check whether it is safe or not to call GetMatch_expression method.
    bool CanGetMatch_expression(void) const;
    void ResetMatch_expression(void);
    const TMatch_expression& GetMatch_expression(void) const;
    void SetMatch_expression(const TMatch_expression& value);
    void SetMatch_expression(TMatch_expression&& value);
    TMatch_expression& SetMatch_expression(void);

    /// optional with default false
    /// typedef bool TRequired
    ///  Check whether the Required data member has been assigned a value.
    bool IsSetRequired(void) const;
    /// Check whether it is safe or not to call GetRequired method.
    bool CanGetRequired(void) const;
    void ResetRequired(void);
    void SetDefaultRequired(void);
    TRequired GetRequired(void) const;
    void SetRequired(TRequired value);
    TRequired& SetRequired(void);

    /// optional with default eSeverity_level_warning
    /// typedef ESeverity_level TSeverity
    ///  Check whether the Severity data member has been assigned a value.
    bool IsSetSeverity(void) const;
    /// Check whether it is safe or not to call GetSeverity method.
    bool CanGetSeverity(void) const;
    void ResetSeverity(void);
    void SetDefaultSeverity(void);
    TSeverity GetSeverity(void) const;
    void SetSeverity(TSeverity value);
    TSeverity& SetSeverity(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CField_rule_Base(const CField_rule_Base&);
    CField_rule_Base& operator=(const CField_rule_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Field_name;
    string m_Match_expression;
    bool m_Required;
    ESeverity_level m_Severity;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CField_rule_Base::IsSetField_name(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CField_rule_Base::CanGetField_name(void) const
{
    return IsSetField_name();
}

inline
const CField_rule_Base::TField_name& CField_rule_Base::GetField_name(void) const
{
    if (!CanGetField_name()) {
        ThrowUnassigned(0);
    }
    return m_Field_name;
}

inline
void CField_rule_Base::SetField_name(const CField_rule_Base::TField_name& value)
{
    m_Field_name = value;
    m_set_State[0] |= 0x3;
}

inline
void CField_rule_Base::SetField_name(CField_rule_Base::TField_name&& value)
{
    m_Field_name = std::forward<CField_rule_Base::TField_name>(value);
    m_set_State[0] |= 0x3;
}

inline
CField_rule_Base::TField_name& CField_rule_Base::SetField_name(void)
{
#ifdef _DEBUG
    if (!IsSetField_name()) {
        m_Field_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Field_name;
}

inline
bool CField_rule_Base::IsSetMatch_expression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CField_rule_Base::CanGetMatch_expression(void) const
{
    return IsSetMatch_expression();
}

inline
const CField_rule_Base::TMatch_expression& CField_rule_Base::GetMatch_expression(void) const
{
    if (!CanGetMatch_expression()) {
        ThrowUnassigned(1);
    }
    return m_Match_expression;
}

inline
void CField_rule_Base::SetMatch_expression(const CField_rule_Base::TMatch_expression& value)
{
    m_Match_expression = value;
    m_set_State[0] |= 0xc;
}

inline
void CField_rule_Base::SetMatch_expression(CField_rule_Base::TMatch_expression&& value)
{
    m_Match_expression = std::forward<CField_rule_Base::TMatch_expression>(value);
    m_set_State[0] |= 0xc;
}

inline
CField_rule_Base::TMatch_expression& CField_rule_Base::SetMatch_expression(void)
{
#ifdef _DEBUG
    if (!IsSetMatch_expression()) {
        m_Match_expression = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Match_expression;
}

inline
bool CField_rule_Base::IsSetRequired(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CField_rule_Base::CanGetRequired(void) const
{
    return true;
}

inline
void CField_rule_Base::ResetRequired(void)
{
    m_Required = false;
    m_set_State[0] &= ~0x30;
}

inline
void CField_rule_Base::SetDefaultRequired(void)
{
    ResetRequired();
}

inline
CField_rule_Base::TRequired CField_rule_Base::GetRequired(void) const
{
    return m_Required;
}

inline
void CField_rule_Base::SetRequired(CField_rule_Base::TRequired value)
{
    m_Required = value;
    m_set_State[0] |= 0x30;
}

inline
CField_rule_Base::TRequired& CField_rule_Base::SetRequired(void)
{
#ifdef _DEBUG
    if (!IsSetRequired()) {
        memset(&m_Required,UnassignedByte(),sizeof(m_Required));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Required;
}

inline
bool CField_rule_Base::IsSetSeverity(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CField_rule_Base::CanGetSeverity(void) const
{
    return true;
}

inline
void CField_rule_Base::ResetSeverity(void)
{
    m_Severity = eSeverity_level_warning;
    m_set_State[0] &= ~0xc0;
}

inline
void CField_rule_Base::SetDefaultSeverity(void)
{
    ResetSeverity();
}

inline
CField_rule_Base::TSeverity CField_rule_Base::GetSeverity(void) const
{
    return m_Severity;
}

inline
void CField_rule_Base::SetSeverity(CField_rule_Base::TSeverity value)
{
    m_Severity = value;
    m_set_State[0] |= 0xc0;
}

inline
CField_rule_Base::TSeverity& CField_rule_Base::SetSeverity(void)
{
#ifdef _DEBUG
    if (!IsSetSeverity()) {
        memset(&m_Severity,UnassignedByte(),sizeof(m_Severity));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Severity;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VALID_FIELD_RULE_BASE_HPP
