/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Error_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'search_by_rsid.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_LIBS_DBSNP_SEARCH_BY_RSID_ERROR_BASE_HPP
#define OBJECTS_VARIATION_LIBS_DBSNP_SEARCH_BY_RSID_ERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// In case of error service will return this object.
class CError_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CError_Base(void);
    // destructor
    virtual ~CError_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TMessage;
    typedef int TError_code;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_message,
        e_error_code
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Error description. 
    /// mandatory
    /// typedef string TMessage
    ///  Check whether the Message data member has been assigned a value.
    bool IsSetMessage(void) const;
    /// Check whether it is safe or not to call GetMessage method.
    bool CanGetMessage(void) const;
    void ResetMessage(void);
    const TMessage& GetMessage(void) const;
    void SetMessage(const TMessage& value);
    void SetMessage(TMessage&& value);
    TMessage& SetMessage(void);

    /// Error code. Which is also be copied to HTTP return code.
    /// mandatory
    /// typedef int TError_code
    ///  Check whether the Error_code data member has been assigned a value.
    bool IsSetError_code(void) const;
    /// Check whether it is safe or not to call GetError_code method.
    bool CanGetError_code(void) const;
    void ResetError_code(void);
    TError_code GetError_code(void) const;
    void SetError_code(TError_code value);
    TError_code& SetError_code(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CError_Base(const CError_Base&);
    CError_Base& operator=(const CError_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Message;
    int m_Error_code;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CError_Base::IsSetMessage(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CError_Base::CanGetMessage(void) const
{
    return IsSetMessage();
}

inline
const CError_Base::TMessage& CError_Base::GetMessage(void) const
{
    if (!CanGetMessage()) {
        ThrowUnassigned(0);
    }
    return m_Message;
}

inline
void CError_Base::SetMessage(const CError_Base::TMessage& value)
{
    m_Message = value;
    m_set_State[0] |= 0x3;
}

inline
void CError_Base::SetMessage(CError_Base::TMessage&& value)
{
    m_Message = std::forward<CError_Base::TMessage>(value);
    m_set_State[0] |= 0x3;
}

inline
CError_Base::TMessage& CError_Base::SetMessage(void)
{
#ifdef _DEBUG
    if (!IsSetMessage()) {
        m_Message = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Message;
}

inline
bool CError_Base::IsSetError_code(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CError_Base::CanGetError_code(void) const
{
    return IsSetError_code();
}

inline
void CError_Base::ResetError_code(void)
{
    m_Error_code = 0;
    m_set_State[0] &= ~0xc;
}

inline
CError_Base::TError_code CError_Base::GetError_code(void) const
{
    if (!CanGetError_code()) {
        ThrowUnassigned(1);
    }
    return m_Error_code;
}

inline
void CError_Base::SetError_code(CError_Base::TError_code value)
{
    m_Error_code = value;
    m_set_State[0] |= 0xc;
}

inline
CError_Base::TError_code& CError_Base::SetError_code(void)
{
#ifdef _DEBUG
    if (!IsSetError_code()) {
        memset(&m_Error_code,UnassignedByte(),sizeof(m_Error_code));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Error_code;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_LIBS_DBSNP_SEARCH_BY_RSID_ERROR_BASE_HPP
