/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Placement_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'search_by_rsid.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_LIBS_DBSNP_SEARCH_BY_RSID_PLACEMENT_BASE_HPP
#define OBJECTS_VARIATION_LIBS_DBSNP_SEARCH_BY_RSID_PLACEMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_DTrackId;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Placement definition.
class CPlacement_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPlacement_Base(void);
    // destructor
    virtual ~CPlacement_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TRsid;
    typedef string TAcc_ver;
    typedef int TFrom;
    typedef int TLength;
    typedef string TAssembly_acc;
    typedef list< CRef< CTMgr_DTrackId > > TTracks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_rsid,
        e_acc_ver,
        e_from,
        e_length,
        e_assembly_acc,
        e_tracks
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// Id of RefSnp in string format. For example "rs268".
    /// mandatory
    /// typedef string TRsid
    ///  Check whether the Rsid data member has been assigned a value.
    bool IsSetRsid(void) const;
    /// Check whether it is safe or not to call GetRsid method.
    bool CanGetRsid(void) const;
    void ResetRsid(void);
    const TRsid& GetRsid(void) const;
    void SetRsid(const TRsid& value);
    void SetRsid(TRsid&& value);
    TRsid& SetRsid(void);

    /// The sequence identifier in accession.version format.
    /// For example, "NC_000018.10"
    /// mandatory
    /// typedef string TAcc_ver
    ///  Check whether the Acc_ver data member has been assigned a value.
    bool IsSetAcc_ver(void) const;
    /// Check whether it is safe or not to call GetAcc_ver method.
    bool CanGetAcc_ver(void) const;
    void ResetAcc_ver(void);
    const TAcc_ver& GetAcc_ver(void) const;
    void SetAcc_ver(const TAcc_ver& value);
    void SetAcc_ver(TAcc_ver&& value);
    TAcc_ver& SetAcc_ver(void);

    /// Start position on reference seq of the variation (0-based)
    /// mandatory
    /// typedef int TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    TFrom GetFrom(void) const;
    void SetFrom(TFrom value);
    TFrom& SetFrom(void);

    /// Length of the variant deletion interval.
    /// mandatory
    /// typedef int TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    TLength GetLength(void) const;
    void SetLength(TLength value);
    TLength& SetLength(void);

    /// Assembly id in accession.version format.
    /// For example, "GCF_000001405.33".
    /// optional
    /// typedef string TAssembly_acc
    ///  Check whether the Assembly_acc data member has been assigned a value.
    bool IsSetAssembly_acc(void) const;
    /// Check whether it is safe or not to call GetAssembly_acc method.
    bool CanGetAssembly_acc(void) const;
    void ResetAssembly_acc(void);
    const TAssembly_acc& GetAssembly_acc(void) const;
    void SetAssembly_acc(const TAssembly_acc& value);
    void SetAssembly_acc(TAssembly_acc&& value);
    TAssembly_acc& SetAssembly_acc(void);

    /// List of related TMS tracks-ids.
    /// For example "T709990".
    /// mandatory
    /// typedef list< CRef< CTMgr_DTrackId > > TTracks
    ///  Check whether the Tracks data member has been assigned a value.
    bool IsSetTracks(void) const;
    /// Check whether it is safe or not to call GetTracks method.
    bool CanGetTracks(void) const;
    void ResetTracks(void);
    const TTracks& GetTracks(void) const;
    TTracks& SetTracks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPlacement_Base(const CPlacement_Base&);
    CPlacement_Base& operator=(const CPlacement_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Rsid;
    string m_Acc_ver;
    int m_From;
    int m_Length;
    string m_Assembly_acc;
    list< CRef< CTMgr_DTrackId > > m_Tracks;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPlacement_Base::IsSetRsid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPlacement_Base::CanGetRsid(void) const
{
    return IsSetRsid();
}

inline
const CPlacement_Base::TRsid& CPlacement_Base::GetRsid(void) const
{
    if (!CanGetRsid()) {
        ThrowUnassigned(0);
    }
    return m_Rsid;
}

inline
void CPlacement_Base::SetRsid(const CPlacement_Base::TRsid& value)
{
    m_Rsid = value;
    m_set_State[0] |= 0x3;
}

inline
void CPlacement_Base::SetRsid(CPlacement_Base::TRsid&& value)
{
    m_Rsid = std::forward<CPlacement_Base::TRsid>(value);
    m_set_State[0] |= 0x3;
}

inline
CPlacement_Base::TRsid& CPlacement_Base::SetRsid(void)
{
#ifdef _DEBUG
    if (!IsSetRsid()) {
        m_Rsid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Rsid;
}

inline
bool CPlacement_Base::IsSetAcc_ver(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPlacement_Base::CanGetAcc_ver(void) const
{
    return IsSetAcc_ver();
}

inline
const CPlacement_Base::TAcc_ver& CPlacement_Base::GetAcc_ver(void) const
{
    if (!CanGetAcc_ver()) {
        ThrowUnassigned(1);
    }
    return m_Acc_ver;
}

inline
void CPlacement_Base::SetAcc_ver(const CPlacement_Base::TAcc_ver& value)
{
    m_Acc_ver = value;
    m_set_State[0] |= 0xc;
}

inline
void CPlacement_Base::SetAcc_ver(CPlacement_Base::TAcc_ver&& value)
{
    m_Acc_ver = std::forward<CPlacement_Base::TAcc_ver>(value);
    m_set_State[0] |= 0xc;
}

inline
CPlacement_Base::TAcc_ver& CPlacement_Base::SetAcc_ver(void)
{
#ifdef _DEBUG
    if (!IsSetAcc_ver()) {
        m_Acc_ver = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Acc_ver;
}

inline
bool CPlacement_Base::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPlacement_Base::CanGetFrom(void) const
{
    return IsSetFrom();
}

inline
void CPlacement_Base::ResetFrom(void)
{
    m_From = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPlacement_Base::TFrom CPlacement_Base::GetFrom(void) const
{
    if (!CanGetFrom()) {
        ThrowUnassigned(2);
    }
    return m_From;
}

inline
void CPlacement_Base::SetFrom(CPlacement_Base::TFrom value)
{
    m_From = value;
    m_set_State[0] |= 0x30;
}

inline
CPlacement_Base::TFrom& CPlacement_Base::SetFrom(void)
{
#ifdef _DEBUG
    if (!IsSetFrom()) {
        memset(&m_From,UnassignedByte(),sizeof(m_From));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_From;
}

inline
bool CPlacement_Base::IsSetLength(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPlacement_Base::CanGetLength(void) const
{
    return IsSetLength();
}

inline
void CPlacement_Base::ResetLength(void)
{
    m_Length = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPlacement_Base::TLength CPlacement_Base::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(3);
    }
    return m_Length;
}

inline
void CPlacement_Base::SetLength(CPlacement_Base::TLength value)
{
    m_Length = value;
    m_set_State[0] |= 0xc0;
}

inline
CPlacement_Base::TLength& CPlacement_Base::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        memset(&m_Length,UnassignedByte(),sizeof(m_Length));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Length;
}

inline
bool CPlacement_Base::IsSetAssembly_acc(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPlacement_Base::CanGetAssembly_acc(void) const
{
    return IsSetAssembly_acc();
}

inline
const CPlacement_Base::TAssembly_acc& CPlacement_Base::GetAssembly_acc(void) const
{
    if (!CanGetAssembly_acc()) {
        ThrowUnassigned(4);
    }
    return m_Assembly_acc;
}

inline
void CPlacement_Base::SetAssembly_acc(const CPlacement_Base::TAssembly_acc& value)
{
    m_Assembly_acc = value;
    m_set_State[0] |= 0x300;
}

inline
void CPlacement_Base::SetAssembly_acc(CPlacement_Base::TAssembly_acc&& value)
{
    m_Assembly_acc = std::forward<CPlacement_Base::TAssembly_acc>(value);
    m_set_State[0] |= 0x300;
}

inline
CPlacement_Base::TAssembly_acc& CPlacement_Base::SetAssembly_acc(void)
{
#ifdef _DEBUG
    if (!IsSetAssembly_acc()) {
        m_Assembly_acc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Assembly_acc;
}

inline
bool CPlacement_Base::IsSetTracks(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPlacement_Base::CanGetTracks(void) const
{
    return true;
}

inline
const CPlacement_Base::TTracks& CPlacement_Base::GetTracks(void) const
{
    return m_Tracks;
}

inline
CPlacement_Base::TTracks& CPlacement_Base::SetTracks(void)
{
    m_set_State[0] |= 0x400;
    return m_Tracks;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_LIBS_DBSNP_SEARCH_BY_RSID_PLACEMENT_BASE_HPP
