/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AbstractText_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ABSTRACTTEXT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ABSTRACTTEXT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/Text.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDispFormula;
class CMath;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAbstractText_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CAbstractText_Base(void);
    // destructor
    virtual ~CAbstractText_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_NlmCategory {
            eAttlist_NlmCategory_BACKGROUND  = 1,
            eAttlist_NlmCategory_OBJECTIVE   = 2,
            eAttlist_NlmCategory_METHODS     = 3,
            eAttlist_NlmCategory_RESULTS     = 4,
            eAttlist_NlmCategory_CONCLUSIONS = 5,
            eAttlist_NlmCategory_UNASSIGNED  = 6
        };
        
        /// Access to EAttlist_NlmCategory's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_NlmCategory)(void);
        
        // types
        typedef NCBI_NS_STD::string TLabel;
        typedef EAttlist_NlmCategory TNlmCategory;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Label,
            e_NlmCategory
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TLabel
        ///  Check whether the Label data member has been assigned a value.
        bool IsSetLabel(void) const;
        /// Check whether it is safe or not to call GetLabel method.
        bool CanGetLabel(void) const;
        void ResetLabel(void);
        const TLabel& GetLabel(void) const;
        void SetLabel(const TLabel& value);
        void SetLabel(TLabel&& value);
        TLabel& SetLabel(void);
    
        /// optional
        /// typedef EAttlist_NlmCategory TNlmCategory
        ///  Check whether the NlmCategory data member has been assigned a value.
        bool IsSetNlmCategory(void) const;
        /// Check whether it is safe or not to call GetNlmCategory method.
        bool CanGetNlmCategory(void) const;
        void ResetNlmCategory(void);
        TNlmCategory GetNlmCategory(void) const;
        void SetNlmCategory(TNlmCategory value);
        TNlmCategory& SetNlmCategory(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Label;
        EAttlist_NlmCategory m_NlmCategory;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_AbstractText : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_AbstractText(void);
        // destructor
        ~C_E_AbstractText(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        typedef CText C_Text;
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e__CharData,
            e_Text,
            e_Math,
            e_DispFormula
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_DispFormula+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef C_Text TText;
        typedef CMath TMath;
        typedef CDispFormula TDispFormula;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef C_Text TText
        bool IsText(void) const;
        const TText& GetText(void) const;
        TText& SetText(void);
        void SetText(TText& value);
    
        // typedef CMath TMath
        bool IsMath(void) const;
        const TMath& GetMath(void) const;
        TMath& SetMath(void);
        void SetMath(TMath& value);
    
        // typedef CDispFormula TDispFormula
        bool IsDispFormula(void) const;
        const TDispFormula& GetDispFormula(void) const;
        TDispFormula& SetDispFormula(void);
        void SetDispFormula(TDispFormula& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_AbstractText(const C_E_AbstractText& );
        C_E_AbstractText& operator=(const C_E_AbstractText& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_AbstractText C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_AbstractText > > TAbstractText;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_AbstractText
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_AbstractText > > TAbstractText
    ///  Check whether the AbstractText data member has been assigned a value.
    bool IsSetAbstractText(void) const;
    /// Check whether it is safe or not to call GetAbstractText method.
    bool CanGetAbstractText(void) const;
    void ResetAbstractText(void);
    const TAbstractText& GetAbstractText(void) const;
    TAbstractText& SetAbstractText(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAbstractText_Base(const CAbstractText_Base&);
    CAbstractText_Base& operator=(const CAbstractText_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_AbstractText > > m_AbstractText;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAbstractText_Base::C_Attlist::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAbstractText_Base::C_Attlist::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CAbstractText_Base::C_Attlist::TLabel& CAbstractText_Base::C_Attlist::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(0);
    }
    return m_Label;
}

inline
void CAbstractText_Base::C_Attlist::SetLabel(const CAbstractText_Base::C_Attlist::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0x3;
}

inline
void CAbstractText_Base::C_Attlist::SetLabel(CAbstractText_Base::C_Attlist::TLabel&& value)
{
    m_Label = std::forward<CAbstractText_Base::C_Attlist::TLabel>(value);
    m_set_State[0] |= 0x3;
}

inline
CAbstractText_Base::C_Attlist::TLabel& CAbstractText_Base::C_Attlist::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Label;
}

inline
bool CAbstractText_Base::C_Attlist::IsSetNlmCategory(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAbstractText_Base::C_Attlist::CanGetNlmCategory(void) const
{
    return IsSetNlmCategory();
}

inline
void CAbstractText_Base::C_Attlist::ResetNlmCategory(void)
{
    m_NlmCategory = (EAttlist_NlmCategory)(0);
    m_set_State[0] &= ~0xc;
}

inline
CAbstractText_Base::C_Attlist::TNlmCategory CAbstractText_Base::C_Attlist::GetNlmCategory(void) const
{
    if (!CanGetNlmCategory()) {
        ThrowUnassigned(1);
    }
    return m_NlmCategory;
}

inline
void CAbstractText_Base::C_Attlist::SetNlmCategory(CAbstractText_Base::C_Attlist::TNlmCategory value)
{
    m_NlmCategory = value;
    m_set_State[0] |= 0xc;
}

inline
CAbstractText_Base::C_Attlist::TNlmCategory& CAbstractText_Base::C_Attlist::SetNlmCategory(void)
{
#ifdef _DEBUG
    if (!IsSetNlmCategory()) {
        memset(&m_NlmCategory,UnassignedByte(),sizeof(m_NlmCategory));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_NlmCategory;
}

inline
CAbstractText_Base::C_E_AbstractText::E_Choice CAbstractText_Base::C_E_AbstractText::Which(void) const
{
    return m_choice;
}

inline
void CAbstractText_Base::C_E_AbstractText::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAbstractText_Base::C_E_AbstractText::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAbstractText_Base::C_E_AbstractText::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAbstractText_Base::C_E_AbstractText::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CAbstractText_Base::C_E_AbstractText::T_CharData& CAbstractText_Base::C_E_AbstractText::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CAbstractText_Base::C_E_AbstractText::T_CharData& CAbstractText_Base::C_E_AbstractText::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CAbstractText_Base::C_E_AbstractText::IsText(void) const
{
    return m_choice == e_Text;
}

inline
bool CAbstractText_Base::C_E_AbstractText::IsMath(void) const
{
    return m_choice == e_Math;
}

inline
bool CAbstractText_Base::C_E_AbstractText::IsDispFormula(void) const
{
    return m_choice == e_DispFormula;
}

inline
bool CAbstractText_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAbstractText_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CAbstractText_Base::TAttlist& CAbstractText_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CAbstractText_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAbstractText_Base::TAttlist& CAbstractText_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAbstractText_Base::IsSetAbstractText(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAbstractText_Base::CanGetAbstractText(void) const
{
    return true;
}

inline
const CAbstractText_Base::TAbstractText& CAbstractText_Base::GetAbstractText(void) const
{
    return m_AbstractText;
}

inline
CAbstractText_Base::TAbstractText& CAbstractText_Base::SetAbstractText(void)
{
    m_set_State[0] |= 0x4;
    return m_AbstractText;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ABSTRACTTEXT_BASE_HPP
