/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AffiliationInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_AFFILIATIONINFO_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_AFFILIATIONINFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAffiliation;
class CIdentifier;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAffiliationInfo_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CAffiliationInfo_Base(void);
    // destructor
    virtual ~CAffiliationInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CAffiliation TAffiliation;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > TIdentifier;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Affiliation,
        e_Identifier
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CAffiliation TAffiliation
    ///  Check whether the Affiliation data member has been assigned a value.
    bool IsSetAffiliation(void) const;
    /// Check whether it is safe or not to call GetAffiliation method.
    bool CanGetAffiliation(void) const;
    void ResetAffiliation(void);
    const TAffiliation& GetAffiliation(void) const;
    void SetAffiliation(TAffiliation& value);
    TAffiliation& SetAffiliation(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > TIdentifier
    ///  Check whether the Identifier data member has been assigned a value.
    bool IsSetIdentifier(void) const;
    /// Check whether it is safe or not to call GetIdentifier method.
    bool CanGetIdentifier(void) const;
    void ResetIdentifier(void);
    const TIdentifier& GetIdentifier(void) const;
    TIdentifier& SetIdentifier(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAffiliationInfo_Base(const CAffiliationInfo_Base&);
    CAffiliationInfo_Base& operator=(const CAffiliationInfo_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAffiliation > m_Affiliation;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdentifier > > m_Identifier;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAffiliationInfo_Base::IsSetAffiliation(void) const
{
    return m_Affiliation.NotEmpty();
}

inline
bool CAffiliationInfo_Base::CanGetAffiliation(void) const
{
    return true;
}

inline
const CAffiliationInfo_Base::TAffiliation& CAffiliationInfo_Base::GetAffiliation(void) const
{
    if ( !m_Affiliation ) {
        const_cast<CAffiliationInfo_Base*>(this)->ResetAffiliation();
    }
    return (*m_Affiliation);
}

inline
CAffiliationInfo_Base::TAffiliation& CAffiliationInfo_Base::SetAffiliation(void)
{
    if ( !m_Affiliation ) {
        ResetAffiliation();
    }
    return (*m_Affiliation);
}

inline
bool CAffiliationInfo_Base::IsSetIdentifier(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAffiliationInfo_Base::CanGetIdentifier(void) const
{
    return true;
}

inline
const CAffiliationInfo_Base::TIdentifier& CAffiliationInfo_Base::GetIdentifier(void) const
{
    return m_Identifier;
}

inline
CAffiliationInfo_Base::TIdentifier& CAffiliationInfo_Base::SetIdentifier(void)
{
    m_set_State[0] |= 0x4;
    return m_Identifier;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_AFFILIATIONINFO_BASE_HPP
