/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Annotation.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// New methods or data members can be added to it if needed.
/// See also: Annotation_.hpp


#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ANNOTATION_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ANNOTATION_HPP


// generated includes
#include <objtools/eutils/efetch/Annotation_.hpp>

// generated classes

BEGIN_eutils_SCOPE // namespace eutils::

/////////////////////////////////////////////////////////////////////////////
class CAnnotation : public CAnnotation_Base
{
    typedef CAnnotation_Base Tparent;
public:
    // constructor
    CAnnotation(void);
    CAnnotation(const std::string& value);
    // destructor
    ~CAnnotation(void);

    // typedef std::string TAnnotation;

    /// Conversion operator to 'TAnnotation' type.
    operator const TAnnotation&(void) const;
    /// Assignment operator.
    CAnnotation& operator=(const TAnnotation& value);

private:
    // Prohibit copy constructor and assignment operator
    CAnnotation(const CAnnotation& value);
    CAnnotation& operator=(const CAnnotation& value);

};

/////////////////// CAnnotation inline methods

// constructor
inline
CAnnotation::CAnnotation(void)
{
}

inline
CAnnotation::CAnnotation(const std::string& value)
{
    SetAnnotation(value);
}

inline
CAnnotation::operator const CAnnotation::TAnnotation&(void) const
{
    return GetAnnotation();
}

inline
CAnnotation& CAnnotation::operator=(const TAnnotation& value)
{
    SetAnnotation(value);
    return *this;
}


/////////////////// end of CAnnotation inline methods


END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ANNOTATION_HPP
/* Original file checksum: lines: 109, chars: 2970, CRC32: 1cbb594f */
