/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ArticleId_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEID_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CArticleId_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CArticleId_Base(void);
    // destructor
    virtual ~CArticleId_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_IdType {
            eAttlist_IdType_doi           =  1,
            eAttlist_IdType_pii           =  2,
            eAttlist_IdType_pmcpid        =  3,
            eAttlist_IdType_pmpid         =  4,
            eAttlist_IdType_pmc           =  5,
            eAttlist_IdType_mid           =  6,
            eAttlist_IdType_sici          =  7,
            eAttlist_IdType_pubmed        =  8,
            eAttlist_IdType_medline       =  9,
            eAttlist_IdType_pmcid         = 10,
            eAttlist_IdType_pmcbook       = 11,
            eAttlist_IdType_bookaccession = 12
        };
        
        /// Access to EAttlist_IdType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_IdType)(void);
        
        // types
        typedef EAttlist_IdType TIdType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_IdType
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_IdType_pubmed
        /// typedef EAttlist_IdType TIdType
        ///  Check whether the IdType data member has been assigned a value.
        bool IsSetIdType(void) const;
        /// Check whether it is safe or not to call GetIdType method.
        bool CanGetIdType(void) const;
        void ResetIdType(void);
        void SetDefaultIdType(void);
        TIdType GetIdType(void) const;
        void SetIdType(TIdType value);
        TIdType& SetIdType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_IdType m_IdType;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TArticleId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_ArticleId
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TArticleId
    ///  Check whether the ArticleId data member has been assigned a value.
    bool IsSetArticleId(void) const;
    /// Check whether it is safe or not to call GetArticleId method.
    bool CanGetArticleId(void) const;
    void ResetArticleId(void);
    const TArticleId& GetArticleId(void) const;
    void SetArticleId(const TArticleId& value);
    void SetArticleId(TArticleId&& value);
    TArticleId& SetArticleId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CArticleId_Base(const CArticleId_Base&);
    CArticleId_Base& operator=(const CArticleId_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_ArticleId;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CArticleId_Base::C_Attlist::IsSetIdType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CArticleId_Base::C_Attlist::CanGetIdType(void) const
{
    return true;
}

inline
void CArticleId_Base::C_Attlist::ResetIdType(void)
{
    m_IdType = eAttlist_IdType_pubmed;
    m_set_State[0] &= ~0x3;
}

inline
void CArticleId_Base::C_Attlist::SetDefaultIdType(void)
{
    ResetIdType();
    m_set_State[0] |= 0x1;
}

inline
CArticleId_Base::C_Attlist::TIdType CArticleId_Base::C_Attlist::GetIdType(void) const
{
    return m_IdType;
}

inline
void CArticleId_Base::C_Attlist::SetIdType(CArticleId_Base::C_Attlist::TIdType value)
{
    m_IdType = value;
    m_set_State[0] |= 0x3;
}

inline
CArticleId_Base::C_Attlist::TIdType& CArticleId_Base::C_Attlist::SetIdType(void)
{
#ifdef _DEBUG
    if (!IsSetIdType()) {
        memset(&m_IdType,UnassignedByte(),sizeof(m_IdType));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_IdType;
}

inline
bool CArticleId_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CArticleId_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CArticleId_Base::TAttlist& CArticleId_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CArticleId_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CArticleId_Base::TAttlist& CArticleId_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CArticleId_Base::IsSetArticleId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CArticleId_Base::CanGetArticleId(void) const
{
    return IsSetArticleId();
}

inline
const CArticleId_Base::TArticleId& CArticleId_Base::GetArticleId(void) const
{
    if (!CanGetArticleId()) {
        ThrowUnassigned(1);
    }
    return m_ArticleId;
}

inline
void CArticleId_Base::SetArticleId(const CArticleId_Base::TArticleId& value)
{
    m_ArticleId = value;
    m_set_State[0] |= 0xc;
}

inline
void CArticleId_Base::SetArticleId(CArticleId_Base::TArticleId&& value)
{
    m_ArticleId = std::forward<CArticleId_Base::TArticleId>(value);
    m_set_State[0] |= 0xc;
}

inline
CArticleId_Base::TArticleId& CArticleId_Base::SetArticleId(void)
{
#ifdef _DEBUG
    if (!IsSetArticleId()) {
        m_ArticleId = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ArticleId;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEID_BASE_HPP
