/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Chemical_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_CHEMICAL_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_CHEMICAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CNameOfSubstance;
class CRegistryNumber;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CChemical_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CChemical_Base(void);
    // destructor
    virtual ~CChemical_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CRegistryNumber TRegistryNumber;
    typedef CNameOfSubstance TNameOfSubstance;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_RegistryNumber,
        e_NameOfSubstance
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CRegistryNumber TRegistryNumber
    ///  Check whether the RegistryNumber data member has been assigned a value.
    bool IsSetRegistryNumber(void) const;
    /// Check whether it is safe or not to call GetRegistryNumber method.
    bool CanGetRegistryNumber(void) const;
    void ResetRegistryNumber(void);
    const TRegistryNumber& GetRegistryNumber(void) const;
    void SetRegistryNumber(TRegistryNumber& value);
    TRegistryNumber& SetRegistryNumber(void);

    /// mandatory
    /// typedef CNameOfSubstance TNameOfSubstance
    ///  Check whether the NameOfSubstance data member has been assigned a value.
    bool IsSetNameOfSubstance(void) const;
    /// Check whether it is safe or not to call GetNameOfSubstance method.
    bool CanGetNameOfSubstance(void) const;
    void ResetNameOfSubstance(void);
    const TNameOfSubstance& GetNameOfSubstance(void) const;
    void SetNameOfSubstance(TNameOfSubstance& value);
    TNameOfSubstance& SetNameOfSubstance(void);
    void SetNameOfSubstance(const NCBI_NS_STD::string& value);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CChemical_Base(const CChemical_Base&);
    CChemical_Base& operator=(const CChemical_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TRegistryNumber > m_RegistryNumber;
    NCBI_NS_NCBI::CRef< TNameOfSubstance > m_NameOfSubstance;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CChemical_Base::IsSetRegistryNumber(void) const
{
    return m_RegistryNumber.NotEmpty();
}

inline
bool CChemical_Base::CanGetRegistryNumber(void) const
{
    return true;
}

inline
const CChemical_Base::TRegistryNumber& CChemical_Base::GetRegistryNumber(void) const
{
    if ( !m_RegistryNumber ) {
        const_cast<CChemical_Base*>(this)->ResetRegistryNumber();
    }
    return (*m_RegistryNumber);
}

inline
CChemical_Base::TRegistryNumber& CChemical_Base::SetRegistryNumber(void)
{
    if ( !m_RegistryNumber ) {
        ResetRegistryNumber();
    }
    return (*m_RegistryNumber);
}

inline
bool CChemical_Base::IsSetNameOfSubstance(void) const
{
    return m_NameOfSubstance.NotEmpty();
}

inline
bool CChemical_Base::CanGetNameOfSubstance(void) const
{
    return true;
}

inline
const CChemical_Base::TNameOfSubstance& CChemical_Base::GetNameOfSubstance(void) const
{
    if ( !m_NameOfSubstance ) {
        const_cast<CChemical_Base*>(this)->ResetNameOfSubstance();
    }
    return (*m_NameOfSubstance);
}

inline
CChemical_Base::TNameOfSubstance& CChemical_Base::SetNameOfSubstance(void)
{
    if ( !m_NameOfSubstance ) {
        ResetNameOfSubstance();
    }
    return (*m_NameOfSubstance);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_CHEMICAL_BASE_HPP
