/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DataBank_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DATABANK_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DATABANK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAccessionNumberList;
class CDataBankName;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDataBank_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDataBank_Base(void);
    // destructor
    virtual ~CDataBank_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDataBankName TDataBankName;
    typedef CAccessionNumberList TAccessionNumberList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_DataBankName,
        e_AccessionNumberList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CDataBankName TDataBankName
    ///  Check whether the DataBankName data member has been assigned a value.
    bool IsSetDataBankName(void) const;
    /// Check whether it is safe or not to call GetDataBankName method.
    bool CanGetDataBankName(void) const;
    void ResetDataBankName(void);
    const TDataBankName& GetDataBankName(void) const;
    void SetDataBankName(TDataBankName& value);
    TDataBankName& SetDataBankName(void);

    /// optional
    /// typedef CAccessionNumberList TAccessionNumberList
    ///  Check whether the AccessionNumberList data member has been assigned a value.
    bool IsSetAccessionNumberList(void) const;
    /// Check whether it is safe or not to call GetAccessionNumberList method.
    bool CanGetAccessionNumberList(void) const;
    void ResetAccessionNumberList(void);
    const TAccessionNumberList& GetAccessionNumberList(void) const;
    void SetAccessionNumberList(TAccessionNumberList& value);
    TAccessionNumberList& SetAccessionNumberList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDataBank_Base(const CDataBank_Base&);
    CDataBank_Base& operator=(const CDataBank_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TDataBankName > m_DataBankName;
    NCBI_NS_NCBI::CRef< TAccessionNumberList > m_AccessionNumberList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDataBank_Base::IsSetDataBankName(void) const
{
    return m_DataBankName.NotEmpty();
}

inline
bool CDataBank_Base::CanGetDataBankName(void) const
{
    return true;
}

inline
const CDataBank_Base::TDataBankName& CDataBank_Base::GetDataBankName(void) const
{
    if ( !m_DataBankName ) {
        const_cast<CDataBank_Base*>(this)->ResetDataBankName();
    }
    return (*m_DataBankName);
}

inline
CDataBank_Base::TDataBankName& CDataBank_Base::SetDataBankName(void)
{
    if ( !m_DataBankName ) {
        ResetDataBankName();
    }
    return (*m_DataBankName);
}

inline
bool CDataBank_Base::IsSetAccessionNumberList(void) const
{
    return m_AccessionNumberList.NotEmpty();
}

inline
bool CDataBank_Base::CanGetAccessionNumberList(void) const
{
    return IsSetAccessionNumberList();
}

inline
const CDataBank_Base::TAccessionNumberList& CDataBank_Base::GetAccessionNumberList(void) const
{
    if (!CanGetAccessionNumberList()) {
        ThrowUnassigned(1);
    }
    return (*m_AccessionNumberList);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DATABANK_BASE_HPP
