/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DescriptorName.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// New methods or data members can be added to it if needed.
/// See also: DescriptorName_.hpp


#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DESCRIPTORNAME_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DESCRIPTORNAME_HPP


// generated includes
#include <objtools/eutils/efetch/DescriptorName_.hpp>

// generated classes

BEGIN_eutils_SCOPE // namespace eutils::

/////////////////////////////////////////////////////////////////////////////
class CDescriptorName : public CDescriptorName_Base
{
    typedef CDescriptorName_Base Tparent;
public:
    // constructor
    CDescriptorName(void);
    CDescriptorName(const std::string& value);
    // destructor
    ~CDescriptorName(void);

    // typedef std::string TDescriptorName;

    /// Conversion operator to 'TDescriptorName' type.
    operator const TDescriptorName&(void) const;
    /// Assignment operator.
    CDescriptorName& operator=(const TDescriptorName& value);

private:
    // Prohibit copy constructor and assignment operator
    CDescriptorName(const CDescriptorName& value);
    CDescriptorName& operator=(const CDescriptorName& value);

};

/////////////////// CDescriptorName inline methods

// constructor
inline
CDescriptorName::CDescriptorName(void)
{
}

inline
CDescriptorName::CDescriptorName(const std::string& value)
{
    SetDescriptorName(value);
}

inline
CDescriptorName::operator const CDescriptorName::TDescriptorName&(void) const
{
    return GetDescriptorName();
}

inline
CDescriptorName& CDescriptorName::operator=(const TDescriptorName& value)
{
    SetDescriptorName(value);
    return *this;
}


/////////////////// end of CDescriptorName inline methods


END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DESCRIPTORNAME_HPP
/* Original file checksum: lines: 109, chars: 3114, CRC32: fabefa70 */
