/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DomainQ_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DOMAINQ_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DOMAINQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CCondition;
class CDomainofapplication;
class CLowlimit;
class CUplimit;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDomainQ_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDomainQ_Base(void);
    // destructor
    virtual ~CDomainQ_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_E : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E(void);
        // destructor
        ~C_E(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_LU : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_LU(void);
            // destructor
            ~C_LU(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CLowlimit TLowlimit;
            typedef CUplimit TUplimit;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_lowlimit,
                e_uplimit
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CLowlimit TLowlimit
            ///  Check whether the Lowlimit data member has been assigned a value.
            bool IsSetLowlimit(void) const;
            /// Check whether it is safe or not to call GetLowlimit method.
            bool CanGetLowlimit(void) const;
            void ResetLowlimit(void);
            const TLowlimit& GetLowlimit(void) const;
            void SetLowlimit(TLowlimit& value);
            TLowlimit& SetLowlimit(void);
        
            /// optional
            /// typedef CUplimit TUplimit
            ///  Check whether the Uplimit data member has been assigned a value.
            bool IsSetUplimit(void) const;
            /// Check whether it is safe or not to call GetUplimit method.
            bool CanGetUplimit(void) const;
            void ResetUplimit(void);
            const TUplimit& GetUplimit(void) const;
            void SetUplimit(TUplimit& value);
            TUplimit& SetUplimit(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_LU(const C_LU&);
            C_LU& operator=(const C_LU&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_NCBI::CRef< TLowlimit > m_Lowlimit;
            NCBI_NS_NCBI::CRef< TUplimit > m_Uplimit;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,          ///< No variant selected
            e_Domainofapplication,
            e_Condition,
            e_LU
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_LU+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef CDomainofapplication TDomainofapplication;
        typedef CCondition TCondition;
        typedef C_LU TLU;
    
        // getters
        // setters
    
        // typedef CDomainofapplication TDomainofapplication
        bool IsDomainofapplication(void) const;
        const TDomainofapplication& GetDomainofapplication(void) const;
        TDomainofapplication& SetDomainofapplication(void);
        void SetDomainofapplication(TDomainofapplication& value);
    
        // typedef CCondition TCondition
        bool IsCondition(void) const;
        const TCondition& GetCondition(void) const;
        TCondition& SetCondition(void);
        void SetCondition(TCondition& value);
    
        // typedef C_LU TLU
        bool IsLU(void) const;
        const TLU& GetLU(void) const;
        TLU& SetLU(void);
        void SetLU(TLU& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E(const C_E& );
        C_E& operator=(const C_E& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CDomainQ_Base(const CDomainQ_Base&);
    CDomainQ_Base& operator=(const CDomainQ_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDomainQ_Base::C_E::C_LU::IsSetLowlimit(void) const
{
    return m_Lowlimit.NotEmpty();
}

inline
bool CDomainQ_Base::C_E::C_LU::CanGetLowlimit(void) const
{
    return true;
}

inline
const CDomainQ_Base::C_E::C_LU::TLowlimit& CDomainQ_Base::C_E::C_LU::GetLowlimit(void) const
{
    if ( !m_Lowlimit ) {
        const_cast<C_LU*>(this)->ResetLowlimit();
    }
    return (*m_Lowlimit);
}

inline
CDomainQ_Base::C_E::C_LU::TLowlimit& CDomainQ_Base::C_E::C_LU::SetLowlimit(void)
{
    if ( !m_Lowlimit ) {
        ResetLowlimit();
    }
    return (*m_Lowlimit);
}

inline
bool CDomainQ_Base::C_E::C_LU::IsSetUplimit(void) const
{
    return m_Uplimit.NotEmpty();
}

inline
bool CDomainQ_Base::C_E::C_LU::CanGetUplimit(void) const
{
    return IsSetUplimit();
}

inline
const CDomainQ_Base::C_E::C_LU::TUplimit& CDomainQ_Base::C_E::C_LU::GetUplimit(void) const
{
    if (!CanGetUplimit()) {
        ThrowUnassigned(1);
    }
    return (*m_Uplimit);
}

inline
CDomainQ_Base::C_E::E_Choice CDomainQ_Base::C_E::Which(void) const
{
    return m_choice;
}

inline
void CDomainQ_Base::C_E::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CDomainQ_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CDomainQ_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CDomainQ_Base::C_E::IsDomainofapplication(void) const
{
    return m_choice == e_Domainofapplication;
}

inline
bool CDomainQ_Base::C_E::IsCondition(void) const
{
    return m_choice == e_Condition;
}

inline
bool CDomainQ_Base::C_E::IsLU(void) const
{
    return m_choice == e_LU;
}

inline
bool CDomainQ_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDomainQ_Base::CanGet(void) const
{
    return true;
}

inline
const CDomainQ_Base::Tdata& CDomainQ_Base::Get(void) const
{
    return m_data;
}

inline
CDomainQ_Base::Tdata& CDomainQ_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CDomainQ_Base::operator const CDomainQ_Base::Tdata& (void) const
{
    return m_data;
}

inline
CDomainQ_Base::operator CDomainQ_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DOMAINQ_BASE_HPP
