/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GrantList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_GRANTLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_GRANTLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CGrant;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGrantList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CGrantList_Base(void);
    // destructor
    virtual ~CGrantList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_CompleteYN {
            eAttlist_CompleteYN_Y = 1,
            eAttlist_CompleteYN_N = 2
        };
        
        /// Access to EAttlist_CompleteYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_CompleteYN)(void);
        
        // types
        typedef EAttlist_CompleteYN TCompleteYN;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_CompleteYN
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_CompleteYN_Y
        /// typedef EAttlist_CompleteYN TCompleteYN
        ///  Check whether the CompleteYN data member has been assigned a value.
        bool IsSetCompleteYN(void) const;
        /// Check whether it is safe or not to call GetCompleteYN method.
        bool CanGetCompleteYN(void) const;
        void ResetCompleteYN(void);
        void SetDefaultCompleteYN(void);
        TCompleteYN GetCompleteYN(void) const;
        void SetCompleteYN(TCompleteYN value);
        TCompleteYN& SetCompleteYN(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_CompleteYN m_CompleteYN;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CGrant > > TGrant;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Grant
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CGrant > > TGrant
    ///  Check whether the Grant data member has been assigned a value.
    bool IsSetGrant(void) const;
    /// Check whether it is safe or not to call GetGrant method.
    bool CanGetGrant(void) const;
    void ResetGrant(void);
    const TGrant& GetGrant(void) const;
    TGrant& SetGrant(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGrantList_Base(const CGrantList_Base&);
    CGrantList_Base& operator=(const CGrantList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CGrant > > m_Grant;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGrantList_Base::C_Attlist::IsSetCompleteYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGrantList_Base::C_Attlist::CanGetCompleteYN(void) const
{
    return true;
}

inline
void CGrantList_Base::C_Attlist::ResetCompleteYN(void)
{
    m_CompleteYN = eAttlist_CompleteYN_Y;
    m_set_State[0] &= ~0x3;
}

inline
void CGrantList_Base::C_Attlist::SetDefaultCompleteYN(void)
{
    ResetCompleteYN();
    m_set_State[0] |= 0x1;
}

inline
CGrantList_Base::C_Attlist::TCompleteYN CGrantList_Base::C_Attlist::GetCompleteYN(void) const
{
    return m_CompleteYN;
}

inline
void CGrantList_Base::C_Attlist::SetCompleteYN(CGrantList_Base::C_Attlist::TCompleteYN value)
{
    m_CompleteYN = value;
    m_set_State[0] |= 0x3;
}

inline
CGrantList_Base::C_Attlist::TCompleteYN& CGrantList_Base::C_Attlist::SetCompleteYN(void)
{
#ifdef _DEBUG
    if (!IsSetCompleteYN()) {
        memset(&m_CompleteYN,UnassignedByte(),sizeof(m_CompleteYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_CompleteYN;
}

inline
bool CGrantList_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CGrantList_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CGrantList_Base::TAttlist& CGrantList_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CGrantList_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CGrantList_Base::TAttlist& CGrantList_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CGrantList_Base::IsSetGrant(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGrantList_Base::CanGetGrant(void) const
{
    return true;
}

inline
const CGrantList_Base::TGrant& CGrantList_Base::GetGrant(void) const
{
    return m_Grant;
}

inline
CGrantList_Base::TGrant& CGrantList_Base::SetGrant(void)
{
    m_set_State[0] |= 0x4;
    return m_Grant;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_GRANTLIST_BASE_HPP
