/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Keyword_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_KEYWORD_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_KEYWORD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/Text.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMath;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CKeyword_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CKeyword_Base(void);
    // destructor
    virtual ~CKeyword_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_MajorTopicYN {
            eAttlist_MajorTopicYN_Y = 1,
            eAttlist_MajorTopicYN_N = 2
        };
        
        /// Access to EAttlist_MajorTopicYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_MajorTopicYN)(void);
        
        // types
        typedef EAttlist_MajorTopicYN TMajorTopicYN;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_MajorTopicYN
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_MajorTopicYN_N
        /// typedef EAttlist_MajorTopicYN TMajorTopicYN
        ///  Check whether the MajorTopicYN data member has been assigned a value.
        bool IsSetMajorTopicYN(void) const;
        /// Check whether it is safe or not to call GetMajorTopicYN method.
        bool CanGetMajorTopicYN(void) const;
        void ResetMajorTopicYN(void);
        void SetDefaultMajorTopicYN(void);
        TMajorTopicYN GetMajorTopicYN(void) const;
        void SetMajorTopicYN(TMajorTopicYN value);
        TMajorTopicYN& SetMajorTopicYN(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_MajorTopicYN m_MajorTopicYN;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_Keyword : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_Keyword(void);
        // destructor
        ~C_E_Keyword(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        typedef CText C_Text;
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e__CharData,
            e_Text,
            e_Math
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Math+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef C_Text TText;
        typedef CMath TMath;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef C_Text TText
        bool IsText(void) const;
        const TText& GetText(void) const;
        TText& SetText(void);
        void SetText(TText& value);
    
        // typedef CMath TMath
        bool IsMath(void) const;
        const TMath& GetMath(void) const;
        TMath& SetMath(void);
        void SetMath(TMath& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_Keyword(const C_E_Keyword& );
        C_E_Keyword& operator=(const C_E_Keyword& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_Keyword C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Keyword > > TKeyword;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Keyword
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Keyword > > TKeyword
    ///  Check whether the Keyword data member has been assigned a value.
    bool IsSetKeyword(void) const;
    /// Check whether it is safe or not to call GetKeyword method.
    bool CanGetKeyword(void) const;
    void ResetKeyword(void);
    const TKeyword& GetKeyword(void) const;
    TKeyword& SetKeyword(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CKeyword_Base(const CKeyword_Base&);
    CKeyword_Base& operator=(const CKeyword_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Keyword > > m_Keyword;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CKeyword_Base::C_Attlist::IsSetMajorTopicYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CKeyword_Base::C_Attlist::CanGetMajorTopicYN(void) const
{
    return true;
}

inline
void CKeyword_Base::C_Attlist::ResetMajorTopicYN(void)
{
    m_MajorTopicYN = eAttlist_MajorTopicYN_N;
    m_set_State[0] &= ~0x3;
}

inline
void CKeyword_Base::C_Attlist::SetDefaultMajorTopicYN(void)
{
    ResetMajorTopicYN();
    m_set_State[0] |= 0x1;
}

inline
CKeyword_Base::C_Attlist::TMajorTopicYN CKeyword_Base::C_Attlist::GetMajorTopicYN(void) const
{
    return m_MajorTopicYN;
}

inline
void CKeyword_Base::C_Attlist::SetMajorTopicYN(CKeyword_Base::C_Attlist::TMajorTopicYN value)
{
    m_MajorTopicYN = value;
    m_set_State[0] |= 0x3;
}

inline
CKeyword_Base::C_Attlist::TMajorTopicYN& CKeyword_Base::C_Attlist::SetMajorTopicYN(void)
{
#ifdef _DEBUG
    if (!IsSetMajorTopicYN()) {
        memset(&m_MajorTopicYN,UnassignedByte(),sizeof(m_MajorTopicYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_MajorTopicYN;
}

inline
CKeyword_Base::C_E_Keyword::E_Choice CKeyword_Base::C_E_Keyword::Which(void) const
{
    return m_choice;
}

inline
void CKeyword_Base::C_E_Keyword::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CKeyword_Base::C_E_Keyword::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CKeyword_Base::C_E_Keyword::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CKeyword_Base::C_E_Keyword::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CKeyword_Base::C_E_Keyword::T_CharData& CKeyword_Base::C_E_Keyword::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CKeyword_Base::C_E_Keyword::T_CharData& CKeyword_Base::C_E_Keyword::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CKeyword_Base::C_E_Keyword::IsText(void) const
{
    return m_choice == e_Text;
}

inline
bool CKeyword_Base::C_E_Keyword::IsMath(void) const
{
    return m_choice == e_Math;
}

inline
bool CKeyword_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CKeyword_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CKeyword_Base::TAttlist& CKeyword_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CKeyword_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CKeyword_Base::TAttlist& CKeyword_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CKeyword_Base::IsSetKeyword(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CKeyword_Base::CanGetKeyword(void) const
{
    return true;
}

inline
const CKeyword_Base::TKeyword& CKeyword_Base::GetKeyword(void) const
{
    return m_Keyword;
}

inline
CKeyword_Base::TKeyword& CKeyword_Base::SetKeyword(void)
{
    m_set_State[0] |= 0x4;
    return m_Keyword;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_KEYWORD_BASE_HPP
