/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MedlineCitation_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MEDLINECITATION_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MEDLINECITATION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CArticle;
class CChemicalList;
class CCitationSubset;
class CCoiStatement;
class CCommentsCorrectionsList;
class CDateCompleted;
class CDateRevised;
class CGeneSymbolList;
class CGeneralNote;
class CInvestigatorList;
class CKeywordList;
class CMedlineJournalInfo;
class CMeshHeadingList;
class CNumberOfReferences;
class COtherAbstract;
class COtherID;
class CPMID;
class CPersonalNameSubjectList;
class CSpaceFlightMission;
class CSupplMeshList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///   =============== Sub-Document wrapper elements ===================== 
class CMedlineCitation_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMedlineCitation_Base(void);
    // destructor
    virtual ~CMedlineCitation_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Owner {
            eAttlist_Owner_NLM    = 1,
            eAttlist_Owner_NASA   = 2,
            eAttlist_Owner_PIP    = 3,
            eAttlist_Owner_KIE    = 4,
            eAttlist_Owner_HSR    = 5,
            eAttlist_Owner_HMD    = 6,
            eAttlist_Owner_NOTNLM = 7
        };
        
        /// Access to EAttlist_Owner's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Owner)(void);
        
        enum EAttlist_Status {
            eAttlist_Status_Completed          = 1,
            eAttlist_Status_In_Process         = 2,
            eAttlist_Status_PubMed_not_MEDLINE = 3,
            eAttlist_Status_In_Data_Review     = 4,
            eAttlist_Status_Publisher          = 5,
            eAttlist_Status_MEDLINE            = 6,
            eAttlist_Status_OLDMEDLINE         = 7
        };
        
        /// Access to EAttlist_Status's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Status)(void);
        
        // types
        typedef EAttlist_Owner TOwner;
        typedef EAttlist_Status TStatus;
        typedef NCBI_NS_STD::string TVersionID;
        typedef NCBI_NS_STD::string TVersionDate;
        typedef NCBI_NS_STD::string TIndexingMethod;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Owner,
            e_Status,
            e_VersionID,
            e_VersionDate,
            e_IndexingMethod
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_Owner_NLM
        /// typedef EAttlist_Owner TOwner
        ///  Check whether the Owner data member has been assigned a value.
        bool IsSetOwner(void) const;
        /// Check whether it is safe or not to call GetOwner method.
        bool CanGetOwner(void) const;
        void ResetOwner(void);
        void SetDefaultOwner(void);
        TOwner GetOwner(void) const;
        void SetOwner(TOwner value);
        TOwner& SetOwner(void);
    
        /// mandatory
        /// typedef EAttlist_Status TStatus
        ///  Check whether the Status data member has been assigned a value.
        bool IsSetStatus(void) const;
        /// Check whether it is safe or not to call GetStatus method.
        bool CanGetStatus(void) const;
        void ResetStatus(void);
        TStatus GetStatus(void) const;
        void SetStatus(TStatus value);
        TStatus& SetStatus(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TVersionID
        ///  Check whether the VersionID data member has been assigned a value.
        bool IsSetVersionID(void) const;
        /// Check whether it is safe or not to call GetVersionID method.
        bool CanGetVersionID(void) const;
        void ResetVersionID(void);
        const TVersionID& GetVersionID(void) const;
        void SetVersionID(const TVersionID& value);
        void SetVersionID(TVersionID&& value);
        TVersionID& SetVersionID(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TVersionDate
        ///  Check whether the VersionDate data member has been assigned a value.
        bool IsSetVersionDate(void) const;
        /// Check whether it is safe or not to call GetVersionDate method.
        bool CanGetVersionDate(void) const;
        void ResetVersionDate(void);
        const TVersionDate& GetVersionDate(void) const;
        void SetVersionDate(const TVersionDate& value);
        void SetVersionDate(TVersionDate&& value);
        TVersionDate& SetVersionDate(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndexingMethod
        ///  Check whether the IndexingMethod data member has been assigned a value.
        bool IsSetIndexingMethod(void) const;
        /// Check whether it is safe or not to call GetIndexingMethod method.
        bool CanGetIndexingMethod(void) const;
        void ResetIndexingMethod(void);
        const TIndexingMethod& GetIndexingMethod(void) const;
        void SetIndexingMethod(const TIndexingMethod& value);
        void SetIndexingMethod(TIndexingMethod&& value);
        TIndexingMethod& SetIndexingMethod(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_Owner m_Owner;
        EAttlist_Status m_Status;
        NCBI_NS_STD::string m_VersionID;
        NCBI_NS_STD::string m_VersionDate;
        NCBI_NS_STD::string m_IndexingMethod;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CPMID TPMID;
    typedef CDateCompleted TDateCompleted;
    typedef CDateRevised TDateRevised;
    typedef CArticle TArticle;
    typedef CMedlineJournalInfo TMedlineJournalInfo;
    typedef CChemicalList TChemicalList;
    typedef CSupplMeshList TSupplMeshList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CCitationSubset > > TCitationSubset;
    typedef CCommentsCorrectionsList TCommentsCorrectionsList;
    typedef CGeneSymbolList TGeneSymbolList;
    typedef CMeshHeadingList TMeshHeadingList;
    typedef CNumberOfReferences TNumberOfReferences;
    typedef CPersonalNameSubjectList TPersonalNameSubjectList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< COtherID > > TOtherID;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< COtherAbstract > > TOtherAbstract;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeywordList > > TKeywordList;
    typedef CCoiStatement TCoiStatement;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSpaceFlightMission > > TSpaceFlightMission;
    typedef CInvestigatorList TInvestigatorList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CGeneralNote > > TGeneralNote;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_PMID,
        e_DateCompleted,
        e_DateRevised,
        e_Article,
        e_MedlineJournalInfo,
        e_ChemicalList,
        e_SupplMeshList,
        e_CitationSubset,
        e_CommentsCorrectionsList,
        e_GeneSymbolList,
        e_MeshHeadingList,
        e_NumberOfReferences,
        e_PersonalNameSubjectList,
        e_OtherID,
        e_OtherAbstract,
        e_KeywordList,
        e_CoiStatement,
        e_SpaceFlightMission,
        e_InvestigatorList,
        e_GeneralNote
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 22> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CPMID TPMID
    ///  Check whether the PMID data member has been assigned a value.
    bool IsSetPMID(void) const;
    /// Check whether it is safe or not to call GetPMID method.
    bool CanGetPMID(void) const;
    void ResetPMID(void);
    const TPMID& GetPMID(void) const;
    void SetPMID(TPMID& value);
    TPMID& SetPMID(void);
    void SetPMID(const NCBI_NS_STD::string& value);

    /// optional
    /// typedef CDateCompleted TDateCompleted
    ///  Check whether the DateCompleted data member has been assigned a value.
    bool IsSetDateCompleted(void) const;
    /// Check whether it is safe or not to call GetDateCompleted method.
    bool CanGetDateCompleted(void) const;
    void ResetDateCompleted(void);
    const TDateCompleted& GetDateCompleted(void) const;
    void SetDateCompleted(TDateCompleted& value);
    TDateCompleted& SetDateCompleted(void);

    /// optional
    /// typedef CDateRevised TDateRevised
    ///  Check whether the DateRevised data member has been assigned a value.
    bool IsSetDateRevised(void) const;
    /// Check whether it is safe or not to call GetDateRevised method.
    bool CanGetDateRevised(void) const;
    void ResetDateRevised(void);
    const TDateRevised& GetDateRevised(void) const;
    void SetDateRevised(TDateRevised& value);
    TDateRevised& SetDateRevised(void);

    /// mandatory
    /// typedef CArticle TArticle
    ///  Check whether the Article data member has been assigned a value.
    bool IsSetArticle(void) const;
    /// Check whether it is safe or not to call GetArticle method.
    bool CanGetArticle(void) const;
    void ResetArticle(void);
    const TArticle& GetArticle(void) const;
    void SetArticle(TArticle& value);
    TArticle& SetArticle(void);

    /// mandatory
    /// typedef CMedlineJournalInfo TMedlineJournalInfo
    ///  Check whether the MedlineJournalInfo data member has been assigned a value.
    bool IsSetMedlineJournalInfo(void) const;
    /// Check whether it is safe or not to call GetMedlineJournalInfo method.
    bool CanGetMedlineJournalInfo(void) const;
    void ResetMedlineJournalInfo(void);
    const TMedlineJournalInfo& GetMedlineJournalInfo(void) const;
    void SetMedlineJournalInfo(TMedlineJournalInfo& value);
    TMedlineJournalInfo& SetMedlineJournalInfo(void);

    /// optional
    /// typedef CChemicalList TChemicalList
    ///  Check whether the ChemicalList data member has been assigned a value.
    bool IsSetChemicalList(void) const;
    /// Check whether it is safe or not to call GetChemicalList method.
    bool CanGetChemicalList(void) const;
    void ResetChemicalList(void);
    const TChemicalList& GetChemicalList(void) const;
    void SetChemicalList(TChemicalList& value);
    TChemicalList& SetChemicalList(void);

    /// optional
    /// typedef CSupplMeshList TSupplMeshList
    ///  Check whether the SupplMeshList data member has been assigned a value.
    bool IsSetSupplMeshList(void) const;
    /// Check whether it is safe or not to call GetSupplMeshList method.
    bool CanGetSupplMeshList(void) const;
    void ResetSupplMeshList(void);
    const TSupplMeshList& GetSupplMeshList(void) const;
    void SetSupplMeshList(TSupplMeshList& value);
    TSupplMeshList& SetSupplMeshList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CCitationSubset > > TCitationSubset
    ///  Check whether the CitationSubset data member has been assigned a value.
    bool IsSetCitationSubset(void) const;
    /// Check whether it is safe or not to call GetCitationSubset method.
    bool CanGetCitationSubset(void) const;
    void ResetCitationSubset(void);
    const TCitationSubset& GetCitationSubset(void) const;
    TCitationSubset& SetCitationSubset(void);

    /// optional
    /// typedef CCommentsCorrectionsList TCommentsCorrectionsList
    ///  Check whether the CommentsCorrectionsList data member has been assigned a value.
    bool IsSetCommentsCorrectionsList(void) const;
    /// Check whether it is safe or not to call GetCommentsCorrectionsList method.
    bool CanGetCommentsCorrectionsList(void) const;
    void ResetCommentsCorrectionsList(void);
    const TCommentsCorrectionsList& GetCommentsCorrectionsList(void) const;
    void SetCommentsCorrectionsList(TCommentsCorrectionsList& value);
    TCommentsCorrectionsList& SetCommentsCorrectionsList(void);

    /// optional
    /// typedef CGeneSymbolList TGeneSymbolList
    ///  Check whether the GeneSymbolList data member has been assigned a value.
    bool IsSetGeneSymbolList(void) const;
    /// Check whether it is safe or not to call GetGeneSymbolList method.
    bool CanGetGeneSymbolList(void) const;
    void ResetGeneSymbolList(void);
    const TGeneSymbolList& GetGeneSymbolList(void) const;
    void SetGeneSymbolList(TGeneSymbolList& value);
    TGeneSymbolList& SetGeneSymbolList(void);

    /// optional
    /// typedef CMeshHeadingList TMeshHeadingList
    ///  Check whether the MeshHeadingList data member has been assigned a value.
    bool IsSetMeshHeadingList(void) const;
    /// Check whether it is safe or not to call GetMeshHeadingList method.
    bool CanGetMeshHeadingList(void) const;
    void ResetMeshHeadingList(void);
    const TMeshHeadingList& GetMeshHeadingList(void) const;
    void SetMeshHeadingList(TMeshHeadingList& value);
    TMeshHeadingList& SetMeshHeadingList(void);

    /// optional
    /// typedef CNumberOfReferences TNumberOfReferences
    ///  Check whether the NumberOfReferences data member has been assigned a value.
    bool IsSetNumberOfReferences(void) const;
    /// Check whether it is safe or not to call GetNumberOfReferences method.
    bool CanGetNumberOfReferences(void) const;
    void ResetNumberOfReferences(void);
    const TNumberOfReferences& GetNumberOfReferences(void) const;
    void SetNumberOfReferences(TNumberOfReferences& value);
    TNumberOfReferences& SetNumberOfReferences(void);

    /// optional
    /// typedef CPersonalNameSubjectList TPersonalNameSubjectList
    ///  Check whether the PersonalNameSubjectList data member has been assigned a value.
    bool IsSetPersonalNameSubjectList(void) const;
    /// Check whether it is safe or not to call GetPersonalNameSubjectList method.
    bool CanGetPersonalNameSubjectList(void) const;
    void ResetPersonalNameSubjectList(void);
    const TPersonalNameSubjectList& GetPersonalNameSubjectList(void) const;
    void SetPersonalNameSubjectList(TPersonalNameSubjectList& value);
    TPersonalNameSubjectList& SetPersonalNameSubjectList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< COtherID > > TOtherID
    ///  Check whether the OtherID data member has been assigned a value.
    bool IsSetOtherID(void) const;
    /// Check whether it is safe or not to call GetOtherID method.
    bool CanGetOtherID(void) const;
    void ResetOtherID(void);
    const TOtherID& GetOtherID(void) const;
    TOtherID& SetOtherID(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< COtherAbstract > > TOtherAbstract
    ///  Check whether the OtherAbstract data member has been assigned a value.
    bool IsSetOtherAbstract(void) const;
    /// Check whether it is safe or not to call GetOtherAbstract method.
    bool CanGetOtherAbstract(void) const;
    void ResetOtherAbstract(void);
    const TOtherAbstract& GetOtherAbstract(void) const;
    TOtherAbstract& SetOtherAbstract(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeywordList > > TKeywordList
    ///  Check whether the KeywordList data member has been assigned a value.
    bool IsSetKeywordList(void) const;
    /// Check whether it is safe or not to call GetKeywordList method.
    bool CanGetKeywordList(void) const;
    void ResetKeywordList(void);
    const TKeywordList& GetKeywordList(void) const;
    TKeywordList& SetKeywordList(void);

    /// optional
    /// typedef CCoiStatement TCoiStatement
    ///  Check whether the CoiStatement data member has been assigned a value.
    bool IsSetCoiStatement(void) const;
    /// Check whether it is safe or not to call GetCoiStatement method.
    bool CanGetCoiStatement(void) const;
    void ResetCoiStatement(void);
    const TCoiStatement& GetCoiStatement(void) const;
    void SetCoiStatement(TCoiStatement& value);
    TCoiStatement& SetCoiStatement(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSpaceFlightMission > > TSpaceFlightMission
    ///  Check whether the SpaceFlightMission data member has been assigned a value.
    bool IsSetSpaceFlightMission(void) const;
    /// Check whether it is safe or not to call GetSpaceFlightMission method.
    bool CanGetSpaceFlightMission(void) const;
    void ResetSpaceFlightMission(void);
    const TSpaceFlightMission& GetSpaceFlightMission(void) const;
    TSpaceFlightMission& SetSpaceFlightMission(void);

    /// optional
    /// typedef CInvestigatorList TInvestigatorList
    ///  Check whether the InvestigatorList data member has been assigned a value.
    bool IsSetInvestigatorList(void) const;
    /// Check whether it is safe or not to call GetInvestigatorList method.
    bool CanGetInvestigatorList(void) const;
    void ResetInvestigatorList(void);
    const TInvestigatorList& GetInvestigatorList(void) const;
    void SetInvestigatorList(TInvestigatorList& value);
    TInvestigatorList& SetInvestigatorList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CGeneralNote > > TGeneralNote
    ///  Check whether the GeneralNote data member has been assigned a value.
    bool IsSetGeneralNote(void) const;
    /// Check whether it is safe or not to call GetGeneralNote method.
    bool CanGetGeneralNote(void) const;
    void ResetGeneralNote(void);
    const TGeneralNote& GetGeneralNote(void) const;
    TGeneralNote& SetGeneralNote(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMedlineCitation_Base(const CMedlineCitation_Base&);
    CMedlineCitation_Base& operator=(const CMedlineCitation_Base&);

    // data
    Uint4 m_set_State[2];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TPMID > m_PMID;
    NCBI_NS_NCBI::CRef< TDateCompleted > m_DateCompleted;
    NCBI_NS_NCBI::CRef< TDateRevised > m_DateRevised;
    NCBI_NS_NCBI::CRef< TArticle > m_Article;
    NCBI_NS_NCBI::CRef< TMedlineJournalInfo > m_MedlineJournalInfo;
    NCBI_NS_NCBI::CRef< TChemicalList > m_ChemicalList;
    NCBI_NS_NCBI::CRef< TSupplMeshList > m_SupplMeshList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CCitationSubset > > m_CitationSubset;
    NCBI_NS_NCBI::CRef< TCommentsCorrectionsList > m_CommentsCorrectionsList;
    NCBI_NS_NCBI::CRef< TGeneSymbolList > m_GeneSymbolList;
    NCBI_NS_NCBI::CRef< TMeshHeadingList > m_MeshHeadingList;
    NCBI_NS_NCBI::CRef< TNumberOfReferences > m_NumberOfReferences;
    NCBI_NS_NCBI::CRef< TPersonalNameSubjectList > m_PersonalNameSubjectList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< COtherID > > m_OtherID;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< COtherAbstract > > m_OtherAbstract;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CKeywordList > > m_KeywordList;
    NCBI_NS_NCBI::CRef< TCoiStatement > m_CoiStatement;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSpaceFlightMission > > m_SpaceFlightMission;
    NCBI_NS_NCBI::CRef< TInvestigatorList > m_InvestigatorList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CGeneralNote > > m_GeneralNote;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMedlineCitation_Base::C_Attlist::IsSetOwner(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMedlineCitation_Base::C_Attlist::CanGetOwner(void) const
{
    return true;
}

inline
void CMedlineCitation_Base::C_Attlist::ResetOwner(void)
{
    m_Owner = eAttlist_Owner_NLM;
    m_set_State[0] &= ~0x3;
}

inline
void CMedlineCitation_Base::C_Attlist::SetDefaultOwner(void)
{
    ResetOwner();
    m_set_State[0] |= 0x1;
}

inline
CMedlineCitation_Base::C_Attlist::TOwner CMedlineCitation_Base::C_Attlist::GetOwner(void) const
{
    return m_Owner;
}

inline
void CMedlineCitation_Base::C_Attlist::SetOwner(CMedlineCitation_Base::C_Attlist::TOwner value)
{
    m_Owner = value;
    m_set_State[0] |= 0x3;
}

inline
CMedlineCitation_Base::C_Attlist::TOwner& CMedlineCitation_Base::C_Attlist::SetOwner(void)
{
#ifdef _DEBUG
    if (!IsSetOwner()) {
        memset(&m_Owner,UnassignedByte(),sizeof(m_Owner));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Owner;
}

inline
bool CMedlineCitation_Base::C_Attlist::IsSetStatus(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMedlineCitation_Base::C_Attlist::CanGetStatus(void) const
{
    return IsSetStatus();
}

inline
void CMedlineCitation_Base::C_Attlist::ResetStatus(void)
{
    m_Status = (EAttlist_Status)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMedlineCitation_Base::C_Attlist::TStatus CMedlineCitation_Base::C_Attlist::GetStatus(void) const
{
    if (!CanGetStatus()) {
        ThrowUnassigned(1);
    }
    return m_Status;
}

inline
void CMedlineCitation_Base::C_Attlist::SetStatus(CMedlineCitation_Base::C_Attlist::TStatus value)
{
    m_Status = value;
    m_set_State[0] |= 0xc;
}

inline
CMedlineCitation_Base::C_Attlist::TStatus& CMedlineCitation_Base::C_Attlist::SetStatus(void)
{
#ifdef _DEBUG
    if (!IsSetStatus()) {
        memset(&m_Status,UnassignedByte(),sizeof(m_Status));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Status;
}

inline
bool CMedlineCitation_Base::C_Attlist::IsSetVersionID(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMedlineCitation_Base::C_Attlist::CanGetVersionID(void) const
{
    return IsSetVersionID();
}

inline
const CMedlineCitation_Base::C_Attlist::TVersionID& CMedlineCitation_Base::C_Attlist::GetVersionID(void) const
{
    if (!CanGetVersionID()) {
        ThrowUnassigned(2);
    }
    return m_VersionID;
}

inline
void CMedlineCitation_Base::C_Attlist::SetVersionID(const CMedlineCitation_Base::C_Attlist::TVersionID& value)
{
    m_VersionID = value;
    m_set_State[0] |= 0x30;
}

inline
void CMedlineCitation_Base::C_Attlist::SetVersionID(CMedlineCitation_Base::C_Attlist::TVersionID&& value)
{
    m_VersionID = std::forward<CMedlineCitation_Base::C_Attlist::TVersionID>(value);
    m_set_State[0] |= 0x30;
}

inline
CMedlineCitation_Base::C_Attlist::TVersionID& CMedlineCitation_Base::C_Attlist::SetVersionID(void)
{
#ifdef _DEBUG
    if (!IsSetVersionID()) {
        m_VersionID = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_VersionID;
}

inline
bool CMedlineCitation_Base::C_Attlist::IsSetVersionDate(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMedlineCitation_Base::C_Attlist::CanGetVersionDate(void) const
{
    return IsSetVersionDate();
}

inline
const CMedlineCitation_Base::C_Attlist::TVersionDate& CMedlineCitation_Base::C_Attlist::GetVersionDate(void) const
{
    if (!CanGetVersionDate()) {
        ThrowUnassigned(3);
    }
    return m_VersionDate;
}

inline
void CMedlineCitation_Base::C_Attlist::SetVersionDate(const CMedlineCitation_Base::C_Attlist::TVersionDate& value)
{
    m_VersionDate = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMedlineCitation_Base::C_Attlist::SetVersionDate(CMedlineCitation_Base::C_Attlist::TVersionDate&& value)
{
    m_VersionDate = std::forward<CMedlineCitation_Base::C_Attlist::TVersionDate>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMedlineCitation_Base::C_Attlist::TVersionDate& CMedlineCitation_Base::C_Attlist::SetVersionDate(void)
{
#ifdef _DEBUG
    if (!IsSetVersionDate()) {
        m_VersionDate = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_VersionDate;
}

inline
bool CMedlineCitation_Base::C_Attlist::IsSetIndexingMethod(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMedlineCitation_Base::C_Attlist::CanGetIndexingMethod(void) const
{
    return IsSetIndexingMethod();
}

inline
const CMedlineCitation_Base::C_Attlist::TIndexingMethod& CMedlineCitation_Base::C_Attlist::GetIndexingMethod(void) const
{
    if (!CanGetIndexingMethod()) {
        ThrowUnassigned(4);
    }
    return m_IndexingMethod;
}

inline
void CMedlineCitation_Base::C_Attlist::SetIndexingMethod(const CMedlineCitation_Base::C_Attlist::TIndexingMethod& value)
{
    m_IndexingMethod = value;
    m_set_State[0] |= 0x300;
}

inline
void CMedlineCitation_Base::C_Attlist::SetIndexingMethod(CMedlineCitation_Base::C_Attlist::TIndexingMethod&& value)
{
    m_IndexingMethod = std::forward<CMedlineCitation_Base::C_Attlist::TIndexingMethod>(value);
    m_set_State[0] |= 0x300;
}

inline
CMedlineCitation_Base::C_Attlist::TIndexingMethod& CMedlineCitation_Base::C_Attlist::SetIndexingMethod(void)
{
#ifdef _DEBUG
    if (!IsSetIndexingMethod()) {
        m_IndexingMethod = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_IndexingMethod;
}

inline
bool CMedlineCitation_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TAttlist& CMedlineCitation_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMedlineCitation_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMedlineCitation_Base::TAttlist& CMedlineCitation_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMedlineCitation_Base::IsSetPMID(void) const
{
    return m_PMID.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetPMID(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TPMID& CMedlineCitation_Base::GetPMID(void) const
{
    if ( !m_PMID ) {
        const_cast<CMedlineCitation_Base*>(this)->ResetPMID();
    }
    return (*m_PMID);
}

inline
CMedlineCitation_Base::TPMID& CMedlineCitation_Base::SetPMID(void)
{
    if ( !m_PMID ) {
        ResetPMID();
    }
    return (*m_PMID);
}

inline
bool CMedlineCitation_Base::IsSetDateCompleted(void) const
{
    return m_DateCompleted.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetDateCompleted(void) const
{
    return IsSetDateCompleted();
}

inline
const CMedlineCitation_Base::TDateCompleted& CMedlineCitation_Base::GetDateCompleted(void) const
{
    if (!CanGetDateCompleted()) {
        ThrowUnassigned(2);
    }
    return (*m_DateCompleted);
}

inline
bool CMedlineCitation_Base::IsSetDateRevised(void) const
{
    return m_DateRevised.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetDateRevised(void) const
{
    return IsSetDateRevised();
}

inline
const CMedlineCitation_Base::TDateRevised& CMedlineCitation_Base::GetDateRevised(void) const
{
    if (!CanGetDateRevised()) {
        ThrowUnassigned(3);
    }
    return (*m_DateRevised);
}

inline
bool CMedlineCitation_Base::IsSetArticle(void) const
{
    return m_Article.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetArticle(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TArticle& CMedlineCitation_Base::GetArticle(void) const
{
    if ( !m_Article ) {
        const_cast<CMedlineCitation_Base*>(this)->ResetArticle();
    }
    return (*m_Article);
}

inline
CMedlineCitation_Base::TArticle& CMedlineCitation_Base::SetArticle(void)
{
    if ( !m_Article ) {
        ResetArticle();
    }
    return (*m_Article);
}

inline
bool CMedlineCitation_Base::IsSetMedlineJournalInfo(void) const
{
    return m_MedlineJournalInfo.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetMedlineJournalInfo(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TMedlineJournalInfo& CMedlineCitation_Base::GetMedlineJournalInfo(void) const
{
    if ( !m_MedlineJournalInfo ) {
        const_cast<CMedlineCitation_Base*>(this)->ResetMedlineJournalInfo();
    }
    return (*m_MedlineJournalInfo);
}

inline
CMedlineCitation_Base::TMedlineJournalInfo& CMedlineCitation_Base::SetMedlineJournalInfo(void)
{
    if ( !m_MedlineJournalInfo ) {
        ResetMedlineJournalInfo();
    }
    return (*m_MedlineJournalInfo);
}

inline
bool CMedlineCitation_Base::IsSetChemicalList(void) const
{
    return m_ChemicalList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetChemicalList(void) const
{
    return IsSetChemicalList();
}

inline
const CMedlineCitation_Base::TChemicalList& CMedlineCitation_Base::GetChemicalList(void) const
{
    if (!CanGetChemicalList()) {
        ThrowUnassigned(6);
    }
    return (*m_ChemicalList);
}

inline
bool CMedlineCitation_Base::IsSetSupplMeshList(void) const
{
    return m_SupplMeshList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetSupplMeshList(void) const
{
    return IsSetSupplMeshList();
}

inline
const CMedlineCitation_Base::TSupplMeshList& CMedlineCitation_Base::GetSupplMeshList(void) const
{
    if (!CanGetSupplMeshList()) {
        ThrowUnassigned(7);
    }
    return (*m_SupplMeshList);
}

inline
bool CMedlineCitation_Base::IsSetCitationSubset(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMedlineCitation_Base::CanGetCitationSubset(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TCitationSubset& CMedlineCitation_Base::GetCitationSubset(void) const
{
    return m_CitationSubset;
}

inline
CMedlineCitation_Base::TCitationSubset& CMedlineCitation_Base::SetCitationSubset(void)
{
    m_set_State[0] |= 0x10000;
    return m_CitationSubset;
}

inline
bool CMedlineCitation_Base::IsSetCommentsCorrectionsList(void) const
{
    return m_CommentsCorrectionsList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetCommentsCorrectionsList(void) const
{
    return IsSetCommentsCorrectionsList();
}

inline
const CMedlineCitation_Base::TCommentsCorrectionsList& CMedlineCitation_Base::GetCommentsCorrectionsList(void) const
{
    if (!CanGetCommentsCorrectionsList()) {
        ThrowUnassigned(9);
    }
    return (*m_CommentsCorrectionsList);
}

inline
bool CMedlineCitation_Base::IsSetGeneSymbolList(void) const
{
    return m_GeneSymbolList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetGeneSymbolList(void) const
{
    return IsSetGeneSymbolList();
}

inline
const CMedlineCitation_Base::TGeneSymbolList& CMedlineCitation_Base::GetGeneSymbolList(void) const
{
    if (!CanGetGeneSymbolList()) {
        ThrowUnassigned(10);
    }
    return (*m_GeneSymbolList);
}

inline
bool CMedlineCitation_Base::IsSetMeshHeadingList(void) const
{
    return m_MeshHeadingList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetMeshHeadingList(void) const
{
    return IsSetMeshHeadingList();
}

inline
const CMedlineCitation_Base::TMeshHeadingList& CMedlineCitation_Base::GetMeshHeadingList(void) const
{
    if (!CanGetMeshHeadingList()) {
        ThrowUnassigned(11);
    }
    return (*m_MeshHeadingList);
}

inline
bool CMedlineCitation_Base::IsSetNumberOfReferences(void) const
{
    return m_NumberOfReferences.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetNumberOfReferences(void) const
{
    return IsSetNumberOfReferences();
}

inline
const CMedlineCitation_Base::TNumberOfReferences& CMedlineCitation_Base::GetNumberOfReferences(void) const
{
    if (!CanGetNumberOfReferences()) {
        ThrowUnassigned(12);
    }
    return (*m_NumberOfReferences);
}

inline
bool CMedlineCitation_Base::IsSetPersonalNameSubjectList(void) const
{
    return m_PersonalNameSubjectList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetPersonalNameSubjectList(void) const
{
    return IsSetPersonalNameSubjectList();
}

inline
const CMedlineCitation_Base::TPersonalNameSubjectList& CMedlineCitation_Base::GetPersonalNameSubjectList(void) const
{
    if (!CanGetPersonalNameSubjectList()) {
        ThrowUnassigned(13);
    }
    return (*m_PersonalNameSubjectList);
}

inline
bool CMedlineCitation_Base::IsSetOtherID(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMedlineCitation_Base::CanGetOtherID(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TOtherID& CMedlineCitation_Base::GetOtherID(void) const
{
    return m_OtherID;
}

inline
CMedlineCitation_Base::TOtherID& CMedlineCitation_Base::SetOtherID(void)
{
    m_set_State[0] |= 0x10000000;
    return m_OtherID;
}

inline
bool CMedlineCitation_Base::IsSetOtherAbstract(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMedlineCitation_Base::CanGetOtherAbstract(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TOtherAbstract& CMedlineCitation_Base::GetOtherAbstract(void) const
{
    return m_OtherAbstract;
}

inline
CMedlineCitation_Base::TOtherAbstract& CMedlineCitation_Base::SetOtherAbstract(void)
{
    m_set_State[0] |= 0x40000000;
    return m_OtherAbstract;
}

inline
bool CMedlineCitation_Base::IsSetKeywordList(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMedlineCitation_Base::CanGetKeywordList(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TKeywordList& CMedlineCitation_Base::GetKeywordList(void) const
{
    return m_KeywordList;
}

inline
CMedlineCitation_Base::TKeywordList& CMedlineCitation_Base::SetKeywordList(void)
{
    m_set_State[1] |= 0x1;
    return m_KeywordList;
}

inline
bool CMedlineCitation_Base::IsSetCoiStatement(void) const
{
    return m_CoiStatement.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetCoiStatement(void) const
{
    return IsSetCoiStatement();
}

inline
const CMedlineCitation_Base::TCoiStatement& CMedlineCitation_Base::GetCoiStatement(void) const
{
    if (!CanGetCoiStatement()) {
        ThrowUnassigned(17);
    }
    return (*m_CoiStatement);
}

inline
bool CMedlineCitation_Base::IsSetSpaceFlightMission(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMedlineCitation_Base::CanGetSpaceFlightMission(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TSpaceFlightMission& CMedlineCitation_Base::GetSpaceFlightMission(void) const
{
    return m_SpaceFlightMission;
}

inline
CMedlineCitation_Base::TSpaceFlightMission& CMedlineCitation_Base::SetSpaceFlightMission(void)
{
    m_set_State[1] |= 0x10;
    return m_SpaceFlightMission;
}

inline
bool CMedlineCitation_Base::IsSetInvestigatorList(void) const
{
    return m_InvestigatorList.NotEmpty();
}

inline
bool CMedlineCitation_Base::CanGetInvestigatorList(void) const
{
    return IsSetInvestigatorList();
}

inline
const CMedlineCitation_Base::TInvestigatorList& CMedlineCitation_Base::GetInvestigatorList(void) const
{
    if (!CanGetInvestigatorList()) {
        ThrowUnassigned(19);
    }
    return (*m_InvestigatorList);
}

inline
bool CMedlineCitation_Base::IsSetGeneralNote(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMedlineCitation_Base::CanGetGeneralNote(void) const
{
    return true;
}

inline
const CMedlineCitation_Base::TGeneralNote& CMedlineCitation_Base::GetGeneralNote(void) const
{
    return m_GeneralNote;
}

inline
CMedlineCitation_Base::TGeneralNote& CMedlineCitation_Base::SetGeneralNote(void)
{
    m_set_State[1] |= 0x100;
    return m_GeneralNote;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MEDLINECITATION_BASE_HPP
