/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mfenced_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MFENCED_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MFENCED_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MathExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMfenced_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMfenced_Base(void);
    // destructor
    virtual ~CMfenced_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TOpen;
        typedef NCBI_NS_STD::string TClose;
        typedef NCBI_NS_STD::string TSeparators;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_open,
            e_close,
            e_separators
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TOpen
        ///  Check whether the Open data member has been assigned a value.
        bool IsSetOpen(void) const;
        /// Check whether it is safe or not to call GetOpen method.
        bool CanGetOpen(void) const;
        void ResetOpen(void);
        const TOpen& GetOpen(void) const;
        void SetOpen(const TOpen& value);
        void SetOpen(TOpen&& value);
        TOpen& SetOpen(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClose
        ///  Check whether the Close data member has been assigned a value.
        bool IsSetClose(void) const;
        /// Check whether it is safe or not to call GetClose method.
        bool CanGetClose(void) const;
        void ResetClose(void);
        const TClose& GetClose(void) const;
        void SetClose(const TClose& value);
        void SetClose(TClose&& value);
        TClose& SetClose(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSeparators
        ///  Check whether the Separators data member has been assigned a value.
        bool IsSetSeparators(void) const;
        /// Check whether it is safe or not to call GetSeparators method.
        bool CanGetSeparators(void) const;
        void ResetSeparators(void);
        const TSeparators& GetSeparators(void) const;
        void SetSeparators(const TSeparators& value);
        void SetSeparators(TSeparators&& value);
        TSeparators& SetSeparators(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Open;
        NCBI_NS_STD::string m_Close;
        NCBI_NS_STD::string m_Separators;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_MathExpression : public CMathExpression
    {
        typedef CMathExpression Tparent;
    public:
        C_E_MathExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > TMathExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MathExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > TMathExpression
    ///  Check whether the MathExpression data member has been assigned a value.
    bool IsSetMathExpression(void) const;
    /// Check whether it is safe or not to call GetMathExpression method.
    bool CanGetMathExpression(void) const;
    void ResetMathExpression(void);
    const TMathExpression& GetMathExpression(void) const;
    TMathExpression& SetMathExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMfenced_Base(const CMfenced_Base&);
    CMfenced_Base& operator=(const CMfenced_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > m_MathExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMfenced_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMfenced_Base::C_Attlist::TId& CMfenced_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMfenced_Base::C_Attlist::SetId(const CMfenced_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMfenced_Base::C_Attlist::SetId(CMfenced_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMfenced_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMfenced_Base::C_Attlist::TId& CMfenced_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMfenced_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMfenced_Base::C_Attlist::TXref& CMfenced_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMfenced_Base::C_Attlist::SetXref(const CMfenced_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMfenced_Base::C_Attlist::SetXref(CMfenced_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMfenced_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMfenced_Base::C_Attlist::TXref& CMfenced_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMfenced_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMfenced_Base::C_Attlist::TClass& CMfenced_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMfenced_Base::C_Attlist::SetClass(const CMfenced_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMfenced_Base::C_Attlist::SetClass(CMfenced_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMfenced_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMfenced_Base::C_Attlist::TClass& CMfenced_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMfenced_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMfenced_Base::C_Attlist::TStyle& CMfenced_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMfenced_Base::C_Attlist::SetStyle(const CMfenced_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMfenced_Base::C_Attlist::SetStyle(CMfenced_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMfenced_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMfenced_Base::C_Attlist::TStyle& CMfenced_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMfenced_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMfenced_Base::C_Attlist::THref& CMfenced_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMfenced_Base::C_Attlist::SetHref(const CMfenced_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMfenced_Base::C_Attlist::SetHref(CMfenced_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMfenced_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMfenced_Base::C_Attlist::THref& CMfenced_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMfenced_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMfenced_Base::C_Attlist::TMathcolor& CMfenced_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMfenced_Base::C_Attlist::SetMathcolor(const CMfenced_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMfenced_Base::C_Attlist::SetMathcolor(CMfenced_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMfenced_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMfenced_Base::C_Attlist::TMathcolor& CMfenced_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMfenced_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMfenced_Base::C_Attlist::TMathbackground& CMfenced_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMfenced_Base::C_Attlist::SetMathbackground(const CMfenced_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMfenced_Base::C_Attlist::SetMathbackground(CMfenced_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMfenced_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMfenced_Base::C_Attlist::TMathbackground& CMfenced_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMfenced_Base::C_Attlist::IsSetOpen(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetOpen(void) const
{
    return IsSetOpen();
}

inline
const CMfenced_Base::C_Attlist::TOpen& CMfenced_Base::C_Attlist::GetOpen(void) const
{
    if (!CanGetOpen()) {
        ThrowUnassigned(7);
    }
    return m_Open;
}

inline
void CMfenced_Base::C_Attlist::SetOpen(const CMfenced_Base::C_Attlist::TOpen& value)
{
    m_Open = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMfenced_Base::C_Attlist::SetOpen(CMfenced_Base::C_Attlist::TOpen&& value)
{
    m_Open = std::forward<CMfenced_Base::C_Attlist::TOpen>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMfenced_Base::C_Attlist::TOpen& CMfenced_Base::C_Attlist::SetOpen(void)
{
#ifdef _DEBUG
    if (!IsSetOpen()) {
        m_Open = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Open;
}

inline
bool CMfenced_Base::C_Attlist::IsSetClose(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetClose(void) const
{
    return IsSetClose();
}

inline
const CMfenced_Base::C_Attlist::TClose& CMfenced_Base::C_Attlist::GetClose(void) const
{
    if (!CanGetClose()) {
        ThrowUnassigned(8);
    }
    return m_Close;
}

inline
void CMfenced_Base::C_Attlist::SetClose(const CMfenced_Base::C_Attlist::TClose& value)
{
    m_Close = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMfenced_Base::C_Attlist::SetClose(CMfenced_Base::C_Attlist::TClose&& value)
{
    m_Close = std::forward<CMfenced_Base::C_Attlist::TClose>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMfenced_Base::C_Attlist::TClose& CMfenced_Base::C_Attlist::SetClose(void)
{
#ifdef _DEBUG
    if (!IsSetClose()) {
        m_Close = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Close;
}

inline
bool CMfenced_Base::C_Attlist::IsSetSeparators(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMfenced_Base::C_Attlist::CanGetSeparators(void) const
{
    return IsSetSeparators();
}

inline
const CMfenced_Base::C_Attlist::TSeparators& CMfenced_Base::C_Attlist::GetSeparators(void) const
{
    if (!CanGetSeparators()) {
        ThrowUnassigned(9);
    }
    return m_Separators;
}

inline
void CMfenced_Base::C_Attlist::SetSeparators(const CMfenced_Base::C_Attlist::TSeparators& value)
{
    m_Separators = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMfenced_Base::C_Attlist::SetSeparators(CMfenced_Base::C_Attlist::TSeparators&& value)
{
    m_Separators = std::forward<CMfenced_Base::C_Attlist::TSeparators>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMfenced_Base::C_Attlist::TSeparators& CMfenced_Base::C_Attlist::SetSeparators(void)
{
#ifdef _DEBUG
    if (!IsSetSeparators()) {
        m_Separators = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Separators;
}

inline
CMfenced_Base::C_E_MathExpression::C_E_MathExpression(void)
{
}

inline
bool CMfenced_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMfenced_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMfenced_Base::TAttlist& CMfenced_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMfenced_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMfenced_Base::TAttlist& CMfenced_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMfenced_Base::IsSetMathExpression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMfenced_Base::CanGetMathExpression(void) const
{
    return true;
}

inline
const CMfenced_Base::TMathExpression& CMfenced_Base::GetMathExpression(void) const
{
    return m_MathExpression;
}

inline
CMfenced_Base::TMathExpression& CMfenced_Base::SetMathExpression(void)
{
    m_set_State[0] |= 0x4;
    return m_MathExpression;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MFENCED_BASE_HPP
