/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mspace_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MSPACE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MSPACE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMspace_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMspace_Base(void);
    // destructor
    virtual ~CMspace_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_mathvariant {
            eAttlist_mathvariant_normal                 =  1,
            eAttlist_mathvariant_bold                   =  2,
            eAttlist_mathvariant_italic                 =  3,
            eAttlist_mathvariant_bold_italic            =  4,
            eAttlist_mathvariant_double_struck          =  5,
            eAttlist_mathvariant_bold_fraktur           =  6,
            eAttlist_mathvariant_script                 =  7,
            eAttlist_mathvariant_bold_script            =  8,
            eAttlist_mathvariant_fraktur                =  9,
            eAttlist_mathvariant_sans_serif             = 10,
            eAttlist_mathvariant_bold_sans_serif        = 11,
            eAttlist_mathvariant_sans_serif_italic      = 12,
            eAttlist_mathvariant_sans_serif_bold_italic = 13,
            eAttlist_mathvariant_monospace              = 14,
            eAttlist_mathvariant_initial                = 15,
            eAttlist_mathvariant_tailed                 = 16,
            eAttlist_mathvariant_looped                 = 17,
            eAttlist_mathvariant_stretched              = 18
        };
        
        /// Access to EAttlist_mathvariant's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_mathvariant)(void);
        
        enum EAttlist_dir {
            eAttlist_dir_ltr = 1,
            eAttlist_dir_rtl = 2
        };
        
        /// Access to EAttlist_dir's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_dir)(void);
        
        enum EAttlist_fontweight {
            eAttlist_fontweight_normal = 1,
            eAttlist_fontweight_bold   = 2
        };
        
        /// Access to EAttlist_fontweight's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontweight)(void);
        
        enum EAttlist_fontstyle {
            eAttlist_fontstyle_normal = 1,
            eAttlist_fontstyle_italic = 2
        };
        
        /// Access to EAttlist_fontstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontstyle)(void);
        
        enum EAttlist_linebreak {
            eAttlist_linebreak_auto             = 1,
            eAttlist_linebreak_newline          = 2,
            eAttlist_linebreak_nobreak          = 3,
            eAttlist_linebreak_goodbreak        = 4,
            eAttlist_linebreak_badbreak         = 5,
            eAttlist_linebreak_indentingnewline = 6
        };
        
        /// Access to EAttlist_linebreak's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_linebreak)(void);
        
        enum EAttlist_indentalign {
            eAttlist_indentalign_left   = 1,
            eAttlist_indentalign_center = 2,
            eAttlist_indentalign_right  = 3,
            eAttlist_indentalign_auto   = 4,
            eAttlist_indentalign_id     = 5
        };
        
        /// Access to EAttlist_indentalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalign)(void);
        
        enum EAttlist_indentalignfirst {
            eAttlist_indentalignfirst_left        = 1,
            eAttlist_indentalignfirst_center      = 2,
            eAttlist_indentalignfirst_right       = 3,
            eAttlist_indentalignfirst_auto        = 4,
            eAttlist_indentalignfirst_id          = 5,
            eAttlist_indentalignfirst_indentalign = 6
        };
        
        /// Access to EAttlist_indentalignfirst's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalignfirst)(void);
        
        enum EAttlist_indentalignlast {
            eAttlist_indentalignlast_left        = 1,
            eAttlist_indentalignlast_center      = 2,
            eAttlist_indentalignlast_right       = 3,
            eAttlist_indentalignlast_auto        = 4,
            eAttlist_indentalignlast_id          = 5,
            eAttlist_indentalignlast_indentalign = 6
        };
        
        /// Access to EAttlist_indentalignlast's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalignlast)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef EAttlist_mathvariant TMathvariant;
        typedef NCBI_NS_STD::string TMathsize;
        typedef EAttlist_dir TDir;
        typedef NCBI_NS_STD::string TFontfamily;
        typedef EAttlist_fontweight TFontweight;
        typedef EAttlist_fontstyle TFontstyle;
        typedef NCBI_NS_STD::string TFontsize;
        typedef NCBI_NS_STD::string TColor;
        typedef NCBI_NS_STD::string TBackground;
        typedef NCBI_NS_STD::string TWidth;
        typedef NCBI_NS_STD::string THeight;
        typedef NCBI_NS_STD::string TDepth;
        typedef EAttlist_linebreak TLinebreak;
        typedef EAttlist_indentalign TIndentalign;
        typedef NCBI_NS_STD::string TIndentshift;
        typedef NCBI_NS_STD::string TIndenttarget;
        typedef EAttlist_indentalignfirst TIndentalignfirst;
        typedef NCBI_NS_STD::string TIndentshiftfirst;
        typedef EAttlist_indentalignlast TIndentalignlast;
        typedef NCBI_NS_STD::string TIndentshiftlast;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_mathvariant,
            e_mathsize,
            e_dir,
            e_fontfamily,
            e_fontweight,
            e_fontstyle,
            e_fontsize,
            e_color,
            e_background,
            e_width,
            e_height,
            e_depth,
            e_linebreak,
            e_indentalign,
            e_indentshift,
            e_indenttarget,
            e_indentalignfirst,
            e_indentshiftfirst,
            e_indentalignlast,
            e_indentshiftlast
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 28> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef EAttlist_mathvariant TMathvariant
        ///  Check whether the Mathvariant data member has been assigned a value.
        bool IsSetMathvariant(void) const;
        /// Check whether it is safe or not to call GetMathvariant method.
        bool CanGetMathvariant(void) const;
        void ResetMathvariant(void);
        TMathvariant GetMathvariant(void) const;
        void SetMathvariant(TMathvariant value);
        TMathvariant& SetMathvariant(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathsize
        ///  Check whether the Mathsize data member has been assigned a value.
        bool IsSetMathsize(void) const;
        /// Check whether it is safe or not to call GetMathsize method.
        bool CanGetMathsize(void) const;
        void ResetMathsize(void);
        const TMathsize& GetMathsize(void) const;
        void SetMathsize(const TMathsize& value);
        void SetMathsize(TMathsize&& value);
        TMathsize& SetMathsize(void);
    
        /// optional
        /// typedef EAttlist_dir TDir
        ///  Check whether the Dir data member has been assigned a value.
        bool IsSetDir(void) const;
        /// Check whether it is safe or not to call GetDir method.
        bool CanGetDir(void) const;
        void ResetDir(void);
        TDir GetDir(void) const;
        void SetDir(TDir value);
        TDir& SetDir(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontfamily
        ///  Check whether the Fontfamily data member has been assigned a value.
        bool IsSetFontfamily(void) const;
        /// Check whether it is safe or not to call GetFontfamily method.
        bool CanGetFontfamily(void) const;
        void ResetFontfamily(void);
        const TFontfamily& GetFontfamily(void) const;
        void SetFontfamily(const TFontfamily& value);
        void SetFontfamily(TFontfamily&& value);
        TFontfamily& SetFontfamily(void);
    
        /// optional
        /// typedef EAttlist_fontweight TFontweight
        ///  Check whether the Fontweight data member has been assigned a value.
        bool IsSetFontweight(void) const;
        /// Check whether it is safe or not to call GetFontweight method.
        bool CanGetFontweight(void) const;
        void ResetFontweight(void);
        TFontweight GetFontweight(void) const;
        void SetFontweight(TFontweight value);
        TFontweight& SetFontweight(void);
    
        /// optional
        /// typedef EAttlist_fontstyle TFontstyle
        ///  Check whether the Fontstyle data member has been assigned a value.
        bool IsSetFontstyle(void) const;
        /// Check whether it is safe or not to call GetFontstyle method.
        bool CanGetFontstyle(void) const;
        void ResetFontstyle(void);
        TFontstyle GetFontstyle(void) const;
        void SetFontstyle(TFontstyle value);
        TFontstyle& SetFontstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontsize
        ///  Check whether the Fontsize data member has been assigned a value.
        bool IsSetFontsize(void) const;
        /// Check whether it is safe or not to call GetFontsize method.
        bool CanGetFontsize(void) const;
        void ResetFontsize(void);
        const TFontsize& GetFontsize(void) const;
        void SetFontsize(const TFontsize& value);
        void SetFontsize(TFontsize&& value);
        TFontsize& SetFontsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColor
        ///  Check whether the Color data member has been assigned a value.
        bool IsSetColor(void) const;
        /// Check whether it is safe or not to call GetColor method.
        bool CanGetColor(void) const;
        void ResetColor(void);
        const TColor& GetColor(void) const;
        void SetColor(const TColor& value);
        void SetColor(TColor&& value);
        TColor& SetColor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TBackground
        ///  Check whether the Background data member has been assigned a value.
        bool IsSetBackground(void) const;
        /// Check whether it is safe or not to call GetBackground method.
        bool CanGetBackground(void) const;
        void ResetBackground(void);
        const TBackground& GetBackground(void) const;
        void SetBackground(const TBackground& value);
        void SetBackground(TBackground&& value);
        TBackground& SetBackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TWidth
        ///  Check whether the Width data member has been assigned a value.
        bool IsSetWidth(void) const;
        /// Check whether it is safe or not to call GetWidth method.
        bool CanGetWidth(void) const;
        void ResetWidth(void);
        const TWidth& GetWidth(void) const;
        void SetWidth(const TWidth& value);
        void SetWidth(TWidth&& value);
        TWidth& SetWidth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THeight
        ///  Check whether the Height data member has been assigned a value.
        bool IsSetHeight(void) const;
        /// Check whether it is safe or not to call GetHeight method.
        bool CanGetHeight(void) const;
        void ResetHeight(void);
        const THeight& GetHeight(void) const;
        void SetHeight(const THeight& value);
        void SetHeight(THeight&& value);
        THeight& SetHeight(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDepth
        ///  Check whether the Depth data member has been assigned a value.
        bool IsSetDepth(void) const;
        /// Check whether it is safe or not to call GetDepth method.
        bool CanGetDepth(void) const;
        void ResetDepth(void);
        const TDepth& GetDepth(void) const;
        void SetDepth(const TDepth& value);
        void SetDepth(TDepth&& value);
        TDepth& SetDepth(void);
    
        /// optional
        /// typedef EAttlist_linebreak TLinebreak
        ///  Check whether the Linebreak data member has been assigned a value.
        bool IsSetLinebreak(void) const;
        /// Check whether it is safe or not to call GetLinebreak method.
        bool CanGetLinebreak(void) const;
        void ResetLinebreak(void);
        TLinebreak GetLinebreak(void) const;
        void SetLinebreak(TLinebreak value);
        TLinebreak& SetLinebreak(void);
    
        /// optional
        /// typedef EAttlist_indentalign TIndentalign
        ///  Check whether the Indentalign data member has been assigned a value.
        bool IsSetIndentalign(void) const;
        /// Check whether it is safe or not to call GetIndentalign method.
        bool CanGetIndentalign(void) const;
        void ResetIndentalign(void);
        TIndentalign GetIndentalign(void) const;
        void SetIndentalign(TIndentalign value);
        TIndentalign& SetIndentalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshift
        ///  Check whether the Indentshift data member has been assigned a value.
        bool IsSetIndentshift(void) const;
        /// Check whether it is safe or not to call GetIndentshift method.
        bool CanGetIndentshift(void) const;
        void ResetIndentshift(void);
        const TIndentshift& GetIndentshift(void) const;
        void SetIndentshift(const TIndentshift& value);
        void SetIndentshift(TIndentshift&& value);
        TIndentshift& SetIndentshift(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndenttarget
        ///  Check whether the Indenttarget data member has been assigned a value.
        bool IsSetIndenttarget(void) const;
        /// Check whether it is safe or not to call GetIndenttarget method.
        bool CanGetIndenttarget(void) const;
        void ResetIndenttarget(void);
        const TIndenttarget& GetIndenttarget(void) const;
        void SetIndenttarget(const TIndenttarget& value);
        void SetIndenttarget(TIndenttarget&& value);
        TIndenttarget& SetIndenttarget(void);
    
        /// optional
        /// typedef EAttlist_indentalignfirst TIndentalignfirst
        ///  Check whether the Indentalignfirst data member has been assigned a value.
        bool IsSetIndentalignfirst(void) const;
        /// Check whether it is safe or not to call GetIndentalignfirst method.
        bool CanGetIndentalignfirst(void) const;
        void ResetIndentalignfirst(void);
        TIndentalignfirst GetIndentalignfirst(void) const;
        void SetIndentalignfirst(TIndentalignfirst value);
        TIndentalignfirst& SetIndentalignfirst(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshiftfirst
        ///  Check whether the Indentshiftfirst data member has been assigned a value.
        bool IsSetIndentshiftfirst(void) const;
        /// Check whether it is safe or not to call GetIndentshiftfirst method.
        bool CanGetIndentshiftfirst(void) const;
        void ResetIndentshiftfirst(void);
        const TIndentshiftfirst& GetIndentshiftfirst(void) const;
        void SetIndentshiftfirst(const TIndentshiftfirst& value);
        void SetIndentshiftfirst(TIndentshiftfirst&& value);
        TIndentshiftfirst& SetIndentshiftfirst(void);
    
        /// optional
        /// typedef EAttlist_indentalignlast TIndentalignlast
        ///  Check whether the Indentalignlast data member has been assigned a value.
        bool IsSetIndentalignlast(void) const;
        /// Check whether it is safe or not to call GetIndentalignlast method.
        bool CanGetIndentalignlast(void) const;
        void ResetIndentalignlast(void);
        TIndentalignlast GetIndentalignlast(void) const;
        void SetIndentalignlast(TIndentalignlast value);
        TIndentalignlast& SetIndentalignlast(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshiftlast
        ///  Check whether the Indentshiftlast data member has been assigned a value.
        bool IsSetIndentshiftlast(void) const;
        /// Check whether it is safe or not to call GetIndentshiftlast method.
        bool CanGetIndentshiftlast(void) const;
        void ResetIndentshiftlast(void);
        const TIndentshiftlast& GetIndentshiftlast(void) const;
        void SetIndentshiftlast(const TIndentshiftlast& value);
        void SetIndentshiftlast(TIndentshiftlast&& value);
        TIndentshiftlast& SetIndentshiftlast(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[2];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        EAttlist_mathvariant m_Mathvariant;
        NCBI_NS_STD::string m_Mathsize;
        EAttlist_dir m_Dir;
        NCBI_NS_STD::string m_Fontfamily;
        EAttlist_fontweight m_Fontweight;
        EAttlist_fontstyle m_Fontstyle;
        NCBI_NS_STD::string m_Fontsize;
        NCBI_NS_STD::string m_Color;
        NCBI_NS_STD::string m_Background;
        NCBI_NS_STD::string m_Width;
        NCBI_NS_STD::string m_Height;
        NCBI_NS_STD::string m_Depth;
        EAttlist_linebreak m_Linebreak;
        EAttlist_indentalign m_Indentalign;
        NCBI_NS_STD::string m_Indentshift;
        NCBI_NS_STD::string m_Indenttarget;
        EAttlist_indentalignfirst m_Indentalignfirst;
        NCBI_NS_STD::string m_Indentshiftfirst;
        EAttlist_indentalignlast m_Indentalignlast;
        NCBI_NS_STD::string m_Indentshiftlast;
    };
    // types
    typedef C_Attlist TAttlist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_mspace
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    ///  Check whether the Mspace data member has been assigned a value.
    bool IsSetMspace(void) const;
    /// Check whether it is safe or not to call GetMspace method.
    bool CanGetMspace(void) const;
    void ResetMspace(void);
    void SetMspace(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMspace_Base(const CMspace_Base&);
    CMspace_Base& operator=(const CMspace_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMspace_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMspace_Base::C_Attlist::TId& CMspace_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMspace_Base::C_Attlist::SetId(const CMspace_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMspace_Base::C_Attlist::SetId(CMspace_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMspace_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMspace_Base::C_Attlist::TId& CMspace_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMspace_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMspace_Base::C_Attlist::TXref& CMspace_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMspace_Base::C_Attlist::SetXref(const CMspace_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMspace_Base::C_Attlist::SetXref(CMspace_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMspace_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMspace_Base::C_Attlist::TXref& CMspace_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMspace_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMspace_Base::C_Attlist::TClass& CMspace_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMspace_Base::C_Attlist::SetClass(const CMspace_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMspace_Base::C_Attlist::SetClass(CMspace_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMspace_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMspace_Base::C_Attlist::TClass& CMspace_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMspace_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMspace_Base::C_Attlist::TStyle& CMspace_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMspace_Base::C_Attlist::SetStyle(const CMspace_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMspace_Base::C_Attlist::SetStyle(CMspace_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMspace_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMspace_Base::C_Attlist::TStyle& CMspace_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMspace_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMspace_Base::C_Attlist::THref& CMspace_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMspace_Base::C_Attlist::SetHref(const CMspace_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMspace_Base::C_Attlist::SetHref(CMspace_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMspace_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMspace_Base::C_Attlist::THref& CMspace_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMspace_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMspace_Base::C_Attlist::TMathcolor& CMspace_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMspace_Base::C_Attlist::SetMathcolor(const CMspace_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMspace_Base::C_Attlist::SetMathcolor(CMspace_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMspace_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMspace_Base::C_Attlist::TMathcolor& CMspace_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMspace_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMspace_Base::C_Attlist::TMathbackground& CMspace_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMspace_Base::C_Attlist::SetMathbackground(const CMspace_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMspace_Base::C_Attlist::SetMathbackground(CMspace_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMspace_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMspace_Base::C_Attlist::TMathbackground& CMspace_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMspace_Base::C_Attlist::IsSetMathvariant(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetMathvariant(void) const
{
    return IsSetMathvariant();
}

inline
void CMspace_Base::C_Attlist::ResetMathvariant(void)
{
    m_Mathvariant = (EAttlist_mathvariant)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CMspace_Base::C_Attlist::TMathvariant CMspace_Base::C_Attlist::GetMathvariant(void) const
{
    if (!CanGetMathvariant()) {
        ThrowUnassigned(7);
    }
    return m_Mathvariant;
}

inline
void CMspace_Base::C_Attlist::SetMathvariant(CMspace_Base::C_Attlist::TMathvariant value)
{
    m_Mathvariant = value;
    m_set_State[0] |= 0xc000;
}

inline
CMspace_Base::C_Attlist::TMathvariant& CMspace_Base::C_Attlist::SetMathvariant(void)
{
#ifdef _DEBUG
    if (!IsSetMathvariant()) {
        memset(&m_Mathvariant,UnassignedByte(),sizeof(m_Mathvariant));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Mathvariant;
}

inline
bool CMspace_Base::C_Attlist::IsSetMathsize(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetMathsize(void) const
{
    return IsSetMathsize();
}

inline
const CMspace_Base::C_Attlist::TMathsize& CMspace_Base::C_Attlist::GetMathsize(void) const
{
    if (!CanGetMathsize()) {
        ThrowUnassigned(8);
    }
    return m_Mathsize;
}

inline
void CMspace_Base::C_Attlist::SetMathsize(const CMspace_Base::C_Attlist::TMathsize& value)
{
    m_Mathsize = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMspace_Base::C_Attlist::SetMathsize(CMspace_Base::C_Attlist::TMathsize&& value)
{
    m_Mathsize = std::forward<CMspace_Base::C_Attlist::TMathsize>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMspace_Base::C_Attlist::TMathsize& CMspace_Base::C_Attlist::SetMathsize(void)
{
#ifdef _DEBUG
    if (!IsSetMathsize()) {
        m_Mathsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Mathsize;
}

inline
bool CMspace_Base::C_Attlist::IsSetDir(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetDir(void) const
{
    return IsSetDir();
}

inline
void CMspace_Base::C_Attlist::ResetDir(void)
{
    m_Dir = (EAttlist_dir)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CMspace_Base::C_Attlist::TDir CMspace_Base::C_Attlist::GetDir(void) const
{
    if (!CanGetDir()) {
        ThrowUnassigned(9);
    }
    return m_Dir;
}

inline
void CMspace_Base::C_Attlist::SetDir(CMspace_Base::C_Attlist::TDir value)
{
    m_Dir = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMspace_Base::C_Attlist::TDir& CMspace_Base::C_Attlist::SetDir(void)
{
#ifdef _DEBUG
    if (!IsSetDir()) {
        memset(&m_Dir,UnassignedByte(),sizeof(m_Dir));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Dir;
}

inline
bool CMspace_Base::C_Attlist::IsSetFontfamily(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetFontfamily(void) const
{
    return IsSetFontfamily();
}

inline
const CMspace_Base::C_Attlist::TFontfamily& CMspace_Base::C_Attlist::GetFontfamily(void) const
{
    if (!CanGetFontfamily()) {
        ThrowUnassigned(10);
    }
    return m_Fontfamily;
}

inline
void CMspace_Base::C_Attlist::SetFontfamily(const CMspace_Base::C_Attlist::TFontfamily& value)
{
    m_Fontfamily = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMspace_Base::C_Attlist::SetFontfamily(CMspace_Base::C_Attlist::TFontfamily&& value)
{
    m_Fontfamily = std::forward<CMspace_Base::C_Attlist::TFontfamily>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMspace_Base::C_Attlist::TFontfamily& CMspace_Base::C_Attlist::SetFontfamily(void)
{
#ifdef _DEBUG
    if (!IsSetFontfamily()) {
        m_Fontfamily = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Fontfamily;
}

inline
bool CMspace_Base::C_Attlist::IsSetFontweight(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetFontweight(void) const
{
    return IsSetFontweight();
}

inline
void CMspace_Base::C_Attlist::ResetFontweight(void)
{
    m_Fontweight = (EAttlist_fontweight)(0);
    m_set_State[0] &= ~0xc00000;
}

inline
CMspace_Base::C_Attlist::TFontweight CMspace_Base::C_Attlist::GetFontweight(void) const
{
    if (!CanGetFontweight()) {
        ThrowUnassigned(11);
    }
    return m_Fontweight;
}

inline
void CMspace_Base::C_Attlist::SetFontweight(CMspace_Base::C_Attlist::TFontweight value)
{
    m_Fontweight = value;
    m_set_State[0] |= 0xc00000;
}

inline
CMspace_Base::C_Attlist::TFontweight& CMspace_Base::C_Attlist::SetFontweight(void)
{
#ifdef _DEBUG
    if (!IsSetFontweight()) {
        memset(&m_Fontweight,UnassignedByte(),sizeof(m_Fontweight));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Fontweight;
}

inline
bool CMspace_Base::C_Attlist::IsSetFontstyle(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetFontstyle(void) const
{
    return IsSetFontstyle();
}

inline
void CMspace_Base::C_Attlist::ResetFontstyle(void)
{
    m_Fontstyle = (EAttlist_fontstyle)(0);
    m_set_State[0] &= ~0x3000000;
}

inline
CMspace_Base::C_Attlist::TFontstyle CMspace_Base::C_Attlist::GetFontstyle(void) const
{
    if (!CanGetFontstyle()) {
        ThrowUnassigned(12);
    }
    return m_Fontstyle;
}

inline
void CMspace_Base::C_Attlist::SetFontstyle(CMspace_Base::C_Attlist::TFontstyle value)
{
    m_Fontstyle = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMspace_Base::C_Attlist::TFontstyle& CMspace_Base::C_Attlist::SetFontstyle(void)
{
#ifdef _DEBUG
    if (!IsSetFontstyle()) {
        memset(&m_Fontstyle,UnassignedByte(),sizeof(m_Fontstyle));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Fontstyle;
}

inline
bool CMspace_Base::C_Attlist::IsSetFontsize(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetFontsize(void) const
{
    return IsSetFontsize();
}

inline
const CMspace_Base::C_Attlist::TFontsize& CMspace_Base::C_Attlist::GetFontsize(void) const
{
    if (!CanGetFontsize()) {
        ThrowUnassigned(13);
    }
    return m_Fontsize;
}

inline
void CMspace_Base::C_Attlist::SetFontsize(const CMspace_Base::C_Attlist::TFontsize& value)
{
    m_Fontsize = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMspace_Base::C_Attlist::SetFontsize(CMspace_Base::C_Attlist::TFontsize&& value)
{
    m_Fontsize = std::forward<CMspace_Base::C_Attlist::TFontsize>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMspace_Base::C_Attlist::TFontsize& CMspace_Base::C_Attlist::SetFontsize(void)
{
#ifdef _DEBUG
    if (!IsSetFontsize()) {
        m_Fontsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Fontsize;
}

inline
bool CMspace_Base::C_Attlist::IsSetColor(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetColor(void) const
{
    return IsSetColor();
}

inline
const CMspace_Base::C_Attlist::TColor& CMspace_Base::C_Attlist::GetColor(void) const
{
    if (!CanGetColor()) {
        ThrowUnassigned(14);
    }
    return m_Color;
}

inline
void CMspace_Base::C_Attlist::SetColor(const CMspace_Base::C_Attlist::TColor& value)
{
    m_Color = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMspace_Base::C_Attlist::SetColor(CMspace_Base::C_Attlist::TColor&& value)
{
    m_Color = std::forward<CMspace_Base::C_Attlist::TColor>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMspace_Base::C_Attlist::TColor& CMspace_Base::C_Attlist::SetColor(void)
{
#ifdef _DEBUG
    if (!IsSetColor()) {
        m_Color = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Color;
}

inline
bool CMspace_Base::C_Attlist::IsSetBackground(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetBackground(void) const
{
    return IsSetBackground();
}

inline
const CMspace_Base::C_Attlist::TBackground& CMspace_Base::C_Attlist::GetBackground(void) const
{
    if (!CanGetBackground()) {
        ThrowUnassigned(15);
    }
    return m_Background;
}

inline
void CMspace_Base::C_Attlist::SetBackground(const CMspace_Base::C_Attlist::TBackground& value)
{
    m_Background = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMspace_Base::C_Attlist::SetBackground(CMspace_Base::C_Attlist::TBackground&& value)
{
    m_Background = std::forward<CMspace_Base::C_Attlist::TBackground>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMspace_Base::C_Attlist::TBackground& CMspace_Base::C_Attlist::SetBackground(void)
{
#ifdef _DEBUG
    if (!IsSetBackground()) {
        m_Background = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Background;
}

inline
bool CMspace_Base::C_Attlist::IsSetWidth(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetWidth(void) const
{
    return IsSetWidth();
}

inline
const CMspace_Base::C_Attlist::TWidth& CMspace_Base::C_Attlist::GetWidth(void) const
{
    if (!CanGetWidth()) {
        ThrowUnassigned(16);
    }
    return m_Width;
}

inline
void CMspace_Base::C_Attlist::SetWidth(const CMspace_Base::C_Attlist::TWidth& value)
{
    m_Width = value;
    m_set_State[1] |= 0x3;
}

inline
void CMspace_Base::C_Attlist::SetWidth(CMspace_Base::C_Attlist::TWidth&& value)
{
    m_Width = std::forward<CMspace_Base::C_Attlist::TWidth>(value);
    m_set_State[1] |= 0x3;
}

inline
CMspace_Base::C_Attlist::TWidth& CMspace_Base::C_Attlist::SetWidth(void)
{
#ifdef _DEBUG
    if (!IsSetWidth()) {
        m_Width = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Width;
}

inline
bool CMspace_Base::C_Attlist::IsSetHeight(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetHeight(void) const
{
    return IsSetHeight();
}

inline
const CMspace_Base::C_Attlist::THeight& CMspace_Base::C_Attlist::GetHeight(void) const
{
    if (!CanGetHeight()) {
        ThrowUnassigned(17);
    }
    return m_Height;
}

inline
void CMspace_Base::C_Attlist::SetHeight(const CMspace_Base::C_Attlist::THeight& value)
{
    m_Height = value;
    m_set_State[1] |= 0xc;
}

inline
void CMspace_Base::C_Attlist::SetHeight(CMspace_Base::C_Attlist::THeight&& value)
{
    m_Height = std::forward<CMspace_Base::C_Attlist::THeight>(value);
    m_set_State[1] |= 0xc;
}

inline
CMspace_Base::C_Attlist::THeight& CMspace_Base::C_Attlist::SetHeight(void)
{
#ifdef _DEBUG
    if (!IsSetHeight()) {
        m_Height = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Height;
}

inline
bool CMspace_Base::C_Attlist::IsSetDepth(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetDepth(void) const
{
    return IsSetDepth();
}

inline
const CMspace_Base::C_Attlist::TDepth& CMspace_Base::C_Attlist::GetDepth(void) const
{
    if (!CanGetDepth()) {
        ThrowUnassigned(18);
    }
    return m_Depth;
}

inline
void CMspace_Base::C_Attlist::SetDepth(const CMspace_Base::C_Attlist::TDepth& value)
{
    m_Depth = value;
    m_set_State[1] |= 0x30;
}

inline
void CMspace_Base::C_Attlist::SetDepth(CMspace_Base::C_Attlist::TDepth&& value)
{
    m_Depth = std::forward<CMspace_Base::C_Attlist::TDepth>(value);
    m_set_State[1] |= 0x30;
}

inline
CMspace_Base::C_Attlist::TDepth& CMspace_Base::C_Attlist::SetDepth(void)
{
#ifdef _DEBUG
    if (!IsSetDepth()) {
        m_Depth = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Depth;
}

inline
bool CMspace_Base::C_Attlist::IsSetLinebreak(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetLinebreak(void) const
{
    return IsSetLinebreak();
}

inline
void CMspace_Base::C_Attlist::ResetLinebreak(void)
{
    m_Linebreak = (EAttlist_linebreak)(0);
    m_set_State[1] &= ~0xc0;
}

inline
CMspace_Base::C_Attlist::TLinebreak CMspace_Base::C_Attlist::GetLinebreak(void) const
{
    if (!CanGetLinebreak()) {
        ThrowUnassigned(19);
    }
    return m_Linebreak;
}

inline
void CMspace_Base::C_Attlist::SetLinebreak(CMspace_Base::C_Attlist::TLinebreak value)
{
    m_Linebreak = value;
    m_set_State[1] |= 0xc0;
}

inline
CMspace_Base::C_Attlist::TLinebreak& CMspace_Base::C_Attlist::SetLinebreak(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreak()) {
        memset(&m_Linebreak,UnassignedByte(),sizeof(m_Linebreak));
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Linebreak;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndentalign(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndentalign(void) const
{
    return IsSetIndentalign();
}

inline
void CMspace_Base::C_Attlist::ResetIndentalign(void)
{
    m_Indentalign = (EAttlist_indentalign)(0);
    m_set_State[1] &= ~0x300;
}

inline
CMspace_Base::C_Attlist::TIndentalign CMspace_Base::C_Attlist::GetIndentalign(void) const
{
    if (!CanGetIndentalign()) {
        ThrowUnassigned(20);
    }
    return m_Indentalign;
}

inline
void CMspace_Base::C_Attlist::SetIndentalign(CMspace_Base::C_Attlist::TIndentalign value)
{
    m_Indentalign = value;
    m_set_State[1] |= 0x300;
}

inline
CMspace_Base::C_Attlist::TIndentalign& CMspace_Base::C_Attlist::SetIndentalign(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalign()) {
        memset(&m_Indentalign,UnassignedByte(),sizeof(m_Indentalign));
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Indentalign;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndentshift(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndentshift(void) const
{
    return IsSetIndentshift();
}

inline
const CMspace_Base::C_Attlist::TIndentshift& CMspace_Base::C_Attlist::GetIndentshift(void) const
{
    if (!CanGetIndentshift()) {
        ThrowUnassigned(21);
    }
    return m_Indentshift;
}

inline
void CMspace_Base::C_Attlist::SetIndentshift(const CMspace_Base::C_Attlist::TIndentshift& value)
{
    m_Indentshift = value;
    m_set_State[1] |= 0xc00;
}

inline
void CMspace_Base::C_Attlist::SetIndentshift(CMspace_Base::C_Attlist::TIndentshift&& value)
{
    m_Indentshift = std::forward<CMspace_Base::C_Attlist::TIndentshift>(value);
    m_set_State[1] |= 0xc00;
}

inline
CMspace_Base::C_Attlist::TIndentshift& CMspace_Base::C_Attlist::SetIndentshift(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshift()) {
        m_Indentshift = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Indentshift;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndenttarget(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndenttarget(void) const
{
    return IsSetIndenttarget();
}

inline
const CMspace_Base::C_Attlist::TIndenttarget& CMspace_Base::C_Attlist::GetIndenttarget(void) const
{
    if (!CanGetIndenttarget()) {
        ThrowUnassigned(22);
    }
    return m_Indenttarget;
}

inline
void CMspace_Base::C_Attlist::SetIndenttarget(const CMspace_Base::C_Attlist::TIndenttarget& value)
{
    m_Indenttarget = value;
    m_set_State[1] |= 0x3000;
}

inline
void CMspace_Base::C_Attlist::SetIndenttarget(CMspace_Base::C_Attlist::TIndenttarget&& value)
{
    m_Indenttarget = std::forward<CMspace_Base::C_Attlist::TIndenttarget>(value);
    m_set_State[1] |= 0x3000;
}

inline
CMspace_Base::C_Attlist::TIndenttarget& CMspace_Base::C_Attlist::SetIndenttarget(void)
{
#ifdef _DEBUG
    if (!IsSetIndenttarget()) {
        m_Indenttarget = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_Indenttarget;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndentalignfirst(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndentalignfirst(void) const
{
    return IsSetIndentalignfirst();
}

inline
void CMspace_Base::C_Attlist::ResetIndentalignfirst(void)
{
    m_Indentalignfirst = (EAttlist_indentalignfirst)(0);
    m_set_State[1] &= ~0xc000;
}

inline
CMspace_Base::C_Attlist::TIndentalignfirst CMspace_Base::C_Attlist::GetIndentalignfirst(void) const
{
    if (!CanGetIndentalignfirst()) {
        ThrowUnassigned(23);
    }
    return m_Indentalignfirst;
}

inline
void CMspace_Base::C_Attlist::SetIndentalignfirst(CMspace_Base::C_Attlist::TIndentalignfirst value)
{
    m_Indentalignfirst = value;
    m_set_State[1] |= 0xc000;
}

inline
CMspace_Base::C_Attlist::TIndentalignfirst& CMspace_Base::C_Attlist::SetIndentalignfirst(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalignfirst()) {
        memset(&m_Indentalignfirst,UnassignedByte(),sizeof(m_Indentalignfirst));
    }
#endif
    m_set_State[1] |= 0x4000;
    return m_Indentalignfirst;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndentshiftfirst(void) const
{
    return ((m_set_State[1] & 0x30000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndentshiftfirst(void) const
{
    return IsSetIndentshiftfirst();
}

inline
const CMspace_Base::C_Attlist::TIndentshiftfirst& CMspace_Base::C_Attlist::GetIndentshiftfirst(void) const
{
    if (!CanGetIndentshiftfirst()) {
        ThrowUnassigned(24);
    }
    return m_Indentshiftfirst;
}

inline
void CMspace_Base::C_Attlist::SetIndentshiftfirst(const CMspace_Base::C_Attlist::TIndentshiftfirst& value)
{
    m_Indentshiftfirst = value;
    m_set_State[1] |= 0x30000;
}

inline
void CMspace_Base::C_Attlist::SetIndentshiftfirst(CMspace_Base::C_Attlist::TIndentshiftfirst&& value)
{
    m_Indentshiftfirst = std::forward<CMspace_Base::C_Attlist::TIndentshiftfirst>(value);
    m_set_State[1] |= 0x30000;
}

inline
CMspace_Base::C_Attlist::TIndentshiftfirst& CMspace_Base::C_Attlist::SetIndentshiftfirst(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshiftfirst()) {
        m_Indentshiftfirst = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10000;
    return m_Indentshiftfirst;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndentalignlast(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndentalignlast(void) const
{
    return IsSetIndentalignlast();
}

inline
void CMspace_Base::C_Attlist::ResetIndentalignlast(void)
{
    m_Indentalignlast = (EAttlist_indentalignlast)(0);
    m_set_State[1] &= ~0xc0000;
}

inline
CMspace_Base::C_Attlist::TIndentalignlast CMspace_Base::C_Attlist::GetIndentalignlast(void) const
{
    if (!CanGetIndentalignlast()) {
        ThrowUnassigned(25);
    }
    return m_Indentalignlast;
}

inline
void CMspace_Base::C_Attlist::SetIndentalignlast(CMspace_Base::C_Attlist::TIndentalignlast value)
{
    m_Indentalignlast = value;
    m_set_State[1] |= 0xc0000;
}

inline
CMspace_Base::C_Attlist::TIndentalignlast& CMspace_Base::C_Attlist::SetIndentalignlast(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalignlast()) {
        memset(&m_Indentalignlast,UnassignedByte(),sizeof(m_Indentalignlast));
    }
#endif
    m_set_State[1] |= 0x40000;
    return m_Indentalignlast;
}

inline
bool CMspace_Base::C_Attlist::IsSetIndentshiftlast(void) const
{
    return ((m_set_State[1] & 0x300000) != 0);
}

inline
bool CMspace_Base::C_Attlist::CanGetIndentshiftlast(void) const
{
    return IsSetIndentshiftlast();
}

inline
const CMspace_Base::C_Attlist::TIndentshiftlast& CMspace_Base::C_Attlist::GetIndentshiftlast(void) const
{
    if (!CanGetIndentshiftlast()) {
        ThrowUnassigned(26);
    }
    return m_Indentshiftlast;
}

inline
void CMspace_Base::C_Attlist::SetIndentshiftlast(const CMspace_Base::C_Attlist::TIndentshiftlast& value)
{
    m_Indentshiftlast = value;
    m_set_State[1] |= 0x300000;
}

inline
void CMspace_Base::C_Attlist::SetIndentshiftlast(CMspace_Base::C_Attlist::TIndentshiftlast&& value)
{
    m_Indentshiftlast = std::forward<CMspace_Base::C_Attlist::TIndentshiftlast>(value);
    m_set_State[1] |= 0x300000;
}

inline
CMspace_Base::C_Attlist::TIndentshiftlast& CMspace_Base::C_Attlist::SetIndentshiftlast(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshiftlast()) {
        m_Indentshiftlast = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x100000;
    return m_Indentshiftlast;
}

inline
bool CMspace_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMspace_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMspace_Base::TAttlist& CMspace_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMspace_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMspace_Base::TAttlist& CMspace_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    SetMspace();
    return (*m_Attlist);
}

inline
bool CMspace_Base::IsSetMspace(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMspace_Base::CanGetMspace(void) const
{
    return false;
}

inline
void CMspace_Base::ResetMspace(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CMspace_Base::SetMspace(void)
{
    m_set_State[0] |= 0xc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MSPACE_BASE_HPP
