/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PMID.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// New methods or data members can be added to it if needed.
/// See also: PMID_.hpp


#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PMID_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PMID_HPP


// generated includes
#include <objtools/eutils/efetch/PMID_.hpp>

// generated classes

BEGIN_eutils_SCOPE // namespace eutils::

/////////////////////////////////////////////////////////////////////////////
class CPMID : public CPMID_Base
{
    typedef CPMID_Base Tparent;
public:
    // constructor
    CPMID(void);
    CPMID(const std::string& value);
    // destructor
    ~CPMID(void);

    // typedef std::string TPMID;

    /// Conversion operator to 'TPMID' type.
    operator const TPMID&(void) const;
    /// Assignment operator.
    CPMID& operator=(const TPMID& value);

private:
    // Prohibit copy constructor and assignment operator
    CPMID(const CPMID& value);
    CPMID& operator=(const CPMID& value);

};

/////////////////// CPMID inline methods

// constructor
inline
CPMID::CPMID(void)
{
}

inline
CPMID::CPMID(const std::string& value)
{
    SetPMID(value);
}

inline
CPMID::operator const CPMID::TPMID&(void) const
{
    return GetPMID();
}

inline
CPMID& CPMID::operator=(const TPMID& value)
{
    SetPMID(value);
    return *this;
}


/////////////////// end of CPMID inline methods


END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PMID_HPP
/* Original file checksum: lines: 109, chars: 2754, CRC32: 73c6cc6b */
