/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Publisher_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBLISHER_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBLISHER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CPublisherLocation;
class CPublisherName;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPublisher_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPublisher_Base(void);
    // destructor
    virtual ~CPublisher_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPublisherName TPublisherName;
    typedef CPublisherLocation TPublisherLocation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_PublisherName,
        e_PublisherLocation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CPublisherName TPublisherName
    ///  Check whether the PublisherName data member has been assigned a value.
    bool IsSetPublisherName(void) const;
    /// Check whether it is safe or not to call GetPublisherName method.
    bool CanGetPublisherName(void) const;
    void ResetPublisherName(void);
    const TPublisherName& GetPublisherName(void) const;
    void SetPublisherName(TPublisherName& value);
    TPublisherName& SetPublisherName(void);

    /// optional
    /// typedef CPublisherLocation TPublisherLocation
    ///  Check whether the PublisherLocation data member has been assigned a value.
    bool IsSetPublisherLocation(void) const;
    /// Check whether it is safe or not to call GetPublisherLocation method.
    bool CanGetPublisherLocation(void) const;
    void ResetPublisherLocation(void);
    const TPublisherLocation& GetPublisherLocation(void) const;
    void SetPublisherLocation(TPublisherLocation& value);
    TPublisherLocation& SetPublisherLocation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPublisher_Base(const CPublisher_Base&);
    CPublisher_Base& operator=(const CPublisher_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TPublisherName > m_PublisherName;
    NCBI_NS_NCBI::CRef< TPublisherLocation > m_PublisherLocation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPublisher_Base::IsSetPublisherName(void) const
{
    return m_PublisherName.NotEmpty();
}

inline
bool CPublisher_Base::CanGetPublisherName(void) const
{
    return true;
}

inline
const CPublisher_Base::TPublisherName& CPublisher_Base::GetPublisherName(void) const
{
    if ( !m_PublisherName ) {
        const_cast<CPublisher_Base*>(this)->ResetPublisherName();
    }
    return (*m_PublisherName);
}

inline
CPublisher_Base::TPublisherName& CPublisher_Base::SetPublisherName(void)
{
    if ( !m_PublisherName ) {
        ResetPublisherName();
    }
    return (*m_PublisherName);
}

inline
bool CPublisher_Base::IsSetPublisherLocation(void) const
{
    return m_PublisherLocation.NotEmpty();
}

inline
bool CPublisher_Base::CanGetPublisherLocation(void) const
{
    return IsSetPublisherLocation();
}

inline
const CPublisher_Base::TPublisherLocation& CPublisher_Base::GetPublisherLocation(void) const
{
    if (!CanGetPublisherLocation()) {
        ThrowUnassigned(1);
    }
    return (*m_PublisherLocation);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBLISHER_BASE_HPP
