/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PubmedBookArticle_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDBOOKARTICLE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDBOOKARTICLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CBookDocument;
class CPubmedBookData;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPubmedBookArticle_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPubmedBookArticle_Base(void);
    // destructor
    virtual ~CPubmedBookArticle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBookDocument TBookDocument;
    typedef CPubmedBookData TPubmedBookData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_BookDocument,
        e_PubmedBookData
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBookDocument TBookDocument
    ///  Check whether the BookDocument data member has been assigned a value.
    bool IsSetBookDocument(void) const;
    /// Check whether it is safe or not to call GetBookDocument method.
    bool CanGetBookDocument(void) const;
    void ResetBookDocument(void);
    const TBookDocument& GetBookDocument(void) const;
    void SetBookDocument(TBookDocument& value);
    TBookDocument& SetBookDocument(void);

    /// optional
    /// typedef CPubmedBookData TPubmedBookData
    ///  Check whether the PubmedBookData data member has been assigned a value.
    bool IsSetPubmedBookData(void) const;
    /// Check whether it is safe or not to call GetPubmedBookData method.
    bool CanGetPubmedBookData(void) const;
    void ResetPubmedBookData(void);
    const TPubmedBookData& GetPubmedBookData(void) const;
    void SetPubmedBookData(TPubmedBookData& value);
    TPubmedBookData& SetPubmedBookData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmedBookArticle_Base(const CPubmedBookArticle_Base&);
    CPubmedBookArticle_Base& operator=(const CPubmedBookArticle_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TBookDocument > m_BookDocument;
    NCBI_NS_NCBI::CRef< TPubmedBookData > m_PubmedBookData;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubmedBookArticle_Base::IsSetBookDocument(void) const
{
    return m_BookDocument.NotEmpty();
}

inline
bool CPubmedBookArticle_Base::CanGetBookDocument(void) const
{
    return true;
}

inline
const CPubmedBookArticle_Base::TBookDocument& CPubmedBookArticle_Base::GetBookDocument(void) const
{
    if ( !m_BookDocument ) {
        const_cast<CPubmedBookArticle_Base*>(this)->ResetBookDocument();
    }
    return (*m_BookDocument);
}

inline
CPubmedBookArticle_Base::TBookDocument& CPubmedBookArticle_Base::SetBookDocument(void)
{
    if ( !m_BookDocument ) {
        ResetBookDocument();
    }
    return (*m_BookDocument);
}

inline
bool CPubmedBookArticle_Base::IsSetPubmedBookData(void) const
{
    return m_PubmedBookData.NotEmpty();
}

inline
bool CPubmedBookArticle_Base::CanGetPubmedBookData(void) const
{
    return IsSetPubmedBookData();
}

inline
const CPubmedBookArticle_Base::TPubmedBookData& CPubmedBookArticle_Base::GetPubmedBookData(void) const
{
    if (!CanGetPubmedBookData()) {
        ThrowUnassigned(1);
    }
    return (*m_PubmedBookData);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDBOOKARTICLE_BASE_HPP
