/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file URL_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_URL_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_URL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CURL_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CURL_Base(void);
    // destructor
    virtual ~CURL_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_lang {
            eAttlist_lang_AF =  1,
            eAttlist_lang_AR =  2,
            eAttlist_lang_AZ =  3,
            eAttlist_lang_BG =  4,
            eAttlist_lang_CS =  5,
            eAttlist_lang_DA =  6,
            eAttlist_lang_DE =  7,
            eAttlist_lang_EN =  8,
            eAttlist_lang_EL =  9,
            eAttlist_lang_ES = 10,
            eAttlist_lang_FA = 11,
            eAttlist_lang_FI = 12,
            eAttlist_lang_FR = 13,
            eAttlist_lang_HE = 14,
            eAttlist_lang_HU = 15,
            eAttlist_lang_HY = 16,
            eAttlist_lang_IN = 17,
            eAttlist_lang_IS = 18,
            eAttlist_lang_IT = 19,
            eAttlist_lang_IW = 20,
            eAttlist_lang_JA = 21,
            eAttlist_lang_KA = 22,
            eAttlist_lang_KO = 23,
            eAttlist_lang_LT = 24,
            eAttlist_lang_MK = 25,
            eAttlist_lang_ML = 26,
            eAttlist_lang_NL = 27,
            eAttlist_lang_NO = 28,
            eAttlist_lang_PL = 29,
            eAttlist_lang_PT = 30,
            eAttlist_lang_PS = 31,
            eAttlist_lang_RO = 32,
            eAttlist_lang_RU = 33,
            eAttlist_lang_SL = 34,
            eAttlist_lang_SK = 35,
            eAttlist_lang_SQ = 36,
            eAttlist_lang_SR = 37,
            eAttlist_lang_SV = 38,
            eAttlist_lang_SW = 39,
            eAttlist_lang_TH = 40,
            eAttlist_lang_TR = 41,
            eAttlist_lang_UK = 42,
            eAttlist_lang_VI = 43,
            eAttlist_lang_ZH = 44
        };
        
        /// Access to EAttlist_lang's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_lang)(void);
        
        enum EAttlist_Type {
            eAttlist_Type_FullText = 1,
            eAttlist_Type_Summary  = 2,
            eAttlist_Type_fulltext = 3,
            eAttlist_Type_summary  = 4
        };
        
        /// Access to EAttlist_Type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Type)(void);
        
        // types
        typedef EAttlist_lang TLang;
        typedef EAttlist_Type TType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_lang,
            e_Type
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef EAttlist_lang TLang
        ///  Check whether the Lang data member has been assigned a value.
        bool IsSetLang(void) const;
        /// Check whether it is safe or not to call GetLang method.
        bool CanGetLang(void) const;
        void ResetLang(void);
        TLang GetLang(void) const;
        void SetLang(TLang value);
        TLang& SetLang(void);
    
        /// optional
        /// typedef EAttlist_Type TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        TType GetType(void) const;
        void SetType(TType value);
        TType& SetType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_lang m_Lang;
        EAttlist_Type m_Type;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TURL;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_URL
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TURL
    ///  Check whether the URL data member has been assigned a value.
    bool IsSetURL(void) const;
    /// Check whether it is safe or not to call GetURL method.
    bool CanGetURL(void) const;
    void ResetURL(void);
    const TURL& GetURL(void) const;
    void SetURL(const TURL& value);
    void SetURL(TURL&& value);
    TURL& SetURL(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CURL_Base(const CURL_Base&);
    CURL_Base& operator=(const CURL_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_URL;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CURL_Base::C_Attlist::IsSetLang(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CURL_Base::C_Attlist::CanGetLang(void) const
{
    return IsSetLang();
}

inline
void CURL_Base::C_Attlist::ResetLang(void)
{
    m_Lang = (EAttlist_lang)(0);
    m_set_State[0] &= ~0x3;
}

inline
CURL_Base::C_Attlist::TLang CURL_Base::C_Attlist::GetLang(void) const
{
    if (!CanGetLang()) {
        ThrowUnassigned(0);
    }
    return m_Lang;
}

inline
void CURL_Base::C_Attlist::SetLang(CURL_Base::C_Attlist::TLang value)
{
    m_Lang = value;
    m_set_State[0] |= 0x3;
}

inline
CURL_Base::C_Attlist::TLang& CURL_Base::C_Attlist::SetLang(void)
{
#ifdef _DEBUG
    if (!IsSetLang()) {
        memset(&m_Lang,UnassignedByte(),sizeof(m_Lang));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Lang;
}

inline
bool CURL_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CURL_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CURL_Base::C_Attlist::ResetType(void)
{
    m_Type = (EAttlist_Type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CURL_Base::C_Attlist::TType CURL_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CURL_Base::C_Attlist::SetType(CURL_Base::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CURL_Base::C_Attlist::TType& CURL_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CURL_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CURL_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CURL_Base::TAttlist& CURL_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CURL_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CURL_Base::TAttlist& CURL_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CURL_Base::IsSetURL(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CURL_Base::CanGetURL(void) const
{
    return IsSetURL();
}

inline
const CURL_Base::TURL& CURL_Base::GetURL(void) const
{
    if (!CanGetURL()) {
        ThrowUnassigned(1);
    }
    return m_URL;
}

inline
void CURL_Base::SetURL(const CURL_Base::TURL& value)
{
    m_URL = value;
    m_set_State[0] |= 0xc;
}

inline
void CURL_Base::SetURL(CURL_Base::TURL&& value)
{
    m_URL = std::forward<CURL_Base::TURL>(value);
    m_set_State[0] |= 0xc;
}

inline
CURL_Base::TURL& CURL_Base::SetURL(void)
{
#ifdef _DEBUG
    if (!IsSetURL()) {
        m_URL = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_URL;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_URL_BASE_HPP
