/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ELinkResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_ELINKRESULT_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_ELINKRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CLinkSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CELinkResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CELinkResult_Base(void);
    // destructor
    virtual ~CELinkResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkSet > > TLinkSet;
    typedef NCBI_NS_STD::string TERROR;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_LinkSet,
        e_ERROR
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Common 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkSet > > TLinkSet
    ///  Check whether the LinkSet data member has been assigned a value.
    bool IsSetLinkSet(void) const;
    /// Check whether it is safe or not to call GetLinkSet method.
    bool CanGetLinkSet(void) const;
    void ResetLinkSet(void);
    const TLinkSet& GetLinkSet(void) const;
    TLinkSet& SetLinkSet(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TERROR
    ///  Check whether the ERROR data member has been assigned a value.
    bool IsSetERROR(void) const;
    /// Check whether it is safe or not to call GetERROR method.
    bool CanGetERROR(void) const;
    void ResetERROR(void);
    const TERROR& GetERROR(void) const;
    void SetERROR(const TERROR& value);
    void SetERROR(TERROR&& value);
    TERROR& SetERROR(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CELinkResult_Base(const CELinkResult_Base&);
    CELinkResult_Base& operator=(const CELinkResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLinkSet > > m_LinkSet;
    NCBI_NS_STD::string m_ERROR;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CELinkResult_Base::IsSetLinkSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CELinkResult_Base::CanGetLinkSet(void) const
{
    return true;
}

inline
const CELinkResult_Base::TLinkSet& CELinkResult_Base::GetLinkSet(void) const
{
    return m_LinkSet;
}

inline
CELinkResult_Base::TLinkSet& CELinkResult_Base::SetLinkSet(void)
{
    m_set_State[0] |= 0x1;
    return m_LinkSet;
}

inline
bool CELinkResult_Base::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CELinkResult_Base::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CELinkResult_Base::TERROR& CELinkResult_Base::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(1);
    }
    return m_ERROR;
}

inline
void CELinkResult_Base::SetERROR(const CELinkResult_Base::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0xc;
}

inline
void CELinkResult_Base::SetERROR(CELinkResult_Base::TERROR&& value)
{
    m_ERROR = std::forward<CELinkResult_Base::TERROR>(value);
    m_set_State[0] |= 0xc;
}

inline
CELinkResult_Base::TERROR& CELinkResult_Base::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ERROR;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_ELINKRESULT_BASE_HPP
