/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file IdUrlSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_IDURLSET_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_IDURLSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CId;
class CObjUrl;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CIdUrlSet_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CIdUrlSet_Base(void);
    // destructor
    virtual ~CIdUrlSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Data : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_ObjUrl,
            e_Info          ///< .+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Info+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CObjUrl > > TObjUrl;
        typedef NCBI_NS_STD::string TInfo;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CObjUrl > > TObjUrl
        bool IsObjUrl(void) const;
        const TObjUrl& GetObjUrl(void) const;
        TObjUrl& SetObjUrl(void);
    
        // typedef NCBI_NS_STD::string TInfo
        bool IsInfo(void) const;
        const TInfo& GetInfo(void) const;
        TInfo& SetInfo(void);
        void SetInfo(const TInfo& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TObjUrl> m_ObjUrl;
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef CId TId;
    typedef C_Data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Id,
        e_OI
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// \d+ 
    /// mandatory
    /// typedef CId TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);
    void SetId(const NCBI_NS_STD::string& value);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CIdUrlSet_Base(const CIdUrlSet_Base&);
    CIdUrlSet_Base& operator=(const CIdUrlSet_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TId > m_Id;
    NCBI_NS_NCBI::CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CIdUrlSet_Base::C_Data::E_Choice CIdUrlSet_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CIdUrlSet_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CIdUrlSet_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CIdUrlSet_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CIdUrlSet_Base::C_Data::IsObjUrl(void) const
{
    return m_choice == e_ObjUrl;
}

inline
const CIdUrlSet_Base::C_Data::TObjUrl& CIdUrlSet_Base::C_Data::GetObjUrl(void) const
{
    CheckSelected(e_ObjUrl);
    return *m_ObjUrl;
}

inline
CIdUrlSet_Base::C_Data::TObjUrl& CIdUrlSet_Base::C_Data::SetObjUrl(void)
{
    Select(e_ObjUrl, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_ObjUrl;
}

inline
bool CIdUrlSet_Base::C_Data::IsInfo(void) const
{
    return m_choice == e_Info;
}

inline
const CIdUrlSet_Base::C_Data::TInfo& CIdUrlSet_Base::C_Data::GetInfo(void) const
{
    CheckSelected(e_Info);
    return *m_string;
}

inline
CIdUrlSet_Base::C_Data::TInfo& CIdUrlSet_Base::C_Data::SetInfo(void)
{
    Select(e_Info, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CIdUrlSet_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CIdUrlSet_Base::CanGetId(void) const
{
    return true;
}

inline
const CIdUrlSet_Base::TId& CIdUrlSet_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CIdUrlSet_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CIdUrlSet_Base::TId& CIdUrlSet_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CIdUrlSet_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CIdUrlSet_Base::CanGetData(void) const
{
    return true;
}

inline
const CIdUrlSet_Base::TData& CIdUrlSet_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CIdUrlSet_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CIdUrlSet_Base::TData& CIdUrlSet_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_IDURLSET_BASE_HPP
