/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Link_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_LINK_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_LINK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CId;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// cmd=neighbor 
class NCBI_EUTILS_EXPORT CLink_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CLink_Base(void);
    // destructor
    virtual ~CLink_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CId TId;
    typedef NCBI_NS_STD::string TScore;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Id,
        e_Score
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// \d+ 
    /// mandatory
    /// typedef CId TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);
    void SetId(const NCBI_NS_STD::string& value);

    /// \d+ 
    /// optional
    /// typedef NCBI_NS_STD::string TScore
    ///  Check whether the Score data member has been assigned a value.
    bool IsSetScore(void) const;
    /// Check whether it is safe or not to call GetScore method.
    bool CanGetScore(void) const;
    void ResetScore(void);
    const TScore& GetScore(void) const;
    void SetScore(const TScore& value);
    void SetScore(TScore&& value);
    TScore& SetScore(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLink_Base(const CLink_Base&);
    CLink_Base& operator=(const CLink_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TId > m_Id;
    NCBI_NS_STD::string m_Score;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLink_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CLink_Base::CanGetId(void) const
{
    return true;
}

inline
const CLink_Base::TId& CLink_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CLink_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CLink_Base::TId& CLink_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CLink_Base::IsSetScore(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLink_Base::CanGetScore(void) const
{
    return IsSetScore();
}

inline
const CLink_Base::TScore& CLink_Base::GetScore(void) const
{
    if (!CanGetScore()) {
        ThrowUnassigned(1);
    }
    return m_Score;
}

inline
void CLink_Base::SetScore(const CLink_Base::TScore& value)
{
    m_Score = value;
    m_set_State[0] |= 0xc;
}

inline
void CLink_Base::SetScore(CLink_Base::TScore&& value)
{
    m_Score = std::forward<CLink_Base::TScore>(value);
    m_set_State[0] |= 0xc;
}

inline
CLink_Base::TScore& CLink_Base::SetScore(void)
{
#ifdef _DEBUG
    if (!IsSetScore()) {
        m_Score = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Score;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_LINK_BASE_HPP
