/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.php.util.PhpUtil;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.filesystems.FileObject;

public class SoapClientPhpCodeGenerator
extends SaasClientCodeGenerator {
    private static final String FILE = "file://";

    public boolean canAccept(SaasMethod method, Document doc) {
        return method instanceof WsdlSaasMethod && PhpUtil.isPhp(doc);
    }

    public Set<FileObject> generate() throws IOException {
        try {
            this.insert(PhpUtil.wrapWithTag(this.getCustomMethodBody(), this.getTargetDocument(), this.getStartPosition()), true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
        return super.generate();
    }

    public void init(SaasMethod method, Document doc) throws IOException {
        super.init(method, doc);
        this.setBean((SaasBean)new SoapClientSaasBean((WsdlSaasMethod)method, this.getProject()));
    }

    public SoapClientSaasBean getBean() {
        return (SoapClientSaasBean)super.getBean();
    }

    private String genPhpParms(SoapClientSaasBean bean) {
        StringBuffer params = new StringBuffer("");
        List parameters = bean.getInputParameters();
        for (ParameterInfo parameter : parameters) {
            String parmName = parameter.getName();
            String parmTypeName = parameter.getTypeName();
            Object value = parameter.getDefaultValue();
            String def = null;
            if (value != null) {
                def = value.toString();
            }
            if (def != null) {
                params.append("'" + parmName + "'" + "=> \"" + def + "\", \n");
                continue;
            }
            params.append("'" + parmName + "'" + "=> \"\",\n");
        }
        return params.toString();
    }

    protected String getCustomMethodBody() throws IOException {
        String indent2 = "                    ";
        String wsdlUrl = "";
        String methodName = "";
        SoapClientSaasBean bean = this.getBean();
        SoapClientOperationInfo[] infos = bean.getOperationInfos();
        if (infos.length > 0) {
            wsdlUrl = infos[0].getWsdlURL();
            methodName = infos[0].getOperationName();
        }
        if (wsdlUrl.startsWith(FILE.substring(0, FILE.length() - 1)) && !wsdlUrl.startsWith(FILE.substring(0, FILE.length()))) {
            wsdlUrl = FILE + wsdlUrl.substring(FILE.length() - 1);
        }
        String paramDecl = "$params = array( \n" + this.genPhpParms(bean) + ");";
        String methodBody = "\n";
        methodBody = methodBody + indent2 + "try {\n";
        methodBody = methodBody + indent2 + "$wsdl_url = '" + wsdlUrl + "';\n";
        methodBody = methodBody + indent2 + "$client     = new SOAPClient($wsdl_url);\n";
        methodBody = methodBody + indent2 + paramDecl + "\n";
        methodBody = methodBody + indent2 + "$return = $client->" + methodName + "($params);\n";
        methodBody = methodBody + indent2 + "print_r($return);\n";
        methodBody = methodBody + indent2 + "} catch(Exception $e) {\n";
        methodBody = methodBody + indent2 + "    echo \"Exception occured: \".$e;\n";
        methodBody = methodBody + indent2 + "}\n";
        return methodBody;
    }
}

