/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SrcMgr;
import org.clang.lex.HeaderMap;
import org.clang.lex.HeaderSearch;
import org.clang.lex.ModuleMap;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class DirectoryLookup
implements Native.NativePOD<DirectoryLookup> {
    public static DirectoryLookup DEFAULT = new DirectoryLookup();
    private Unnamed_union1 u;
    private byte DirCharacteristic;
    private byte LookupType;
    private boolean IsIndexHeaderMap;
    private boolean SearchedAllModuleMaps;
    private boolean $LookupFileTmpDirInUse = false;
    private final SmallString $LookupFileTmpDir = new SmallString(1024);
    private boolean $LookupFilePathInUse = false;
    private final SmallString $LookupFilePath = new SmallString(1024);

    private DirectoryLookup() {
    }

    public DirectoryLookup(DirectoryEntry dir, SrcMgr.CharacteristicKind DT, boolean isFramework) {
        this.u = new Unnamed_union1();
        this.DirCharacteristic = DT.getValue();
        this.LookupType = (byte)(isFramework ? LookupType_t.LT_Framework.getValue() : LookupType_t.LT_NormalDir.getValue());
        this.IsIndexHeaderMap = false;
        this.SearchedAllModuleMaps = false;
        this.u.Dir = dir;
    }

    public DirectoryLookup(HeaderMap map2, SrcMgr.CharacteristicKind DT, boolean isIndexHeaderMap) {
        this.u = new Unnamed_union1();
        this.DirCharacteristic = DT.getValue();
        this.LookupType = (byte)LookupType_t.LT_HeaderMap.getValue();
        this.IsIndexHeaderMap = isIndexHeaderMap;
        this.SearchedAllModuleMaps = false;
        this.u.Map = map2;
    }

    public LookupType_t getLookupType() {
        return LookupType_t.valueOf(this.LookupType);
    }

    public char.ptr getName() {
        if (this.isNormalDir()) {
            return this.getDir().getName();
        }
        if (this.isFramework()) {
            return this.getFrameworkDir().getName();
        }
        assert (this.isHeaderMap()) : "Unknown DirectoryLookup";
        return this.getHeaderMap().getFileName();
    }

    public DirectoryEntry getDir() {
        return this.isNormalDir() ? this.u.Dir : null;
    }

    public DirectoryEntry getFrameworkDir() {
        return this.isFramework() ? this.u.Dir : null;
    }

    public HeaderMap getHeaderMap() {
        return this.isHeaderMap() ? this.u.Map : null;
    }

    public boolean isNormalDir() {
        return this.getLookupType() == LookupType_t.LT_NormalDir;
    }

    public boolean isFramework() {
        return this.getLookupType() == LookupType_t.LT_Framework;
    }

    public boolean isHeaderMap() {
        return this.getLookupType() == LookupType_t.LT_HeaderMap;
    }

    public boolean haveSearchedAllModuleMaps() {
        return this.SearchedAllModuleMaps;
    }

    public void setSearchedAllModuleMaps(boolean SAMM) {
        this.SearchedAllModuleMaps = SAMM;
    }

    public SrcMgr.CharacteristicKind getDirCharacteristic() {
        return SrcMgr.CharacteristicKind.valueOf((int)this.DirCharacteristic);
    }

    public byte $getDirCharacteristic() {
        return this.DirCharacteristic;
    }

    public boolean isSystemHeaderDirectory() {
        return this.$getDirCharacteristic() != 0;
    }

    public boolean isIndexHeaderMap() {
        return this.isHeaderMap() && this.IsIndexHeaderMap;
    }

    private SmallString $getLookupFileTmpDir() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFileTmpDirInUse) break block3;
                this.$LookupFileTmpDirInUse = true;
                if (true) break block2;
            }
            throw new AssertionError((Object)"already in use. Forgot to release? Or have to switch to vector-based impl?");
        }
        this.$LookupFileTmpDir.resize(0);
        return this.$LookupFileTmpDir;
    }

    private void $releaseLookupFileTmpDir(SmallString TmpDir) {
        assert (TmpDir == this.$LookupFileTmpDir) : "returns different instance";
        assert (this.$LookupFileTmpDirInUse) : "releasing without get ";
        if (!$assertionsDisabled) {
            this.$LookupFileTmpDirInUse = false;
            if (!false) {
                // empty if block
            }
        }
    }

    private SmallString $getLookupFilePath() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFilePathInUse) break block3;
                this.$LookupFilePathInUse = true;
                if (true) break block2;
            }
            throw new AssertionError((Object)"already in use. Forgot to release? Or have to switch to vector-based impl?");
        }
        this.$LookupFilePath.resize(0);
        return this.$LookupFilePath;
    }

    private void $releaseLookupFilePath(SmallString Path) {
        assert (Path == this.$LookupFilePath) : "returns different instance";
        assert (this.$LookupFilePathInUse) : "releasing without get ";
        if (!$assertionsDisabled) {
            this.$LookupFilePathInUse = false;
            if (!false) {
                // empty if block
            }
        }
    }

    public FileEntry LookupFile(StringRef Filename, HeaderSearch HS, SourceLocation IncludeLoc, SmallString SearchPath, SmallString RelativePath, Module RequestingModule, ModuleMap.KnownHeader SuggestedModule, bool.ref InUserSpecifiedSystemFramework, bool.ref HasBeenMapped, SmallString MappedName) {
        SmallString TmpDir = this.$getLookupFileTmpDir();
        SmallString Path = this.$getLookupFilePath();
        FileEntry out = this.LookupFile(TmpDir, Path, Filename, HS, IncludeLoc, SearchPath, RelativePath, RequestingModule, SuggestedModule, InUserSpecifiedSystemFramework, HasBeenMapped, MappedName);
        this.$releaseLookupFileTmpDir(TmpDir);
        this.$releaseLookupFilePath(Path);
        return out;
    }

    private FileEntry LookupFile(SmallString TmpDir, SmallString Path, StringRef Filename, HeaderSearch HS, SourceLocation IncludeLoc, SmallString SearchPath, SmallString RelativePath, Module RequestingModule, ModuleMap.KnownHeader SuggestedModule, bool.ref InUserSpecifiedSystemFramework, bool.ref HasBeenMapped, SmallString MappedName) {
        FileEntry Result;
        InUserSpecifiedSystemFramework.$set(false);
        HasBeenMapped.$set(false);
        assert (TmpDir != null);
        assert (TmpDir.size() == 0);
        if (this.isNormalDir()) {
            DirectoryEntry dir = this.getDir();
            TmpDir.$assign(dir.getName(), dir.getNameLen());
            path.append((SmallString)TmpDir, (StringRef)Filename);
            if (SearchPath != null) {
                SearchPath.clear();
                SearchPath.append(dir.getName(), dir.getNameLen());
            }
            if (RelativePath != null) {
                RelativePath.clear();
                RelativePath.append(Filename);
            }
            return HS.getFileAndSuggestModule(TmpDir.$StringRef(), IncludeLoc, dir, this.isSystemHeaderDirectory(), RequestingModule, SuggestedModule);
        }
        if (this.isFramework()) {
            return this.DoFrameworkLookup(Filename, HS, SearchPath, RelativePath, RequestingModule, SuggestedModule, InUserSpecifiedSystemFramework);
        }
        assert (this.isHeaderMap()) : "Unknown directory lookup";
        HeaderMap HM = this.getHeaderMap();
        assert (Path != null);
        assert (Path.size() == 0);
        StringRef Dest = HM.lookupFilename(Filename, Path);
        if (Dest.empty()) {
            return null;
        }
        if (path.is_relative((Twine)new Twine(Dest))) {
            MappedName.clear();
            MappedName.append(Dest);
            Filename.$assignMove(new StringRef(MappedName.begin().toPointer(), MappedName.size()));
            HasBeenMapped.$set(true);
            Result = HM.LookupFile(Filename, HS.getFileMgr());
        } else {
            Result = HS.getFileMgr().getFile(Dest);
        }
        if (Result != null) {
            if (SearchPath != null) {
                char.ptr SearchPathRef = this.getName();
                SearchPath.clear();
                SearchPath.append(SearchPathRef);
            }
            if (RelativePath != null) {
                RelativePath.clear();
                RelativePath.append(Filename);
            }
        }
        return Result;
    }

    private FileEntry DoFrameworkLookup(StringRef Filename, HeaderSearch HS, SmallString SearchPath, SmallString RelativePath, Module RequestingModule, ModuleMap.KnownHeader SuggestedModule, bool.ref InUserSpecifiedSystemFramework) {
        FileManager FileMgr = HS.getFileMgr();
        int SlashPos = Filename.find((byte)47);
        if (SlashPos == StringRef.npos) {
            return null;
        }
        HeaderSearch.FrameworkCacheEntry CacheEntry = HS.LookupFrameworkCache(Filename.substr(0, SlashPos));
        DirectoryEntry frameworkDir = this.getFrameworkDir();
        if (CacheEntry.Directory != null && CacheEntry.Directory != frameworkDir) {
            return null;
        }
        SmallString FrameworkName = new SmallString(1024);
        FrameworkName.$addassign(frameworkDir.getName(), frameworkDir.getNameLen());
        if (FrameworkName.empty() || FrameworkName.back() != 47) {
            FrameworkName.push_back((byte)47);
        }
        FrameworkName.$addassign(Filename, 0, SlashPos);
        FrameworkName.$addassign(".framework/");
        if (CacheEntry.Directory == null) {
            HS.IncrementFrameworkLookupCount();
            DirectoryEntry Dir = FileMgr.getDirectory(FrameworkName.$StringRef());
            if (Dir == null) {
                return null;
            }
            CacheEntry.Directory = frameworkDir;
            if (this.getDirCharacteristic() == SrcMgr.CharacteristicKind.C_User) {
                SmallString SystemFrameworkMarker = new SmallString(FrameworkName);
                SystemFrameworkMarker.$addassign(".system_framework");
                if (fs.exists((Twine)new Twine(SystemFrameworkMarker))) {
                    CacheEntry.IsUserSpecifiedSystemFramework = true;
                }
            }
        }
        InUserSpecifiedSystemFramework.$set(CacheEntry.IsUserSpecifiedSystemFramework);
        if (RelativePath != null) {
            RelativePath.clear();
            RelativePath.append(Filename, SlashPos + 1, Filename.size());
        }
        int OrigSize = FrameworkName.size();
        FrameworkName.$addassign("Headers/");
        if (SearchPath != null) {
            SearchPath.clear();
            SearchPath.append((char.iterator)FrameworkName.begin(), (char.iterator)FrameworkName.end().$sub(1));
        }
        FrameworkName.append(Filename, SlashPos + 1, Filename.size());
        FileEntry FE = FileMgr.getFile(FrameworkName.$StringRef(), SuggestedModule == null);
        if (FE == null) {
            char.ptr Private = NativePointer.$((String)"Private");
            FrameworkName.insert(FrameworkName.begin().$add(OrigSize), (char.iterator)Private, (char.iterator)Private.$add(std.strlen((char.ptr)Private)));
            if (SearchPath != null) {
                SearchPath.insert(SearchPath.begin().$add(OrigSize), (char.iterator)Private, (char.iterator)Private.$add(std.strlen((char.ptr)Private)));
            }
            FE = FileMgr.getFile(FrameworkName.$StringRef(), SuggestedModule == null);
        }
        if (FE != null && SuggestedModule != null) {
            boolean IsSystem;
            DirectoryEntry Dir;
            DirectoryEntry dir = FE.getDir();
            StringRef FrameworkPath = new StringRef(dir.getName(), dir.getNameLen());
            boolean FoundFramework = false;
            while ((Dir = FileMgr.getDirectory(FrameworkPath)) != null) {
                if (llvm.$eq_StringRef((StringRef)path.extension((StringRef)FrameworkPath), (String)".framework")) {
                    FoundFramework = true;
                    break;
                }
                FrameworkPath.$assignMove(path.parent_path((StringRef)FrameworkPath));
                if (!FrameworkPath.empty()) continue;
                break;
            }
            boolean bl = IsSystem = this.getDirCharacteristic() != SrcMgr.CharacteristicKind.C_User;
            if (FoundFramework ? !HS.findUsableModuleForFrameworkHeader(FE, FrameworkPath, RequestingModule, SuggestedModule, IsSystem) : !HS.findUsableModuleForHeader(FE, this.getDir(), RequestingModule, SuggestedModule, IsSystem)) {
                return null;
            }
        }
        return FE;
    }

    public DirectoryLookup $assign(DirectoryLookup $Prm0) {
        this.u.$assign($Prm0.u);
        this.DirCharacteristic = $Prm0.DirCharacteristic;
        this.LookupType = $Prm0.LookupType;
        this.IsIndexHeaderMap = $Prm0.IsIndexHeaderMap;
        this.SearchedAllModuleMaps = $Prm0.SearchedAllModuleMaps;
        return this;
    }

    public DirectoryLookup $assignMove(DirectoryLookup $Prm0) {
        this.u.$assignMove($Prm0.u);
        this.DirCharacteristic = $Prm0.DirCharacteristic;
        this.LookupType = $Prm0.LookupType;
        this.IsIndexHeaderMap = $Prm0.IsIndexHeaderMap;
        this.SearchedAllModuleMaps = $Prm0.SearchedAllModuleMaps;
        return this;
    }

    public DirectoryLookup(DirectoryLookup $Prm0) {
        this.u = new Unnamed_union1($Prm0.u);
        this.DirCharacteristic = $Prm0.DirCharacteristic;
        this.LookupType = $Prm0.LookupType;
        this.IsIndexHeaderMap = $Prm0.IsIndexHeaderMap;
        this.SearchedAllModuleMaps = $Prm0.SearchedAllModuleMaps;
    }

    public DirectoryLookup(JavaDifferentiators.JD$Move _dparam, DirectoryLookup $Prm0) {
        this.u = new Unnamed_union1(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.u);
        this.DirCharacteristic = $Prm0.DirCharacteristic;
        this.LookupType = $Prm0.LookupType;
        this.IsIndexHeaderMap = $Prm0.IsIndexHeaderMap;
        this.SearchedAllModuleMaps = $Prm0.SearchedAllModuleMaps;
    }

    public DirectoryLookup clone() {
        return new DirectoryLookup(this);
    }

    public boolean $noteq(DirectoryLookup other) {
        return !this.$eq(other);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean $eq(DirectoryLookup other) {
        if (this.DirCharacteristic != other.DirCharacteristic) {
            return false;
        }
        if (this.LookupType != other.LookupType) {
            return false;
        }
        if (this.IsIndexHeaderMap != other.IsIndexHeaderMap) {
            return false;
        }
        if (this.SearchedAllModuleMaps != other.SearchedAllModuleMaps) {
            return false;
        }
        return this.u.$eq(other.u);
    }

    public String toString() {
        return "DirectoryLookup{u=" + this.u + ", DirCharacteristic=" + this.DirCharacteristic + ", LookupType=" + this.LookupType + ", IsIndexHeaderMap=" + this.IsIndexHeaderMap + ", SearchedAllModuleMaps=" + this.SearchedAllModuleMaps + "}";
    }

    private static class Unnamed_union1 {
        public DirectoryEntry Dir;
        public HeaderMap Map;

        public Unnamed_union1() {
        }

        public Unnamed_union1(Unnamed_union1 $Prm0) {
            this.Dir = $Prm0.Dir;
            this.Map = $Prm0.Map;
        }

        public Unnamed_union1(JavaDifferentiators.JD$Move _dparam, Unnamed_union1 $Prm0) {
            this.Dir = $Prm0.Dir;
            this.Map = $Prm0.Map;
        }

        public Unnamed_union1 $assign(Unnamed_union1 $Prm0) {
            this.Dir = $Prm0.Dir;
            this.Map = $Prm0.Map;
            return this;
        }

        public Unnamed_union1 $assignMove(Unnamed_union1 $Prm0) {
            this.Dir = $Prm0.Dir;
            this.Map = $Prm0.Map;
            return this;
        }

        private boolean $eq(Unnamed_union1 u) {
            return this.Map == u.Map && this.Dir == u.Dir;
        }

        public String toString() {
            return "{Dir=" + this.Dir + ", Map=" + this.Map + "}";
        }
    }

    public static final class LookupType_t
    extends Enum<LookupType_t>
    implements Native.ComparableLower {
        public static final /* enum */ LookupType_t LT_NormalDir = new LookupType_t(0);
        public static final /* enum */ LookupType_t LT_Framework = new LookupType_t(LT_NormalDir.getValue() + 1);
        public static final /* enum */ LookupType_t LT_HeaderMap = new LookupType_t(LT_Framework.getValue() + 1);
        private final int value;
        private static final /* synthetic */ LookupType_t[] $VALUES;

        public static LookupType_t[] values() {
            return (LookupType_t[])$VALUES.clone();
        }

        public static LookupType_t valueOf(String name) {
            return Enum.valueOf(LookupType_t.class, name);
        }

        public static LookupType_t valueOf(int val) {
            LookupType_t out;
            LookupType_t lookupType_t = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private LookupType_t(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((LookupType_t)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((LookupType_t)((Object)obj)).value);
        }

        static {
            $VALUES = new LookupType_t[]{LT_NormalDir, LT_Framework, LT_HeaderMap};
        }

        private static final class Values {
            private static final LookupType_t[] VALUES;
            private static final LookupType_t[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LookupType_t kind : LookupType_t.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LookupType_t[min < 0 ? 1 - min : 0];
                VALUES = new LookupType_t[max >= 0 ? 1 + max : 0];
                for (LookupType_t kind : LookupType_t.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((LookupType_t)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((LookupType_t)kind).value] = kind;
                }
            }
        }
    }
}

