/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.remote.ExceptionHandler;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public abstract class HgProgressSupport
implements Runnable,
Cancellable {
    private Cancellable delegate;
    private volatile boolean canceled;
    private ProgressHandle progressHandle = null;
    private String displayName = "";
    private String originalDisplayName = "";
    private OutputLogger logger;
    private HgURL repositoryRoot;
    private RequestProcessor.Task task;

    public HgProgressSupport() {
    }

    public HgProgressSupport(String displayName, JButton cancel) {
        this.displayName = displayName;
        if (cancel != null) {
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HgProgressSupport.this.cancel();
                }
            });
        }
    }

    public RequestProcessor.Task start(RequestProcessor rp, VCSFileProxy repositoryRoot, String displayName) {
        HgURL hgUrl = repositoryRoot != null ? new HgURL(repositoryRoot) : null;
        return this.start(rp, hgUrl, displayName);
    }

    public RequestProcessor.Task start(RequestProcessor rp, HgURL repositoryRoot, String displayName) {
        this.setDisplayName(displayName);
        this.repositoryRoot = repositoryRoot;
        this.startProgress();
        this.setProgressQueued();
        this.task = rp.post((Runnable)this);
        this.task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                HgProgressSupport.this.delegate = null;
            }
        });
        return this.task;
    }

    public RequestProcessor.Task start(RequestProcessor rp) {
        this.startProgress();
        this.task = rp.post((Runnable)this);
        return this.task;
    }

    public JComponent getProgressComponent() {
        return ProgressHandleFactory.createProgressComponent((ProgressHandle)this.getProgressHandle());
    }

    public void setRepositoryRoot(HgURL repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
        this.logger = null;
    }

    protected HgURL getRepositoryRoot() {
        return this.repositoryRoot;
    }

    @Override
    public void run() {
        this.setProgress();
        this.performIntern();
    }

    protected void performIntern() {
        try {
            HgProgressSupport.log("Start - " + this.displayName);
            if (!this.canceled) {
                this.perform();
            }
        }
        finally {
            HgProgressSupport.log("End - " + this.displayName);
            this.finnishProgress();
            this.getLogger().closeLog();
        }
    }

    protected abstract void perform();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean cancel() {
        if (this.delegate != null && !this.delegate.cancel()) {
            return false;
        }
        if (this.canceled) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        Mercurial.getInstance().clearRequestProcessor(this.repositoryRoot);
        this.finnishProgress();
        this.canceled = true;
        return true;
    }

    public void setCancellableDelegate(Cancellable cancellable) {
        this.delegate = cancellable;
    }

    public void setDisplayName(String displayName) {
        if (this.originalDisplayName.equals("")) {
            this.originalDisplayName = displayName;
        }
        this.logChangedDisplayName(this.displayName, displayName);
        this.displayName = displayName;
        this.setProgress();
    }

    private void setProgressQueued() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(NbBundle.getMessage(HgProgressSupport.class, (String)"LBL_Queued", (Object)this.displayName));
        }
    }

    private void setProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.displayName);
        }
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected ProgressHandle getProgressHandle() {
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this, (Action)this.getLogger().getOpenOutputAction());
        }
        return this.progressHandle;
    }

    protected void startProgress() {
        this.getProgressHandle().start();
    }

    protected void finnishProgress() {
        this.getProgressHandle().finish();
    }

    public OutputLogger getLogger() {
        if (this.logger == null) {
            String loggerId = this.repositoryRoot != null ? this.repositoryRoot.toHgCommandUrlStringWithoutUserInfo() : null;
            this.logger = Mercurial.getInstance().getLogger(loggerId);
        }
        return this.logger;
    }

    public void annotate(HgException ex) {
        ExceptionHandler eh = new ExceptionHandler(ex);
        if (this.isCanceled()) {
            eh.notifyException(false);
        } else {
            eh.notifyException();
        }
    }

    private static void log(String msg) {
        HgUtils.logT9Y(msg);
        Mercurial.LOG.log(Level.FINE, msg);
    }

    private void logChangedDisplayName(String thisDisplayName, String displayName) {
        if (thisDisplayName != null && !thisDisplayName.equals(displayName) && !thisDisplayName.equals("")) {
            HgProgressSupport.log("End - " + thisDisplayName);
            HgProgressSupport.log("Start - " + displayName);
        }
    }
}

