/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionInstantiation;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.CsmFinderFactory;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.utils.MutableObject;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.CharSequences;
import org.openide.util.Pair;

public class CsmContextUtilities {
    private static final boolean DEBUG = Boolean.getBoolean("csm.utilities.trace");
    private static final int FILE_LOCAL_MACROS = 0;
    private static final int FILE_PROJECT_LOCAL_MACROS = 1;
    private static final int FILE_LIB_LOCAL_MACROS = 2;
    private static final int PROJECT_MACROS = 3;
    private static final int LIB_MACROS = 4;
    private static final Callable<CsmCacheMap> CACHE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("CsmContextUtilities Cache", 0, 16);
        }
    };

    private CsmContextUtilities() {
    }

    public static List<CsmDeclaration> findLocalDeclarations(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findLocalDeclarations(context, strPrefix, match, caseSensitive, true, false);
    }

    public static List<CsmDeclaration> findFileLocalVariables(CsmContext context) {
        return CsmContextUtilities.findFileLocalVariables(context, "", false, false);
    }

    public static List<CsmDeclaration> findFileLocalVariables(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findLocalDeclarations(context, strPrefix, match, caseSensitive, true, false);
    }

    public static List<CsmDeclaration> findFunctionLocalVariables(CsmContext context) {
        List<CsmDeclaration> decls = CsmContextUtilities.findFunctionLocalDeclarations(context, "", false, false);
        ArrayList<CsmDeclaration> out = new ArrayList<CsmDeclaration>(decls.size());
        for (CsmDeclaration elem : decls) {
            if (!CsmKindUtilities.isVariable((CsmObject)elem)) continue;
            out.add(elem);
        }
        return out;
    }

    public static List<CsmDeclaration> findFunctionLocalDeclarations(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        List<CsmDeclaration> decls = CsmContextUtilities.findLocalDeclarations(context, strPrefix, match, caseSensitive, false, true);
        return decls;
    }

    public static List<CsmMacro> findFileLocalMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 0);
    }

    public static List<CsmMacro> findFileIncludedProjectMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 1);
    }

    public static List<CsmMacro> findFileIncludedLibMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 2);
    }

    public static List<CsmMacro> findProjectMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 3);
    }

    public static List<CsmMacro> findLibMacros(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        return CsmContextUtilities.findMacros(context, strPrefix, match, caseSensitive, 4);
    }

    private static List<CsmMacro> findMacros(CsmContext context, CharSequence strPrefix, boolean match, boolean caseSensitive, int kind) {
        strPrefix = CharSequences.create((CharSequence)strPrefix);
        ArrayList<CsmMacro> res = new ArrayList<CsmMacro>();
        Iterator<CsmContext.CsmContextEntry> itContext = context.iterator();
        while (itContext.hasNext()) {
            CsmContext.CsmContextEntry entry = itContext.next();
            CsmScope scope = entry.getScope();
            if (!CsmKindUtilities.isFile((CsmObject)scope)) continue;
            CsmFile file = (CsmFile)scope;
            switch (kind) {
                case 0: {
                    CsmContextUtilities.getFileLocalMacros(file, res, new HashSet<CharSequence>(), strPrefix, match, caseSensitive);
                    break;
                }
                case 1: {
                    CsmContextUtilities.gatherProjectIncludedMacros(file, res, false, strPrefix, match, caseSensitive);
                    break;
                }
                case 2: {
                    CsmContextUtilities.gatherLibIncludedMacros(file, res, false, strPrefix, match, caseSensitive);
                    break;
                }
                case 3: {
                    CsmContextUtilities.gatherProjectIncludedMacros(file, res, true, strPrefix, match, caseSensitive);
                    break;
                }
                case 4: {
                    CsmContextUtilities.gatherLibIncludedMacros(file, res, true, strPrefix, match, caseSensitive);
                }
            }
        }
        return res;
    }

    private static void getFileLocalMacros(CsmFile file, List<CsmMacro> res, Set<CharSequence> alredyInList, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(strPrefix, match, caseSensitive, false);
        Iterator itFile = CsmSelect.getMacros((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (itFile.hasNext()) {
            CsmMacro macro = (CsmMacro)itFile.next();
            CharSequence name = macro.getName();
            if (alredyInList.contains(name) || !CsmSortUtilities.matchName((CharSequence)name, (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive)) continue;
            res.add(macro);
            alredyInList.add(name);
        }
    }

    private static void gatherProjectIncludedMacros(CsmFile file, List<CsmMacro> res, boolean all, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        CsmProject prj = file.getProject();
        if (!all) {
            CsmContextUtilities.gatherIncludeMacros(file, prj, true, new HashSet<CsmFile>(), new HashSet<CharSequence>(), res, strPrefix, match, caseSensitive);
        } else {
            HashSet<CharSequence> alredyInList = new HashSet<CharSequence>();
            Iterator i = prj.getHeaderFiles().iterator();
            while (i.hasNext()) {
                CsmContextUtilities.getFileLocalMacros((CsmFile)i.next(), res, alredyInList, strPrefix, match, caseSensitive);
            }
        }
    }

    private static void gatherLibIncludedMacros(CsmFile file, List<CsmMacro> res, boolean all, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        CsmProject prj = file.getProject();
        if (!all) {
            CsmContextUtilities.gatherIncludeMacros(file, prj, false, new HashSet<CsmFile>(), new HashSet<CharSequence>(), res, strPrefix, match, caseSensitive);
        } else {
            HashSet<CharSequence> alredyInList = new HashSet<CharSequence>();
            for (CsmProject lib : prj.getLibraries()) {
                Iterator i = lib.getHeaderFiles().iterator();
                while (i.hasNext()) {
                    CsmContextUtilities.getFileLocalMacros((CsmFile)i.next(), res, alredyInList, strPrefix, match, caseSensitive);
                }
            }
        }
    }

    private static void gatherIncludeMacros(CsmFile file, CsmProject prj, boolean own, Set<CsmFile> visitedFiles, Set<CharSequence> alredyInList, List<CsmMacro> res, CharSequence strPrefix, boolean match, boolean caseSensitive) {
        if (visitedFiles.contains(file)) {
            return;
        }
        visitedFiles.add(file);
        for (CsmInclude inc : file.getIncludes()) {
            CsmFile incFile = inc.getIncludeFile();
            if (incFile == null) continue;
            if (own) {
                if (incFile.getProject() != prj) continue;
                CsmContextUtilities.getFileLocalMacros(incFile, res, alredyInList, strPrefix, match, caseSensitive);
                CsmContextUtilities.gatherIncludeMacros(incFile, prj, own, visitedFiles, alredyInList, res, strPrefix, match, caseSensitive);
                continue;
            }
            if (incFile.getProject() != prj) {
                CsmContextUtilities.getFileLocalMacros(incFile, res, alredyInList, strPrefix, match, caseSensitive);
            }
            CsmContextUtilities.gatherIncludeMacros(incFile, prj, own, visitedFiles, alredyInList, res, strPrefix, match, caseSensitive);
        }
    }

    protected static List<CsmDeclaration> findLocalDeclarations(CsmContext context, String strPrefix, boolean match, boolean caseSensitive, boolean includeFileLocal, boolean includeFunctionVars) {
        boolean incAny;
        List<CsmDeclaration> res = new ArrayList<CsmDeclaration>();
        boolean bl = incAny = includeFileLocal || includeFunctionVars;
        assert (incAny) : "at least one must be true";
        boolean incAll = includeFileLocal && includeFunctionVars;
        Iterator<CsmContext.CsmContextEntry> it = context.iterator();
        while (it.hasNext() && incAny) {
            CsmContext.CsmContextEntry entry = it.next();
            boolean include = incAll;
            if (!include) {
                if (!includeFileLocal) {
                    assert (includeFunctionVars);
                    if (CsmKindUtilities.isFunction((CsmObject)entry.getScope())) {
                        include = true;
                        incAll = true;
                    }
                    if (CsmKindUtilities.isFunctionExplicitInstantiation((CsmObject)entry.getScope())) {
                        include = true;
                        incAll = true;
                    }
                    if (CsmKindUtilities.isFunctionPointerType((CsmObject)entry.getScope())) {
                        include = true;
                        incAll = true;
                    }
                } else if (!includeFunctionVars) {
                    assert (includeFileLocal);
                    if (CsmKindUtilities.isFunction((CsmObject)entry.getScope()) || CsmKindUtilities.isClassifier((CsmObject)entry.getScope())) {
                        include = false;
                        incAny = false;
                        incAll = false;
                    } else {
                        include = true;
                    }
                }
            }
            if (!include) continue;
            res = CsmContextUtilities.addEntryDeclarations(entry, res, context, strPrefix, match, caseSensitive);
        }
        return res;
    }

    private static List<CsmDeclaration> addEntryDeclarations(CsmContext.CsmContextEntry entry, List<CsmDeclaration> decls, CsmContext fullContext, String strPrefix, boolean match, boolean caseSensitive) {
        List<CsmDeclaration> newList = CsmContextUtilities.findEntryDeclarations(entry, fullContext, strPrefix, match, caseSensitive);
        return CsmContextUtilities.mergeDeclarations(decls, newList);
    }

    private static List<CsmDeclaration> findEntryDeclarations(CsmContext.CsmContextEntry entry, CsmContext fullContext, String strPrefix, boolean match, boolean caseSensitive) {
        CsmFunctionParameterList paramList;
        CsmScopeElement scpElem;
        assert (entry != null) : "can't work on null entries";
        CsmScope scope = entry.getScope();
        int offsetInScope = entry.getOffset();
        ArrayList<CsmDeclaration> resList = new ArrayList<CsmDeclaration>();
        boolean stoppedBeforeFirst = true;
        Iterator it = scope.getScopeElements().iterator();
        while (it.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, scpElem = (CsmScopeElement)it.next(), fullContext)) {
            stoppedBeforeFirst = false;
            List<CsmDeclaration> declList = CsmContextUtilities.extractDeclarations(fullContext, scpElem, strPrefix, match, caseSensitive);
            resList.addAll(declList);
        }
        if (stoppedBeforeFirst && CsmKindUtilities.isFunction((CsmObject)scope) && CsmOffsetUtilities.isInObject((CsmObject)(paramList = ((CsmFunction)scope).getParameterList()), offsetInScope)) {
            for (CsmParameter csmParameter : paramList.getParameters()) {
                List<CsmDeclaration> declList = CsmContextUtilities.extractDeclarations(fullContext, (CsmScopeElement)csmParameter, strPrefix, match, caseSensitive);
                resList.addAll(declList);
            }
        }
        return resList;
    }

    public static CsmSelect.CsmFilter createFilter(CsmDeclaration.Kind[] kinds, String strPrefix, boolean match, boolean caseSensitive, boolean returnUnnamedMembers) {
        CsmSelect.CsmFilter filter = null;
        CsmSelect.CsmFilterBuilder builder = CsmSelect.getFilterBuilder();
        if (kinds != null && strPrefix != null) {
            filter = builder.createCompoundFilter(builder.createKindFilter(kinds), builder.createNameFilter((CharSequence)strPrefix, match, caseSensitive, returnUnnamedMembers));
        } else if (kinds != null) {
            filter = builder.createKindFilter(kinds);
        } else if (strPrefix != null) {
            filter = builder.createNameFilter((CharSequence)strPrefix, match, caseSensitive, returnUnnamedMembers);
        }
        return filter;
    }

    public static List<CsmEnumerator> findFileLocalEnumerators(CsmContext context, String strPrefix, boolean match, boolean caseSensitive) {
        ArrayList<CsmEnumerator> res = new ArrayList<CsmEnumerator>();
        Iterator<CsmContext.CsmContextEntry> itContext = context.iterator();
        while (itContext.hasNext()) {
            CsmDeclaration decl;
            CsmContext.CsmContextEntry entry = itContext.next();
            CsmScope scope = entry.getScope();
            int offsetInScope = entry.getOffset();
            if (!CsmKindUtilities.isFile((CsmObject)scope)) continue;
            CsmFile file = (CsmFile)scope;
            CsmSelect.CsmFilter fileFilter = CsmContextUtilities.createFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT}, null, match, caseSensitive, true);
            Iterator itFile = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)fileFilter);
            while (itFile.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, (CsmScopeElement)(decl = (CsmDeclaration)itFile.next()), context)) {
                CsmMember member;
                if (CsmKindUtilities.isEnum((CsmObject)decl)) {
                    CsmEnum en = (CsmEnum)decl;
                    if (context.isCpp() && (en.isStronglyTyped() || en.getName().length() != 0)) continue;
                    CsmContextUtilities.addEnumerators(res, en, strPrefix, match, caseSensitive);
                    continue;
                }
                if (CsmKindUtilities.isNamespaceDefinition((CsmObject)decl) && decl.getName().length() == 0) {
                    CsmDeclaration nsDecl;
                    CsmNamespaceDefinition ns = (CsmNamespaceDefinition)decl;
                    CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM}, null, match, caseSensitive, true);
                    Iterator i = CsmSelect.getDeclarations((CsmNamespaceDefinition)ns, (CsmSelect.CsmFilter)filter);
                    while (i.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, (CsmScopeElement)(nsDecl = (CsmDeclaration)i.next()), context)) {
                        CsmEnum en;
                        if (!CsmKindUtilities.isEnum((CsmObject)nsDecl) || (en = (CsmEnum)nsDecl).isStronglyTyped() || en.getName().length() != 0) continue;
                        CsmContextUtilities.addEnumerators(res, en, strPrefix, match, caseSensitive);
                    }
                    continue;
                }
                if (!CsmKindUtilities.isClass((CsmObject)decl) || context.isCpp() && decl.getName().length() != 0) continue;
                CsmClass cls = (CsmClass)decl;
                Iterator iterator = cls.getMembers().iterator();
                while (iterator.hasNext() && !CsmContextUtilities.canBreak(offsetInScope, (CsmScopeElement)(member = (CsmMember)iterator.next()), context)) {
                    if (!CsmKindUtilities.isEnum((CsmObject)member)) continue;
                    CsmEnum en = (CsmEnum)member;
                    if (context.isCpp() && (en.isStronglyTyped() || en.getName().length() != 0)) continue;
                    CsmContextUtilities.addEnumerators(res, en, strPrefix, match, caseSensitive);
                }
            }
        }
        return res;
    }

    private static void addEnumerators(List resList, CsmEnum en, String strPrefix, boolean match, boolean caseSensitive) {
        for (CsmNamedElement scpElem : en.getEnumerators()) {
            if (!CsmSortUtilities.matchName((CharSequence)scpElem.getName(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive)) continue;
            resList.add(scpElem);
        }
    }

    private static boolean canBreak(int offsetInScope, CsmScopeElement elem, CsmContext fullContext) {
        if (elem == null) {
            return false;
        }
        if (offsetInScope == -1) {
            return CsmContextUtilities.isInContext(fullContext, (CsmObject)elem);
        }
        if (CsmKindUtilities.isOffsetable((Object)elem)) {
            return ((CsmOffsetable)elem).getStartOffset() >= offsetInScope || CsmContextUtilities.isInContext(fullContext, (CsmObject)elem);
        }
        return CsmContextUtilities.isInContext(fullContext, (CsmObject)elem);
    }

    private static List<CsmDeclaration> mergeDeclarations(List<CsmDeclaration> prevScopeDecls, List<CsmDeclaration> newScopeDecls) {
        ArrayList<CsmDeclaration> res = new ArrayList<CsmDeclaration>();
        if (newScopeDecls != null && newScopeDecls.size() > 0) {
            res.addAll(newScopeDecls);
        }
        if (prevScopeDecls != null && prevScopeDecls.size() > 0) {
            res.addAll(prevScopeDecls);
        }
        return res;
    }

    public static void updateContextObject(CsmObject obj, int offset, CsmContext context) {
        if (context != null && obj != null) {
            context.setLastObject(obj);
        }
    }

    public static void updateContext(CsmObject obj, int offset, CsmContext context) {
        if (context != null) {
            if (CsmKindUtilities.isScope((CsmObject)obj)) {
                context.add((CsmScope)obj, offset);
            } else if (CsmKindUtilities.isOffsetable((Object)obj)) {
                CsmContextUtilities.updateContextObject(obj, offset, context);
            }
        }
    }

    private static boolean isInContext(CsmContext context, CsmObject obj) {
        ListIterator<CsmContext.CsmContextEntry> it = context.reverseIterator();
        while (it.hasPrevious()) {
            CsmContext.CsmContextEntry elem = it.previous();
            if (!obj.equals(elem.getScope())) continue;
            return true;
        }
        return false;
    }

    private static CsmClassifier getTypeClassifier(CsmContext fullContext, CsmType type) {
        return CsmBaseUtilities.getClassifier((CsmType)type, (CsmFile)fullContext.getFile(), (int)fullContext.getOffset(), (boolean)true);
    }

    private static List<CsmDeclaration> extractDeclarations(CsmContext fullContext, CsmScopeElement scpElem, String strPrefix, boolean match, boolean caseSensitive) {
        ArrayList<CsmDeclaration> list;
        block6: {
            CsmStatement.Kind kind;
            block5: {
                list = new ArrayList<CsmDeclaration>();
                if (!CsmKindUtilities.isDeclaration((CsmObject)scpElem)) break block5;
                if (!CsmSortUtilities.matchName((CharSequence)((CsmNamedElement)scpElem).getName(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive)) break block6;
                boolean add = true;
                if (CsmKindUtilities.isParamVariable((CsmObject)scpElem)) {
                    boolean bl = add = !((CsmParameter)scpElem).isVarArgs();
                }
                if (!add) break block6;
                list.add((CsmDeclaration)scpElem);
                break block6;
            }
            if (CsmKindUtilities.isStatement((CsmObject)scpElem) && (kind = ((CsmStatement)scpElem).getKind()) == CsmStatement.Kind.DECLARATION) {
                List decls = ((CsmDeclarationStatement)scpElem).getDeclarators();
                List listByName = CsmSortUtilities.filterList((Collection)decls, (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive);
                list.addAll(listByName);
                for (CsmDeclaration elem : decls) {
                    CsmType type;
                    CsmClassifier classifier;
                    if ((CsmKindUtilities.isTypedef((CsmObject)elem) || CsmKindUtilities.isTypeAlias((CsmObject)elem)) && CsmOffsetUtilities.isInObject((CsmObject)elem, (CsmObject)(classifier = CsmContextUtilities.getTypeClassifier(fullContext, type = ((CsmTypedef)elem).getType()))) && !CsmOffsetUtilities.sameOffsets((CsmObject)elem, (CsmObject)classifier)) {
                        elem = classifier;
                    }
                    if (CsmKindUtilities.isEnum((CsmObject)elem)) {
                        listByName = CsmSortUtilities.filterList((Collection)((CsmEnum)elem).getEnumerators(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive);
                        list.addAll(listByName);
                        continue;
                    }
                    if (!CsmKindUtilities.isUnion((CsmObject)elem) || ((CsmClass)elem).getName().length() != 0) continue;
                    listByName = CsmSortUtilities.filterList((Collection)((CsmClass)elem).getMembers(), (CharSequence)strPrefix, (boolean)match, (boolean)caseSensitive);
                    list.addAll(listByName);
                }
            }
        }
        return list;
    }

    public static CsmClass getClass(CsmContext context, boolean checkFunDefition, boolean inScope) {
        CsmVariable decl;
        CsmObject last;
        CsmVariable var;
        CsmClassifier classifier;
        CsmClass clazz = null;
        if (CsmKindUtilities.isVariable((CsmObject)context.getLastObject()) && CsmContextUtilities.isInInitializerList(context, context.getOffset()) && (classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)(var = (CsmVariable)context.getLastObject()).getType().getClassifier(), (CsmFile)var.getContainingFile())) != null) {
            FileObject fObj = var.getContainingFile().getFileObject();
            CsmFinder finder = fObj != null ? CsmFinderFactory.getDefault().getFinder(fObj) : null;
            clazz = CsmContextUtilities.getContextClassInInitializer(var, classifier, context.getOffset(), finder);
        }
        if (clazz == null) {
            CsmScope enumScope = null;
            for (int i = context.size() - 1; 0 <= i; --i) {
                CsmScope scope = context.get(i).getScope();
                if (CsmKindUtilities.isEnum((CsmObject)scope)) {
                    enumScope = ((CsmEnum)scope).getScope();
                }
                if (!CsmKindUtilities.isClass((CsmObject)scope) || inScope && !CsmOffsetUtilities.isInClassScope((CsmClass)scope, context.getOffset())) continue;
                clazz = (CsmClass)scope;
                break;
            }
            if (CsmKindUtilities.isClass(enumScope)) {
                clazz = (CsmClass)enumScope;
            }
        }
        if (clazz == null && checkFunDefition) {
            CsmFunction fun = CsmContextUtilities.getFunction(context, false);
            CsmClass csmClass = clazz = fun == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
        }
        if (clazz == null && CsmKindUtilities.isVariableDefinition((CsmObject)(last = context.getLastObject())) && CsmKindUtilities.isClassMember((CsmObject)(decl = ((CsmVariableDefinition)last).getDeclaration()))) {
            clazz = ((CsmMember)decl).getContainingClass();
        }
        return clazz;
    }

    public static CsmClass getContextClassInInitializer(CsmVariable var, CsmClassifier varCls, int offset, CsmFinder finder) {
        CsmExpression expression = var.getInitialValue();
        if (expression != null) {
            boolean[] found;
            ObjectKey tsKey;
            CsmClass result = null;
            CsmCacheMap cache = (CsmCacheMap)CsmCacheManager.getClientCache(CsmContextUtilities.class, CACHE_INITIALIZER);
            ContextClassInitializerData data = (ContextClassInitializerData)CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)(tsKey = new ObjectKey(var)), (boolean[])(found = new boolean[]{false}));
            if (data != null || !found[0]) {
                TokenSequence cppts;
                TokenSequence tokenSequence = cppts = data != null ? data.cppts : null;
                if (cppts == null) {
                    CharSequence expressionText = expression.getText();
                    if (!CsmContextUtilities.fastCheckCanBeInnerContext(expressionText)) {
                        return null;
                    }
                    if (!CsmContextUtilities.fastCheckCanBeCompoundLiteral(expressionText) && !CsmKindUtilities.isClass((CsmObject)varCls)) {
                        return null;
                    }
                    TokenHierarchy hi = TokenHierarchy.create((CharSequence)expressionText, (Language)CppTokenId.languageCpp());
                    List tsList = hi.embeddedTokenSequences(expression.getEndOffset() - expression.getStartOffset(), true);
                    for (int i = tsList.size() - 1; i >= 0; --i) {
                        TokenSequence uts;
                        TokenSequence ts = (TokenSequence)tsList.get(i);
                        Language lang = ts.languagePath().innerLanguage();
                        if (!CndLexerUtilities.isCppLanguage((Language)lang, (boolean)false)) continue;
                        cppts = uts = ts;
                    }
                }
                if (cppts != null) {
                    List<Object> cachedPathSequence = data != null ? data.lastPathSequence : Collections.emptyList();
                    ListIterator<Object> cachedPathIter = !cachedPathSequence.isEmpty() ? cachedPathSequence.listIterator(cachedPathSequence.size()) : cachedPathSequence.listIterator();
                    CsmClass contextClass = CsmKindUtilities.isClass((CsmObject)varCls) ? (CsmClass)varCls : null;
                    int contextArrayDepth = var.getType().getArrayDepth();
                    ArrayList<InitPathItem> pathSequence = new ArrayList<InitPathItem>();
                    cppts.move(offset - expression.getStartOffset());
                    cppts.movePrevious();
                    if (CsmContextUtilities.checkValidInitializerIdent(cppts) || cppts.token() != null && !CppTokenId.IDENTIFIER.equals((Object)cppts.token().id())) {
                        boolean finishedSuccessfully;
                        MutableObject shouldPathsBeMerged = new MutableObject((Object)false);
                        MutableObject skipped = new MutableObject((Object)0);
                        boolean foundCompoundLiteral = false;
                        for (boolean foundPosition = true; foundPosition && !((Boolean)shouldPathsBeMerged.value).booleanValue() && !foundCompoundLiteral; foundPosition |= CsmContextUtilities.findUpperInitializer((TokenSequence<TokenId>)cppts, cachedPathIter, (MutableObject<Integer>)skipped, (MutableObject<Boolean>)shouldPathsBeMerged)) {
                            foundPosition = CsmContextUtilities.findInitializerStart((TokenSequence<TokenId>)cppts);
                            int startOffset = cppts.offset();
                            Token<TokenId> startIdent = CsmContextUtilities.getInitializerIdentToken((TokenSequence<TokenId>)cppts);
                            if (!((Boolean)shouldPathsBeMerged.value).booleanValue()) continue;
                            CsmContextUtilities.mergePaths(pathSequence, cachedPathIter, startIdent, (Integer)skipped.value, startOffset);
                        }
                        boolean bl = finishedSuccessfully = (Boolean)shouldPathsBeMerged.value != false || !cppts.movePrevious() || foundCompoundLiteral;
                        if (finishedSuccessfully && !pathSequence.isEmpty()) {
                            cachedPathSequence = pathSequence;
                            result = CsmContextUtilities.resolveInitializerContext(pathSequence, contextClass, contextArrayDepth, var, finder);
                        }
                    }
                    if (cache != null) {
                        cache.put((Object)tsKey, CsmCacheMap.toValue((Object)new ContextClassInitializerData((TokenSequence<TokenId>)cppts, cachedPathSequence), (long)Integer.MAX_VALUE));
                    }
                }
            }
            return result;
        }
        return null;
    }

    private static boolean fastCheckCanBeInnerContext(CharSequence expression) {
        return expression != null && CharSequenceUtils.indexOf((CharSequence)expression, (char)'{') != -1;
    }

    private static boolean fastCheckCanBeCompoundLiteral(CharSequence expression) {
        return expression != null && CharSequenceUtils.indexOf((CharSequence)expression, (char)'(') != -1;
    }

    private static boolean canMergePaths(ListIterator<InitPathItem> lastPathIter, int currentOffset) {
        if (lastPathIter.hasPrevious()) {
            InitPathItem lastPathItem = lastPathIter.previous();
            while (lastPathItem != null && lastPathItem.offset >= currentOffset) {
                if (lastPathItem.offset == currentOffset) {
                    lastPathIter.next();
                    return true;
                }
                if (lastPathIter.hasPrevious()) {
                    lastPathItem = lastPathIter.previous();
                    continue;
                }
                lastPathItem = null;
            }
            if (lastPathItem != null) {
                lastPathIter.next();
            }
        }
        return false;
    }

    private static void mergePaths(List<InitPathItem> pathSequence, ListIterator<InitPathItem> lastPathIter, Token<TokenId> ident, int skipped, int offset) {
        InitPathItem lastPathItem = lastPathIter.previous();
        pathSequence.add(0, new InitPathItem(ident, lastPathItem.compoundLiteral, lastPathItem.position + skipped, offset));
        while (lastPathIter.hasPrevious()) {
            lastPathItem = lastPathIter.previous();
            pathSequence.add(0, lastPathItem);
        }
    }

    private static boolean findInitializerStart(TokenSequence<TokenId> cppts) {
        int level = 0;
        boolean moved = false;
        do {
            if (CppTokenId.LBRACE.equals((Object)cppts.token().id())) {
                --level;
                continue;
            }
            if (CppTokenId.RBRACE.equals((Object)cppts.token().id())) {
                ++level;
                continue;
            }
            if (CppTokenId.LPAREN.equals((Object)cppts.token().id())) {
                --level;
                continue;
            }
            if (CppTokenId.RPAREN.equals((Object)cppts.token().id())) {
                ++level;
                continue;
            }
            if (CppTokenId.LBRACKET.equals((Object)cppts.token().id())) {
                --level;
                continue;
            }
            if (CppTokenId.RBRACKET.equals((Object)cppts.token().id())) {
                ++level;
                continue;
            }
            if (CppTokenId.COMMA.equals((Object)cppts.token().id()) && level == 0) break;
        } while (level >= 0 && (moved = cppts.movePrevious()));
        return moved && cppts.token() != null && (CppTokenId.LBRACE.equals((Object)cppts.token().id()) || CppTokenId.COMMA.equals((Object)cppts.token().id()));
    }

    private static boolean findUpperInitializer(TokenSequence<TokenId> cppts, ListIterator<InitPathItem> lastPathIter, MutableObject<Integer> skippedHolder, MutableObject<Boolean> shouldPathsBeMerged) {
        int level = 0;
        int skipped = 0;
        do {
            if (level == 0 && CsmContextUtilities.canMergePaths(lastPathIter, cppts.offset())) {
                skippedHolder.value = skipped;
                shouldPathsBeMerged.value = true;
                return false;
            }
            if (CppTokenId.LBRACE.equals((Object)cppts.token().id())) {
                --level;
                continue;
            }
            if (CppTokenId.RBRACE.equals((Object)cppts.token().id())) {
                ++level;
                continue;
            }
            if (CppTokenId.LPAREN.equals((Object)cppts.token().id())) {
                --level;
                continue;
            }
            if (CppTokenId.RPAREN.equals((Object)cppts.token().id())) {
                ++level;
                continue;
            }
            if (CppTokenId.LBRACKET.equals((Object)cppts.token().id())) {
                --level;
                continue;
            }
            if (CppTokenId.RBRACKET.equals((Object)cppts.token().id())) {
                ++level;
                continue;
            }
            if (!CppTokenId.COMMA.equals((Object)cppts.token().id()) || level != 0) continue;
            ++skipped;
        } while (level >= 0 && cppts.movePrevious());
        skippedHolder.value = skipped;
        if (level < 0) {
            return cppts.token() != null && CppTokenId.LBRACE.equals((Object)cppts.token().id()) && cppts.movePrevious();
        }
        return false;
    }

    private static Token<TokenId> getInitializerIdentToken(TokenSequence<TokenId> cppts) {
        int index = cppts.index();
        Token ident = null;
        CsmContextUtilities.findToken(cppts, false, false, Arrays.asList(CppTokenId.IDENTIFIER), new TokenId[]{CppTokenId.WHITESPACE, CppTokenId.NEW_LINE, CppTokenId.LINE_COMMENT, CppTokenId.BLOCK_COMMENT, CppTokenId.DOT});
        if (CsmContextUtilities.checkValidInitializerIdent(cppts)) {
            ident = cppts.token();
        }
        cppts.moveIndex(index);
        cppts.moveNext();
        return ident;
    }

    private static Pair<String, Integer> getInitializerCompoundLiteral(TokenSequence<TokenId> cppts) {
        int index = cppts.index();
        if (cppts.token() != null && cppts.token().id() == CppTokenId.COMMA) {
            return null;
        }
        Token<TokenId> rParen = cppts.token() != null && cppts.token().id() == CppTokenId.RPAREN ? cppts.token() : CsmContextUtilities.findToken(cppts, true, false, Arrays.asList(CppTokenId.RPAREN), new TokenId[]{CppTokenId.WHITESPACE, CppTokenId.NEW_LINE, CppTokenId.LINE_COMMENT, CppTokenId.BLOCK_COMMENT});
        if (rParen != null) {
            int arrayDepth = 0;
            LinkedList<Token> nameTokens = new LinkedList<Token>();
            int level = 1;
            while (level > 0 && cppts.movePrevious() && cppts.token() != null) {
                if (CppTokenId.LBRACE.equals((Object)cppts.token().id())) {
                    --level;
                } else if (CppTokenId.RBRACE.equals((Object)cppts.token().id())) {
                    ++level;
                } else if (CppTokenId.LPAREN.equals((Object)cppts.token().id())) {
                    --level;
                } else if (CppTokenId.RPAREN.equals((Object)cppts.token().id())) {
                    ++level;
                } else if (CppTokenId.LBRACKET.equals((Object)cppts.token().id())) {
                    if (--level == 1) {
                        ++arrayDepth;
                    }
                } else if (CppTokenId.RBRACKET.equals((Object)cppts.token().id())) {
                    ++level;
                }
                if (level <= 0 || !CsmContextUtilities.isTokenOneOf((Token<TokenId>)cppts.token(), new TokenId[]{CppTokenId.IDENTIFIER, CppTokenId.SCOPE})) continue;
                nameTokens.add(0, cppts.token());
            }
            if (!nameTokens.isEmpty() && CsmContextUtilities.isTokenOneOf((Token<TokenId>)cppts.token(), new TokenId[]{CppTokenId.LPAREN})) {
                StringBuilder sb = new StringBuilder();
                for (Token nameToken : nameTokens) {
                    sb.append(nameToken.text());
                }
                return Pair.of((Object)sb.toString(), (Object)arrayDepth);
            }
        }
        cppts.moveIndex(index);
        cppts.moveNext();
        return null;
    }

    private static boolean checkValidInitializerIdent(TokenSequence<TokenId> cppts) {
        if (cppts.token() != null && CppTokenId.IDENTIFIER.equals((Object)cppts.token().id())) {
            boolean leftSeparatorFound = CsmContextUtilities.findToken(cppts, true, true, Arrays.asList(CppTokenId.LBRACE, CppTokenId.COMMA), new TokenId[]{CppTokenId.WHITESPACE, CppTokenId.NEW_LINE, CppTokenId.LINE_COMMENT, CppTokenId.BLOCK_COMMENT, CppTokenId.DOT}) != null;
            boolean rightSeparatorFound = CsmContextUtilities.findToken(cppts, false, true, Arrays.asList(CppTokenId.COLON, CppTokenId.EQ), new TokenId[]{CppTokenId.WHITESPACE, CppTokenId.NEW_LINE, CppTokenId.LINE_COMMENT, CppTokenId.BLOCK_COMMENT}) != null;
            return leftSeparatorFound && rightSeparatorFound;
        }
        return false;
    }

    private static CsmClass resolveInitializerContext(List<InitPathItem> pathSequence, CsmClass initialContext, int initialArrayDepth, CsmVariable var, CsmFinder finder) {
        int index;
        CsmClass context = initialContext;
        int contextArrayDepth = initialArrayDepth;
        ListIterator<InitPathItem> itemIter = pathSequence.listIterator(index);
        for (index = CsmContextUtilities.getStartIndexToResolveInitializerContext(pathSequence); index < pathSequence.size(); ++index) {
            CsmType fieldType;
            InitPathItem item = (InitPathItem)itemIter.next();
            if (item.compoundLiteral != null) {
                if (finder != null) {
                    CsmClassifier castedCls = CompletionSupport.getClassFromName(finder, (String)item.compoundLiteral.first(), true);
                    if (CsmKindUtilities.isClass((CsmObject)(castedCls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)castedCls, (CsmFile)var.getContainingFile())))) {
                        context = (CsmClass)castedCls;
                        contextArrayDepth = (Integer)item.compoundLiteral.second();
                    } else {
                        context = null;
                    }
                } else {
                    context = null;
                }
            }
            if (context == null) break;
            if (index >= pathSequence.size() - 1) continue;
            CsmClassifier classifier = null;
            int arrayDepth = 0;
            if (item.isIdentBased()) {
                String fieldName = item.ident.text().toString();
                for (CsmMember csmMember : context.getMembers()) {
                    if (!CsmKindUtilities.isField((CsmObject)csmMember) || !fieldName.equals(csmMember.getName().toString())) continue;
                    fieldType = ((CsmField)csmMember).getType();
                    if (fieldType != null) {
                        classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)fieldType.getClassifier(), (CsmFile)fieldType.getContainingFile());
                        arrayDepth = fieldType.getArrayDepth();
                        arrayDepth += fieldType.isPointer() ? 1 : 0;
                    }
                    break;
                }
            } else {
                CsmMember member;
                if (contextArrayDepth > 0) {
                    --contextArrayDepth;
                    continue;
                }
                Iterator memberIter = context.getMembers().iterator();
                for (int counter = 0; counter < item.position && memberIter.hasNext(); ++counter) {
                    memberIter.next();
                }
                if (memberIter.hasNext() && CsmKindUtilities.isField((CsmObject)(member = (CsmMember)memberIter.next())) && (fieldType = ((CsmField)member).getType()) != null) {
                    classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)fieldType.getClassifier(), (CsmFile)fieldType.getContainingFile());
                    arrayDepth = fieldType.getArrayDepth();
                    arrayDepth += fieldType.isPointer() ? 1 : 0;
                }
            }
            if (CsmKindUtilities.isClass(classifier)) {
                context = (CsmClass)classifier;
                contextArrayDepth = arrayDepth;
            }
            if (classifier != null) continue;
            context = null;
            break;
        }
        return context;
    }

    private static int getStartIndexToResolveInitializerContext(List<InitPathItem> pathSequence) {
        int lastCompoundLiteralIndex = 0;
        Iterator<InitPathItem> itemIter = pathSequence.iterator();
        for (int index = 0; index < pathSequence.size() - 1; ++index) {
            InitPathItem item = itemIter.next();
            if (item.compoundLiteral == null) continue;
            lastCompoundLiteralIndex = index;
        }
        return lastCompoundLiteralIndex;
    }

    private static Token<TokenId> findToken(TokenSequence<TokenId> ts, boolean backward, boolean restoreTs, List<? extends TokenId> targetTokens, TokenId ... skipTokens) {
        int offset = ts.offset();
        Token result = null;
        while (backward ? ts.movePrevious() : ts.moveNext()) {
            Token token = ts.token();
            for (TokenId tokenId : targetTokens) {
                if (!tokenId.equals(token.id())) continue;
                result = token;
                break;
            }
            if (result != null) break;
            boolean skip = false;
            for (TokenId tId : skipTokens) {
                if (!tId.equals(token.id())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            break;
        }
        if (restoreTs) {
            ts.move(offset);
            ts.moveNext();
        }
        return result;
    }

    private static boolean isTokenOneOf(Token<TokenId> token, TokenId ... tokens) {
        if (token != null) {
            for (TokenId tokId : tokens) {
                if (!tokId.equals(token.id())) continue;
                return true;
            }
        }
        return false;
    }

    public static CsmFunction getFunction(CsmContext context, boolean inScope) {
        CsmFunction result = null;
        for (int i = context.size() - 1; 0 <= i; --i) {
            CsmScope scope = context.get(i).getScope();
            int offset = context.getOffset();
            if (!CsmKindUtilities.isFunction((CsmObject)scope) || inScope && !CsmOffsetUtilities.isInFunctionScope((CsmFunction)scope, offset)) continue;
            result = (CsmFunction)scope;
            if (CsmKindUtilities.isLambda((CsmObject)scope)) continue;
            return result;
        }
        return result;
    }

    public static CsmFunctionInstantiation getFunctionInstantiation(CsmContext context, boolean inScope) {
        for (int i = context.size() - 1; 0 <= i; --i) {
            CsmScope scope = context.get(i).getScope();
            int offset = context.getOffset();
            if (!CsmKindUtilities.isFunctionExplicitInstantiation((CsmObject)scope) || inScope && !CsmOffsetUtilities.isInObject((CsmObject)scope, offset)) continue;
            return (CsmFunctionInstantiation)scope;
        }
        return null;
    }

    public static CsmFunctionDefinition getFunctionDefinition(CsmContext context) {
        CsmFunctionDefinition fun = null;
        Iterator<CsmContext.CsmContextEntry> it = context.iterator();
        while (it.hasNext()) {
            CsmContext.CsmContextEntry elem = it.next();
            if (!CsmKindUtilities.isFunctionDefinition((CsmObject)elem.getScope())) continue;
            fun = (CsmFunctionDefinition)elem.getScope();
            break;
        }
        return fun;
    }

    public static CsmNamespace getNamespace(CsmContext context) {
        CsmNamespace ns;
        CsmFunction fun = CsmContextUtilities.getFunction(context, false);
        if (fun != null) {
            ns = CsmContextUtilities.getFunctionNamespace(fun);
        } else {
            CsmClass cls = CsmContextUtilities.getClass(context, false, false);
            CsmNamespace csmNamespace = ns = cls == null ? null : CsmContextUtilities.getClassNamespace(cls);
        }
        if (ns == null) {
            ListIterator<CsmContext.CsmContextEntry> it = context.reverseIterator();
            while (it.hasPrevious()) {
                CsmContext.CsmContextEntry elem = it.previous();
                if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)elem.getScope())) continue;
                ns = ((CsmNamespaceDefinition)elem.getScope()).getNamespace();
                break;
            }
        }
        return ns;
    }

    private static CsmNamespace getFunctionNamespace(CsmFunction fun) {
        return CsmBaseUtilities.getFunctionNamespace((CsmFunction)fun);
    }

    private static CsmNamespace getClassNamespace(CsmClass cls) {
        return CsmBaseUtilities.getClassNamespace((CsmClassifier)cls);
    }

    public static boolean isInFunctionBodyOrInitializerListOrCastOperatorType(CsmContext context, int offset) {
        return CsmContextUtilities.isInFunctionBody(context, offset) || CsmContextUtilities.isInInitializerList(context, offset) || CsmContextUtilities.isInCastOperatorType(context, offset);
    }

    public static boolean isInCastOperatorType(CsmContext context, int offset) {
        CsmFunctionDefinition funDef = CsmContextUtilities.getFunctionDefinition(context);
        if (funDef != null && CsmKindUtilities.isCastOperator((CsmObject)funDef)) {
            return CsmOffsetUtilities.isInObject((CsmObject)funDef.getReturnType(), offset);
        }
        return false;
    }

    public static boolean isInFunctionBody(CsmContext context, int offset) {
        CsmFunctionDefinition funDef = CsmContextUtilities.getFunctionDefinition(context);
        return funDef == null ? false : CsmOffsetUtilities.isInObject((CsmObject)funDef.getBody(), offset);
    }

    public static boolean isInInitializerList(CsmContext context, int offset) {
        CsmVariable var;
        CsmExpression initialValue;
        CsmFunction f = CsmContextUtilities.getFunction(context, false);
        if (CsmKindUtilities.isConstructor((CsmObject)f)) {
            for (CsmExpression izer : ((CsmInitializerListContainer)f).getInitializerList()) {
                if (!CsmOffsetUtilities.isInObject((CsmObject)izer, offset)) continue;
                return true;
            }
        }
        return CsmKindUtilities.isVariable((CsmObject)context.getLastObject()) && (initialValue = (var = (CsmVariable)context.getLastObject()).getInitialValue()) != null && CsmOffsetUtilities.isInObject((CsmObject)initialValue, offset);
    }

    public static boolean isInFunction(CsmContext context, int offset) {
        CsmFunction fun = CsmContextUtilities.getFunction(context, true);
        return fun != null;
    }

    public static boolean isInFunctionInstantiation(CsmContext context, int offset) {
        CsmFunctionInstantiation fi = CsmContextUtilities.getFunctionInstantiation(context, true);
        return fi != null;
    }

    public static boolean isInSimpleType(CsmContext context, int offset) {
        CsmType type = CsmContextUtilities.extractLastType(context, offset);
        return type != null && !type.isInstantiation() && !CsmContextUtilities.checkDecltype(type) && !CsmKindUtilities.isFunctionPointerType((CsmObject)type) && CsmOffsetUtilities.isInObject((CsmObject)type, offset);
    }

    public static boolean isInForwardDeclaration(CsmContext context, int offset) {
        CsmObject last = context.getLastObject();
        return CsmKindUtilities.isClassForwardDeclaration((CsmObject)last);
    }

    public static boolean isInType(CsmContext context, int offset) {
        CsmType type = CsmContextUtilities.extractLastType(context, offset);
        return type != null && CsmOffsetUtilities.isInObject((CsmObject)type, offset);
    }

    private static CsmType extractLastType(CsmContext context, int offset) {
        CsmObject last = context.getLastObject();
        CsmType type = null;
        if (CsmKindUtilities.isTypedef((CsmObject)last) || CsmKindUtilities.isTypeAlias((CsmObject)last)) {
            type = ((CsmTypedef)last).getType();
        } else if (CsmKindUtilities.isType((CsmObject)last)) {
            type = (CsmType)last;
        }
        return type;
    }

    static boolean checkDecltype(CsmType type) {
        CharSequence classifierText = type.getClassifierText();
        if (CharSequenceUtils.indexOf((CharSequence)classifierText, (CharSequence)"decltype") >= 0) {
            String[] nameParts;
            String fullName = classifierText.toString();
            for (String part : nameParts = fullName.split("::")) {
                if (!part.equals("decltype")) continue;
                return true;
            }
        }
        return false;
    }

    private static final class ContextClassInitializerData {
        public final TokenSequence<TokenId> cppts;
        public final List<InitPathItem> lastPathSequence;

        public ContextClassInitializerData(TokenSequence<TokenId> cppts, List<InitPathItem> lastPathSequence) {
            this.cppts = cppts;
            this.lastPathSequence = lastPathSequence;
        }
    }

    private static final class InitPathItem {
        public final Token<TokenId> ident;
        public final Pair<String, Integer> compoundLiteral;
        public final int position;
        public final int offset;

        public InitPathItem(Token<TokenId> ident, Pair<String, Integer> compoundLiteral, int position, int offset) {
            this.ident = ident;
            this.compoundLiteral = compoundLiteral;
            this.position = position;
            this.offset = offset;
        }

        public boolean isIdentBased() {
            return this.ident != null && this.ident.text() != null;
        }

        public String toString() {
            String posDescriptor;
            String string = posDescriptor = this.isIdentBased() ? "[" + this.ident.text() + ", " + this.position + "]" : "[" + this.position + "]";
            if (this.compoundLiteral != null) {
                return "(" + (String)this.compoundLiteral.first() + "[" + this.compoundLiteral.second() + "])" + posDescriptor;
            }
            return posDescriptor;
        }
    }

    private static final class ObjectKey {
        private final Object obj;

        public ObjectKey(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectKey other = (ObjectKey)obj;
            return this.obj == other.obj;
        }
    }
}

