/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionItem;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileObjectFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ExtensionList;
import org.openide.util.Exceptions;

public class CsmIncludeCompletionQuery {
    private static final Collection<String> EXCLUDED_DIR_NAMES = Arrays.asList("CVS", ".hg", "nbproject", "SCCS", "SunWS_cache");
    private Map<String, CsmIncludeCompletionItem> results;
    private final CsmFile file;

    public CsmIncludeCompletionQuery(CsmFile file) {
        this.file = file;
    }

    public Collection<CsmIncludeCompletionItem> query(BaseDocument doc, String childSubDir, int substitutionOffset, int substitutionDelta, Boolean usrInclude, boolean showAll) {
        FileObject usrDir;
        FileSystem docFileSystem;
        this.results = new HashMap<String, CsmIncludeCompletionItem>(100);
        CsmFile docFile = this.file;
        if (docFile == null) {
            docFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        }
        FileObject baseFile = null;
        if (docFile != null) {
            baseFile = docFile.getFileObject();
        }
        if (baseFile == null) {
            baseFile = CsmUtilities.getFileObject((Document)doc);
        }
        if (baseFile == null) {
            baseFile = NbEditorUtilities.getFileObject((Document)doc);
        }
        if (baseFile == null || !baseFile.isValid()) {
            return Collections.emptyList();
        }
        try {
            docFileSystem = baseFile.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return this.results.values();
        }
        Collection<Object> usrPaths = Collections.emptyList();
        Collection<Object> sysPaths = Collections.emptyList();
        if (CndPathUtilities.isPathAbsolute((CharSequence)childSubDir)) {
            this.addFolderItems(new IncludePath(FSPath.toFSPath((FileObject)docFileSystem.getRoot())), "", childSubDir, true, usrInclude != null ? usrInclude : false, true, substitutionOffset, substitutionDelta);
            return this.results.values();
        }
        if (docFile != null) {
            usrPaths = this.getFileIncludes(docFile, false);
            sysPaths = this.getFileIncludes(docFile, true);
        }
        if ((usrDir = baseFile.getParent()) != null && usrDir.isValid()) {
            if (usrInclude == null || usrInclude == Boolean.TRUE) {
                this.addFolderItems(new IncludePath(FSPath.toFSPath((FileObject)usrDir)), ".", childSubDir, false, false, true, substitutionOffset, substitutionDelta);
                if (showAll) {
                    for (IncludePath includePath : usrPaths) {
                        this.addFolderItems(includePath, includePath.getFSPath().getPath(), childSubDir, false, false, true, substitutionOffset, substitutionDelta);
                    }
                    for (IncludePath includePath : sysPaths) {
                        this.addFolderItems(includePath, includePath.getFSPath().getPath(), childSubDir, false, true, false, substitutionOffset, substitutionDelta);
                    }
                }
                if (usrDir.getParent() != null) {
                    this.addParentFolder(substitutionOffset, substitutionDelta, childSubDir, false);
                }
            } else {
                for (IncludePath includePath : sysPaths) {
                    this.addFolderItems(includePath, includePath.getFSPath().getPath(), childSubDir, false, true, false, substitutionOffset, substitutionDelta);
                }
                if (showAll) {
                    for (IncludePath includePath : usrPaths) {
                        this.addFolderItems(includePath, includePath.getFSPath().getPath(), childSubDir, false, false, true, substitutionOffset, substitutionDelta);
                    }
                    this.addFolderItems(new IncludePath(FSPath.toFSPath((FileObject)usrDir)), ".", childSubDir, false, false, true, substitutionOffset, substitutionDelta);
                    if (usrDir.getParent() != null) {
                        this.addParentFolder(substitutionOffset, substitutionDelta, childSubDir, true);
                    }
                }
            }
        }
        return this.results.values();
    }

    private void addFolderItems(IncludePath parentFolder, String parentFolderPresentation, String childSubDir, boolean highPriority, boolean system, boolean filtered, int substitutionOffset, int substitutionDelta) {
        FileObject dir;
        FileObject parentFO = parentFolder.getFSPath().getFileObject();
        if (parentFO != null && (dir = parentFolder.isFramework() ? parentFO.getFileObject(childSubDir.replace("/", ".framework/Headers/")) : parentFO.getFileObject(childSubDir)) != null && dir.isValid()) {
            FileObject[] list;
            FileObject[] fileObjectArray = list = filtered ? this.listFiles(dir, new HeadersFileFilter()) : this.listFiles(dir, new DefFileFilter());
            if (list != null) {
                for (FileObject curFile : list) {
                    String relFileName = curFile.getNameExt();
                    if (parentFolder.isFramework() && curFile.isFolder() && relFileName.endsWith(".framework")) {
                        relFileName = relFileName.substring(0, relFileName.lastIndexOf(46));
                    }
                    CsmIncludeCompletionItem item = CsmIncludeCompletionItem.createItem(substitutionOffset, substitutionDelta, relFileName, parentFolderPresentation, childSubDir, system, highPriority, curFile.isFolder(), true);
                    if (this.results.containsKey(relFileName)) continue;
                    this.results.put(relFileName, item);
                }
            }
        }
    }

    private FileObject[] listFiles(FileObject parent, FileObjectFilter filter) {
        FileObject[] children = parent.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>(children.length);
        for (FileObject child : children) {
            if (!filter.accept(child)) continue;
            result.add(child);
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private void addParentFolder(int substitutionOffset, int substitutionDelta, String childSubDir, boolean system) {
        if (!this.results.isEmpty()) {
            CsmIncludeCompletionItem item = CsmIncludeCompletionItem.createItem(substitutionOffset, substitutionDelta, "..", ".", childSubDir, system, false, true, false);
            this.results.put("..", item);
        }
    }

    private Collection<IncludePath> getFileIncludes(CsmFile file, boolean system) {
        CsmFileInfoQuery query = CsmFileInfoQuery.getDefault();
        return system ? query.getSystemIncludePaths(file) : query.getUserIncludePaths(file);
    }

    private static boolean isHeaderFileWoExt(FileObject pathname) {
        if (FileUtil.getExtension((String)pathname.getNameExt()).length() == 0) {
            return "text/x-h".equals(MIMESupport.getSourceFileMIMEType((FileObject)pathname));
        }
        return false;
    }

    private static boolean specialFile(FileObject file) {
        String name = file.getNameExt();
        if (name.startsWith(".")) {
            return true;
        }
        if (name.endsWith("~")) {
            return true;
        }
        return file.isFolder() && EXCLUDED_DIR_NAMES.contains(name);
    }

    private static final class HeadersFileFilter
    implements FileObjectFilter {
        private final ExtensionList exts = new ExtensionList();

        protected HeadersFileFilter() {
            for (String ext : MIMEExtensions.get((String)"text/x-h").getValues()) {
                this.exts.addExtension(ext);
            }
        }

        public boolean accept(FileObject pathname) {
            return !CsmIncludeCompletionQuery.specialFile(pathname) && (this.exts.isRegistered(pathname.getNameExt()) || pathname.isFolder() || CsmIncludeCompletionQuery.isHeaderFileWoExt(pathname));
        }
    }

    private static final class DefFileFilter
    implements FileObjectFilter {
        private DefFileFilter() {
        }

        public boolean accept(FileObject fileObject) {
            return !CsmIncludeCompletionQuery.specialFile(fileObject);
        }
    }
}

