/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class RealTypeSerializer
implements JavonSerializer {
    private final ClassData floatClassData = new ClassData("", "float", true, false, (JavonSerializer)this);
    private final ClassData doubleClassData = new ClassData("", "double", true, false, (JavonSerializer)this);
    private final ClassData FloatClassData = new ClassData("java.lang", "Float", false, false, (JavonSerializer)this);
    private final ClassData DoubleClassData = new ClassData("java.lang", "Double", false, false, (JavonSerializer)this);

    @Override
    public String getName() {
        return "Real numbers serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.ARRAY == type.getKind()) {
            return false;
        }
        if (TypeKind.FLOAT == type.getKind()) {
            return true;
        }
        if (TypeKind.DOUBLE == type.getKind()) {
            return true;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String fqn = clazz.getQualifiedName().toString();
            if ("java.lang.Float".equals(fqn)) {
                return true;
            }
            if ("java.lang.Double".equals(fqn)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.FLOAT == type.getKind()) {
            return this.floatClassData;
        }
        if (TypeKind.DOUBLE == type.getKind()) {
            return this.doubleClassData;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String fqn = clazz.getQualifiedName().toString();
            if ("java.lang.Float".equals(fqn)) {
                return this.FloatClassData;
            }
            if ("java.lang.Double".equals(fqn)) {
                return this.DoubleClassData;
            }
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping mapping, ClassData type) {
        if (mapping.getProperty("floatingPoint").equals(Boolean.FALSE) && mapping.getProperty("target").equals("client")) {
            if (this.floatClassData.equals(type) || this.FloatClassData.equals(type)) {
                return "String";
            }
            if (this.doubleClassData.equals(type) || this.DoubleClassData.equals(type)) {
                return "String";
            }
        } else {
            if (this.floatClassData.equals(type)) {
                return "float";
            }
            if (this.FloatClassData.equals(type)) {
                return "Float";
            }
            if (this.doubleClassData.equals(type)) {
                return "double";
            }
            if (this.DoubleClassData.equals(type)) {
                return "Double";
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toObject(JavonMapping mapping, ClassData type, String variable) {
        if (mapping.getProperty("floatingPoint").equals(Boolean.FALSE) && mapping.getProperty("target").equals("client")) {
            if (this.floatClassData.equals(type) || this.doubleClassData.equals(type) || this.FloatClassData.equals(type) || this.DoubleClassData.equals(type)) {
                return "(String)" + variable;
            }
        } else {
            if (this.floatClassData.equals(type)) {
                return "new Float(" + variable + ")";
            }
            if (this.doubleClassData.equals(type)) {
                return "new Double(" + variable + ")";
            }
            if (this.FloatClassData.equals(type)) {
                return "(Float)" + variable;
            }
            if (this.DoubleClassData.equals(type)) {
                return "(Double)" + variable;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromObject(JavonMapping mapping, ClassData type, String object) {
        if (mapping.getProperty("floatingPoint").equals(Boolean.FALSE) && mapping.getProperty("target").equals("client")) {
            if (this.floatClassData.equals(type) || this.doubleClassData.equals(type) || this.FloatClassData.equals(type) || this.DoubleClassData.equals(type)) {
                return "(String)" + object;
            }
        } else {
            if (this.floatClassData.equals(type)) {
                return "((Float)" + object + ").floatValue()";
            }
            if (this.doubleClassData.equals(type)) {
                return "((Double)" + object + ").doubleValue()";
            }
            if (this.FloatClassData.equals(type)) {
                return "(Float)" + object;
            }
            if (this.DoubleClassData.equals(type)) {
                return "(Double)" + object;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toStream(JavonMapping mapping, ClassData type, String stream, String object) {
        if (mapping.getProperty("floatingPoint").equals(Boolean.TRUE)) {
            if (this.floatClassData.equals(type)) {
                return stream + ".writeFloat( " + object + " );";
            }
            if (this.FloatClassData.equals(type)) {
                return stream + ".writeFloat( " + this.fromObject(mapping, this.floatClassData, object) + " );";
            }
            if (this.doubleClassData.equals(type)) {
                return stream + ".writeDouble( " + object + " );";
            }
            if (this.DoubleClassData.equals(type)) {
                return stream + ".writeDouble( " + this.fromObject(mapping, this.doubleClassData, object) + " );";
            }
        } else if (mapping.getProperty("target").equals("server")) {
            if (this.floatClassData.equals(type)) {
                return stream + ".writeUTF(new Float(" + object + ").toString());";
            }
            if (this.FloatClassData.equals(type)) {
                return stream + ".writeUTF(" + object + ".toString());";
            }
            if (this.doubleClassData.equals(type)) {
                return stream + ".writeUTF(new Double(" + object + ").toString());";
            }
            if (this.DoubleClassData.equals(type)) {
                return stream + ".writeUTF( " + object + ".toString());";
            }
        } else if (mapping.getProperty("target").equals("client")) {
            if (this.floatClassData.equals(type)) {
                return stream + ".writeUTF( " + object + " );";
            }
            if (this.FloatClassData.equals(type)) {
                return stream + ".writeUTF( " + object + " );";
            }
            if (this.doubleClassData.equals(type)) {
                return stream + ".writeUTF( " + object + " );";
            }
            if (this.DoubleClassData.equals(type)) {
                return stream + ".writeUTF( " + object + " );";
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromStream(JavonMapping mapping, ClassData type, String stream, String object) {
        String result = "";
        if (object != null) {
            result = object + " = ";
        }
        if (mapping.getProperty("floatingPoint").equals(Boolean.TRUE)) {
            if (this.floatClassData.equals(type)) {
                result = result + stream + ".readFloat()";
            } else if (this.FloatClassData.equals(type)) {
                result = result + this.toObject(mapping, this.floatClassData, stream + ".readFloat()");
            } else if (this.doubleClassData.equals(type)) {
                result = result + stream + ".readDouble()";
            } else if (this.DoubleClassData.equals(type)) {
                result = result + this.toObject(mapping, this.doubleClassData, stream + ".readDouble()");
            }
        } else if (mapping.getProperty("target").equals("server")) {
            if (this.floatClassData.equals(type)) {
                result = result + "new Float(" + stream + ".readUTF())";
            } else if (this.FloatClassData.equals(type)) {
                result = result + "new Float(" + stream + ".readUTF())";
            } else if (this.doubleClassData.equals(type)) {
                result = result + "new Double(" + stream + ".readUTF())";
            } else if (this.DoubleClassData.equals(type)) {
                result = result + "new Double(" + stream + ".readUTF())";
            }
        } else if (mapping.getProperty("target").equals("client")) {
            if (this.floatClassData.equals(type)) {
                result = result + stream + ".readUTF()";
            } else if (this.FloatClassData.equals(type)) {
                result = result + stream + ".readUTF()";
            } else if (this.doubleClassData.equals(type)) {
                result = result + stream + ".readUTF()";
            } else if (this.DoubleClassData.equals(type)) {
                result = result + stream + ".readUTF()";
            }
        }
        if ("".equals(result)) {
            throw new IllegalArgumentException("Invalid type: " + type.getName());
        }
        if (object != null) {
            result = result + ";";
        }
        return result;
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData rootClassData, Set<ClassData> usedTypes) {
        return Collections.singleton(rootClassData);
    }
}

