/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class MakefileCustomizerNode
extends CustomizerNode {
    private static final RequestProcessor RP = new RequestProcessor("MakeConfiguration", 1);

    public MakefileCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        Sheet sheet = this.getSheet(((MakeConfiguration)configuration).getMakefileConfiguration());
        return new Sheet[]{sheet};
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsMake");
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakefileCustomizerNode.class).getString(s);
    }

    private Sheet getSheet(MakefileConfiguration conf) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Makefile");
        set.setDisplayName(MakefileCustomizerNode.getString("MakefileTxt"));
        set.setShortDescription(MakefileCustomizerNode.getString("MakefileHint"));
        set.put((Node.Property)new DirStringNodeProp(conf.getBuildCommandWorkingDir(), "WorkingDirectory", MakefileCustomizerNode.getString("WorkingDirectory_LBL"), MakefileCustomizerNode.getString("WorkingDirectory_TT"), conf));
        set.put((Node.Property)new StringNodeProp(conf.getBuildCommand(), "BuildCommandLine", MakefileCustomizerNode.getString("BuildCommandLine_LBL"), MakefileCustomizerNode.getString("BuildCommandLine_TT")));
        set.put((Node.Property)new StringNodeProp(conf.getCleanCommand(), "CleanCommandLine", MakefileCustomizerNode.getString("CleanCommandLine_LBL"), MakefileCustomizerNode.getString("CleanCommandLine_TT")));
        set.put((Node.Property)new OutputStringNodeProp(conf.getOutput(), "BuildResult", MakefileCustomizerNode.getString("BuildResult_LBL"), MakefileCustomizerNode.getString("BuildResult_TT"), conf));
        sheet.put(set);
        return sheet;
    }

    private static ExecutionEnvironment getSourceExecutionEnvironment(MakefileConfiguration conf) {
        ExecutionEnvironment env = null;
        MakeConfiguration mc = conf.getMakeConfiguration();
        if (mc != null) {
            return FileSystemProvider.getExecutionEnvironment((FileSystem)mc.getBaseFSPath().getFileSystem());
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private static class ElfChooserInitializer
    implements Callable<String> {
        private final ExecutionEnvironment execEnv;
        private final PathMap pathMap;
        private final String seed;
        private final List<FileFilter> filters;
        private final CountDownLatch latch;

        public ElfChooserInitializer(ExecutionEnvironment execEnv, PathMap pathMap, String seed, List<FileFilter> filters, CountDownLatch latch) {
            this.execEnv = execEnv;
            this.pathMap = pathMap;
            this.seed = seed;
            this.filters = filters;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            String realSeed = this.seed;
            try {
                HostInfo hostInfo = null;
                try {
                    ConnectionManager.getInstance().connectTo(this.execEnv);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                catch (ConnectionManager.CancellationException e) {
                    // empty catch block
                }
                if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.execEnv)) {
                    hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
                }
                if (this.pathMap != null && this.seed != null) {
                    realSeed = this.pathMap.getRemotePath(this.seed, true);
                }
                FileObject seedFo = FileSystemProvider.getFileObject((ExecutionEnvironment)this.execEnv, (String)realSeed);
                while (seedFo == null && realSeed.length() > 1) {
                    realSeed = PathUtilities.getDirName((String)realSeed);
                    seedFo = FileSystemProvider.getFileObject((ExecutionEnvironment)this.execEnv, (String)realSeed);
                }
                this.filters.add((FileFilter)FileFilterFactory.getAllBinaryFileFilter());
                if (hostInfo != null) {
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                        this.filters.add((FileFilter)FileFilterFactory.getPeExecutableFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getPeStaticLibraryFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getPeDynamicLibraryFileFilter());
                    } else if (hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX) {
                        this.filters.add((FileFilter)FileFilterFactory.getMacOSXExecutableFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getElfStaticLibraryFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getMacOSXDynamicLibraryFileFilter());
                    } else {
                        this.filters.add((FileFilter)FileFilterFactory.getElfExecutableFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getElfStaticLibraryFileFilter());
                        this.filters.add((FileFilter)FileFilterFactory.getElfDynamicLibraryFileFilter());
                    }
                }
            }
            finally {
                this.latch.countDown();
            }
            return realSeed;
        }
    }

    private static final class ElfEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;
        private final MakefileConfiguration conf;

        public ElfEditor(String seed, MakefileConfiguration conf) {
            this.seed = seed;
            this.conf = conf;
        }

        @Override
        public void setAsText(String text) {
            this.conf.getOutput().setValue(text);
        }

        @Override
        public String getAsText() {
            return this.conf.getOutput().getValue();
        }

        @Override
        public Object getValue() {
            return this.conf.getOutput().getValue();
        }

        @Override
        public void setValue(Object v) {
            this.conf.getOutput().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return this.createElfPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }

        private JFileChooser createElfPanel(String seed, PropertyEditorSupport editor, PropertyEnv propenv) {
            MakeConfiguration mc = this.conf.getMakeConfiguration();
            RemoteSyncFactory syncFactory = mc == null ? null : mc.getRemoteSyncFactory();
            ExecutionEnvironment execEnv = mc != null && syncFactory != null && syncFactory.isCopying() ? mc.getDevelopmentHost().getExecutionEnvironment() : MakefileCustomizerNode.getSourceExecutionEnvironment(this.conf);
            PathMap pathMap = syncFactory != null && syncFactory.isCopying() ? syncFactory.getPathMap(execEnv) : null;
            CountDownLatch latch = new CountDownLatch(1);
            List<FileFilter> filters = Collections.synchronizedList(new ArrayList());
            JFileChooser chooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)execEnv, (String)"", (String)"", (int)0, null, (Callable)new ElfChooserInitializer(execEnv, pathMap, seed, filters, latch), (boolean)true);
            chooser.setControlButtonsAreShown(false);
            chooser.putClientProperty("title", chooser.getDialogTitle());
            this.setElfFilters(chooser, filters, latch);
            propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propenv.addPropertyChangeListener(evt -> {
                File selectedFile = chooser.getSelectedFile();
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID && selectedFile != null) {
                    String path = selectedFile.getPath();
                    if (pathMap != null) {
                        String newPath = pathMap.getTrueLocalPath(path);
                        path = newPath == null ? "//" + path : newPath;
                    }
                    path = CndPathUtilities.toRelativePath((String)this.conf.getMakeConfiguration().getBaseDir(), (String)path);
                    path = CndPathUtilities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            });
            return chooser;
        }

        private void setElfFilters(JFileChooser chooser, List<FileFilter> filters, CountDownLatch latch) {
            Runnable setFiltersRunner = () -> {
                filters.forEach(f -> chooser.addChoosableFileFilter((FileFilter)f));
                if (!filters.isEmpty()) {
                    chooser.setFileFilter((FileFilter)filters.get(0));
                }
            };
            Runnable waiter = () -> {
                try {
                    latch.await();
                    SwingUtilities.invokeLater(setFiltersRunner);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            };
            RP.post(waiter);
        }
    }

    private static class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private final String seed;
        private final MakefileConfiguration conf;

        public DirEditor(String seed, MakefileConfiguration conf) {
            this.seed = seed;
            this.conf = conf;
        }

        @Override
        public void setAsText(String text) {
            this.conf.getBuildCommandWorkingDir().setValue(text);
        }

        @Override
        public String getAsText() {
            return this.conf.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public Object getValue() {
            return this.conf.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public void setValue(Object v) {
            this.conf.getBuildCommandWorkingDir().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return this.createDirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }

        private JFileChooser createDirPanel(String seed, PropertyEditorSupport editor, PropertyEnv propenv) {
            String titleText = NbBundle.getMessage(MakefileCustomizerNode.class, (String)"Run_Directory");
            String buttonText = NbBundle.getMessage(MakefileCustomizerNode.class, (String)"SelectLabel");
            JFileChooser chooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)MakefileCustomizerNode.getSourceExecutionEnvironment(this.conf), (String)titleText, (String)buttonText, (int)1, null, (String)seed, (boolean)true);
            chooser.putClientProperty("title", chooser.getDialogTitle());
            chooser.setControlButtonsAreShown(false);
            propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propenv.addPropertyChangeListener(evt -> {
                if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                    File selectedFile = chooser.getSelectedFile();
                    String path = CndPathUtilities.toRelativePath((String)this.conf.getMakeConfiguration().getBaseDir(), (String)selectedFile.getPath());
                    path = CndPathUtilities.normalizeSlashes((String)path);
                    editor.setValue(path);
                }
            });
            return chooser;
        }
    }

    private static class OutputStringNodeProp
    extends StringNodeProp {
        private final MakefileConfiguration conf;

        public OutputStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3, MakefileConfiguration conf) {
            super(stringConfiguration, txt1, txt2, txt3);
            this.conf = conf;
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilities.toRelativePath((String)this.conf.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            String seed = this.conf.getAbsOutput();
            if (seed.length() == 0) {
                seed = this.conf.getMakeConfiguration().getBaseDir();
            }
            return new ElfEditor(seed, this.conf);
        }
    }

    private static class DirStringNodeProp
    extends StringNodeProp {
        private final MakefileConfiguration conf;

        public DirStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3, MakefileConfiguration conf) {
            super(stringConfiguration, txt1, txt2, txt3);
            this.conf = conf;
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilities.toRelativePath((String)this.conf.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilities.normalizeSlashes((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(this.conf.getAbsBuildCommandWorkingDir(), this.conf);
        }
    }
}

