/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.api;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class SVNUrl {
    public static final String SVN_PROTOCOL = "svn";
    public static final String SVNSSH_PROTOCOL = "svn+ssh";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String FILE_PROTOCOL = "file";
    private final String protocol;
    private final String host;
    private final int port;
    private final String[] path;

    public SVNUrl(String url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("SVN URL cannot be NULL.");
        }
        String tmp = url.trim();
        int i = tmp.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException("Invalid SVN URL: " + url);
        }
        this.protocol = tmp.substring(0, i).toLowerCase(Locale.ENGLISH);
        if (!(SVN_PROTOCOL.equals(this.protocol) || SVNSSH_PROTOCOL.equals(this.protocol) || HTTP_PROTOCOL.equals(this.protocol) || HTTPS_PROTOCOL.equals(this.protocol) || FILE_PROTOCOL.equals(this.protocol))) {
            throw new MalformedURLException("Unsupported protocol of SVN URL: " + url);
        }
        if ((tmp = tmp.substring(i + 3)).isEmpty()) {
            throw new MalformedURLException("Invalid path of SVN URL: " + url);
        }
        i = tmp.indexOf(47);
        if (i < 0) {
            i = tmp.length();
        }
        if (FILE_PROTOCOL.equals(this.protocol)) {
            this.port = -1;
            this.host = i == 0 ? "" : tmp.substring(0, i);
        } else {
            String hostAndPort = tmp.substring(0, i).toLowerCase(Locale.ENGLISH);
            String[] split = hostAndPort.split(":");
            if (split.length == 1) {
                this.host = split[0];
                this.port = this.getDefaultPort(this.protocol);
            } else if (split.length == 2) {
                this.host = split[0];
                try {
                    this.port = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException("Invalid port of SVN URL: " + url);
                }
            } else {
                throw new MalformedURLException("Invalid SVN URL: " + url);
            }
        }
        if (i < tmp.length()) {
            tmp = tmp.substring(i + 1);
            this.path = tmp.split("/");
        } else {
            this.path = new String[0];
        }
    }

    private int getDefaultPort(String protocol) {
        switch (protocol) {
            case "https": {
                return 443;
            }
            case "http": {
                return 80;
            }
            case "svn+ssh": {
                return 22;
            }
            case "svn": {
                return 3690;
            }
        }
        return -1;
    }

    private SVNUrl(String protocol, String host, int port, String[] path) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SVNUrl appendPath(String append) {
        ArrayList<String> res = new ArrayList<String>(Arrays.asList(this.path));
        for (String s : append.split("/")) {
            if (s.isEmpty()) continue;
            res.add(s);
        }
        return new SVNUrl(this.protocol, this.host, this.port, res.toArray(new String[res.size()]));
    }

    public String[] getPathSegments() {
        return this.path;
    }

    public String getLastPathSegment() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public SVNUrl getParent() {
        if (this.path.length < 2 || this.host.isEmpty()) {
            return null;
        }
        String[] parent = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, parent, 0, this.path.length - 1);
        return new SVNUrl(this.protocol, this.host, this.port, parent);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.protocol).append("://").append(this.host);
        if (this.port != this.getDefaultPort(this.protocol)) {
            buf.append(':').append(this.port);
        }
        for (String s : this.path) {
            buf.append('/').append(s);
        }
        return buf.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.protocol);
        hash = 89 * hash + Objects.hashCode(this.host);
        hash = 89 * hash + this.port;
        hash = 89 * hash + Arrays.deepHashCode(this.path);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SVNUrl other = (SVNUrl)obj;
        if (!Objects.equals(this.protocol, other.protocol)) {
            return false;
        }
        if (!Objects.equals(this.host, other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return Arrays.deepEquals(this.path, other.path);
    }
}

