/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.stat;

import java.util.Map;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.tool.stat.AbstractTreeModel;

public class StatisticsTreeModel
extends AbstractTreeModel {
    private final Statistics stats;
    String queries = "Queries";
    String entities = "Entities";
    String collections = "Collections";
    String secondlevelcache = "Cache";
    Map im = IdentityMap.instantiateSequenced((int)10);

    public StatisticsTreeModel(Statistics stats) {
        this.stats = stats;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.stats) {
            switch (index) {
                case 0: {
                    return this.entities;
                }
                case 1: {
                    return this.collections;
                }
                case 2: {
                    return this.queries;
                }
                case 3: {
                    return this.secondlevelcache;
                }
            }
        } else {
            if (parent == this.entities) {
                return this.stats.getEntityStatistics(this.stats.getEntityNames()[index]);
            }
            if (parent == this.collections) {
                return this.stats.getCollectionStatistics(this.stats.getCollectionRoleNames()[index]);
            }
            if (parent == this.queries) {
                return this.stats.getQueryStatistics(this.stats.getQueries()[index]);
            }
            if (parent == this.secondlevelcache) {
                return this.stats.getSecondLevelCacheStatistics(this.stats.getSecondLevelCacheRegionNames()[index]);
            }
            if (parent instanceof SecondLevelCacheStatistics) {
                SecondLevelCacheStatistics slcs = (SecondLevelCacheStatistics)parent;
                return slcs.getEntries();
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.stats) {
            return 4;
        }
        if (parent == this.entities) {
            return this.stats.getEntityNames().length;
        }
        if (parent == this.collections) {
            return this.stats.getCollectionRoleNames().length;
        }
        if (parent == this.queries) {
            return this.stats.getQueries().length;
        }
        if (parent == this.secondlevelcache) {
            return this.stats.getSecondLevelCacheRegionNames().length;
        }
        if (parent instanceof SecondLevelCacheStatistics) {
            // empty if block
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        throw new IllegalAccessError();
    }

    @Override
    public Object getRoot() {
        return this.stats;
    }

    @Override
    public boolean isLeaf(Object node) {
        return false;
    }

    public boolean isQueries(Object o) {
        return o == this.queries;
    }

    public boolean isCollections(Object o) {
        return o == this.collections;
    }

    public boolean isEntities(Object o) {
        return o == this.entities;
    }

    public boolean isCache(Object o) {
        return o == this.secondlevelcache;
    }

    public boolean isContainer(Object o) {
        return this.isEntities(o) || this.isQueries(o) || this.isCollections(o) || this.isCache(o);
    }
}

