/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.actions;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.modules.Places;

public class CleanupCachePseudoOptionProcessor
extends OptionProcessor {
    private static final String[] CACHES = new String[]{"cnd", "index"};
    private static final String MARKER_FILE = "cnd-cleanup";

    protected Set<Option> getOptions() {
        for (String cache : CACHES) {
            CleanupCachePseudoOptionProcessor.cleanupCache(cache);
        }
        return Collections.emptySet();
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
    }

    static void markToCleanup() {
        for (String cache : CACHES) {
            CleanupCachePseudoOptionProcessor.markToCleanup(cache);
        }
    }

    private static void markToCleanup(String cacheName) {
        File cleanupFile;
        File cache = Places.getCacheSubdirectory((String)cacheName);
        if (cache.exists() && !(cleanupFile = new File(cache, MARKER_FILE)).exists()) {
            try {
                cleanupFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void cleanupCache(String cacheName) {
        File cleanupFile;
        File cache;
        File cacheDirectory = Places.getCacheDirectory();
        if (cacheDirectory.exists() && (cache = new File(cacheDirectory, cacheName)).exists() && (cleanupFile = new File(cache, MARKER_FILE)).exists()) {
            CleanupCachePseudoOptionProcessor.deleteRecursively(cache);
        }
    }

    public static void deleteRecursively(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                CleanupCachePseudoOptionProcessor.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }
}

